/*
 * <<< mpi_test.c >>>
 *
 * --- Copyright (C) 2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <stdio.h>
#include <mpi.h>

void show(int* buf, int size)
{
	int i;
	printf("%d/%d:", get_punum(), get_puid());
	for (i = 0; i < size; i++) printf(" %02x", buf[i]);
	printf("\n");
}

int main(int argc, char** argv)
{
	const int N = 16;
	int buf[N];
	int punum, puid;
	MPI_Init(&argc, &argv);
	MPI_Comm_rank(MPI_COMM_WORLD, &puid);
	MPI_Comm_size(MPI_COMM_WORLD, &punum);
	if (puid == 0) {
		int i;
		for (i = 0; i < N; i++) buf[i] = i;
	} else {
		int i;
		for (i = 0; i < N; i++) buf[i] = 0;
	}
	show(buf, N);
	switch (puid) {
	case 0:
		MPI_Send(buf, N, MPI_INT, 1, 0, MPI_COMM_WORLD);
		break;
	case 1:
		{
			MPI_Status dummy;
			MPI_Recv(buf, N, MPI_INT, 1, 0, MPI_COMM_WORLD, &dummy);
		}
		break;
	default:
		break;
	}
	show(buf, N);
	MPI_Finalize();
	return 0;
}
