/*
 * <<< mpi_send.c >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi_send.c'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <sys/types.h>
#include "mpi.h"
#include "mpi_local.h"
#include "mpni_io_funcs.h"

int MPI_Send(void* buf, int count, MPI_Datatype dtype, int dst, int tag,
			 MPI_Comm comm)
{
	__MPI_return_code code;
	int sizeof_dtype;
	switch (comm) {
	case MPI_COMM_WORLD:
		sizeof_dtype = __mpi_local_get_sizeof_datatype(dtype);
		if (sizeof_dtype > 0) {
			code = __mpi_local_send(buf, sizeof_dtype * count, dst, tag);
		} else {
			code = MPI_ERR_TYPE;
		}
		break;
	case MPI_COMM_NULL:
		code = MPI_ERR_COMM;
		break;
	case MPI_COMM_SELF:
		/* sorry, not implemented */
		code = MPI_ERR_COMM;
		break;
	default:
		/* sorry, not implemented */
		code = MPI_ERR_COMM;
		break;
	}
	return (int)(code);
}
