/*
 *	<<< first_cache.S >>>
 *
 * --- cache management functions for MIPS CPU 'first_cache.S'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <machine/regdef.h>
#include "cpu.h"

#define MARKER 0xa5a5a5a5

		.globl __invalidate_first_instruction_cache
		.globl __invalidate_first_data_cache

		.align 2
		.sdata

get_first_inst_cache_size_flag:
		.word 0
get_first_data_cache_size_flag:
		.word 0
		.lcomm first_inst_cache_size, 4
		.lcomm first_data_cache_size, 4

		.text

/*
 * static int get_data_cache_size(void);
 */
get_first_data_cache_size:
		/* isolate data cache */
		mfc0	v1, C0_SR
		and		v1, ~SR_PE
		or		v0, v1, SR_ISC
		mtc0	v0, C0_SR
		/*
			get data cache size:
			register const marker = 0xa5a5a5a5;
			register cache_size, tmp;
			*(int*)K0BASE = 0;
			tmp = *(int*)K0BASE;
			if (tmp != marker || ((Cause Register) | SR_CM)) return 0;
			cache_size = 4;
			while (1) {
				*(int*)K0BASE = 0;
				*(int*)K0BASE[cache_size] = marker;
				tmp = *(int*)K0BASE;
				if (tmp == marker) break;
				cache_size *= 2;
				if (cache_size == 0) {
					cache_size = 0x80000000;
					break;
				}
			}
		*/
		li		v0, MARKER
		sw		v0, K0BASE
		lw		v0, K0BASE
		bne		v0, MARKER, 1f
		mfc0	v0, C0_SR
		and		v0, SR_CM
		beqz	v0, 2f
1:		move	v0, zero
		j		4f
2:		li		v0, 4
3:		sw		zero, K0BASE
		li		a0, MARKER
		sw		a0, K0BASE(v0)
		lw		a0, K0BASE
		beq		a0, MARKER, 4f
		mfc0	a0, C0_SR
		and		a0, SR_CM
		bnez	a0, 4f
		sll		v0, 1	
		bnez	v0, 3b
		li		v0, 0x80000000
		/* restore SR */
4:		mtc0	v1, C0_SR
		j		ra

/*
 * static void invalidate_first_data_cache_inner(int data_cache_size);
 */
invalidate_first_data_cache_inner:
		/* isolate data cache */
		mfc0	v1, C0_SR
		and		v1, ~SR_PE
		or		v0, v1, SR_ISC
		mtc0	v0, C0_SR
		/*
			invalidate data cache:
			char* v0 = (char*)(K0BASE);
			char* a0 = (char*)(K0BASE + arg);
		   	do {
				v0[0x00] = '\0';
				...
				v0[0x1c] = '\0';
				v0 += 0x20;
			} while (v0 < a0);
		*/
		li		v0, K0BASE
		add		a0, v0
1:		sb		zero, 0x00(v0)
		sb		zero, 0x10(v0)
		sb		zero, 0x20(v0)
		sb		zero, 0x30(v0)
		add		v0, 0x40
		bltu	v0, a0, 1b
		/* restore SR */
		mtc0	v1, C0_SR
		j		ra

/*
 * void __invalidate_first_instruction_cache(void);
 */
__invalidate_first_instruction_cache:
		move	a1, ra
		mfc0	a2, C0_SR
		and		a2, ~SR_PE
		or		v0, a2, SR_SWC
		mtc0	v0, C0_SR
		lw		v0, get_first_inst_cache_size_flag
		bnez	v0, 1f
		jal		get_first_data_cache_size
		move	a0, v0
		sw		a0, first_inst_cache_size
		li		v0, 1
		sw		v0, get_first_inst_cache_size_flag
		bnez	a0, 2f
		j		3f
1:		lw		a0, first_inst_cache_size
		beqz	a0, 3f
2:		lw		a0, first_inst_cache_size /* dummy read to flush write buffer */
		jal		invalidate_first_data_cache_inner
3:		mtc0	a2, C0_SR
		j		a1

/*
 * void __invalidate_first_data_cache(void);
 */
__invalidate_first_data_cache:
		move	a1, ra
		lw		v0, get_first_data_cache_size_flag
		bnez	v0, 1f
		jal		get_first_data_cache_size
		move	a0, v0
		sw		a0, first_data_cache_size
		li		v0, 1
		sw		v0, get_first_data_cache_size_flag
		bnez	a0, 2f
		j		3f
1:		lw		a0, first_data_cache_size
		beqz	a0, 3f
2:		lw		a0, first_data_cache_size /* dummy read to flush write buffer */
		jal		invalidate_first_data_cache_inner
3:		j		a1
