/*
 * <<< clock.c >>>
 *
 * --- Systemcall handler for isis 'clock.c'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <time.h>
#include "osiris_address.h"

clock_t clock(void)
{
	static timer_setup_flag = 0;
	static clock_t* timer_address;
	if (!timer_setup_flag) {
		int t;
		__multi_io_sysinfo_read_integer("timer_address", &t);
		timer_address = (clock_t*)t;
		timer_setup_flag = 1;
	}
	return *timer_address;
}
