#include <stdio.h>
#include <math.h>
#include <omp.h>

#define MAX 8192
#define LOG_MAX 13
#define N 10

void fft(float x_r[], float x_i[]) 
{
    float tmp_r, tmp_i, tmp_r_lower, tmp_i_lower;
    int i, j, i_lower, index;
    int stage, dft_pts, num_bf, bf_id;
    float pi;

    pi = -2 * M_PI;

    float arg, e, cos_result, sin_result;

    for (stage = 1; stage <= LOG_MAX; stage++) {
        dft_pts = 1 << stage;
        num_bf = dft_pts / 2;
        e = pi / dft_pts;
        for (j = 0; j < num_bf; j++) {
            arg = e * j;
            cos_result = cos(arg);
            sin_result = sin(arg);
            for (i = j; i < MAX; i += dft_pts) {
                i_lower = i + num_bf;

                tmp_r = x_r[i_lower] * cos_result - x_i[i_lower] * sin_result;
                tmp_i = x_i[i_lower] * cos_result + x_r[i_lower] * sin_result;
                x_r[i_lower] = x_r[i] - tmp_r;
                x_i[i_lower] = x_i[i] - tmp_i; 
                x_r[i] = x_r[i] + tmp_r;
                x_i[i] = x_i[i] + tmp_i;
            }
        }
    }
}

unsigned int reverse_bits(unsigned int input)
{
    unsigned int rev = 0;
    int i;

    for (i = 0; i < LOG_MAX; i++) {
        rev = (rev << 1) | (input & 1);
        input = input >> 1;
    }
    return rev;
}

void bit_reverse(float x_r[], float x_i[])
{
    unsigned int reversed, i;
    float tmp;

    for (i = 0; i < MAX; i++) {
        reversed = reverse_bits(i);
        if (i < reversed) {
            tmp = x_r[i];
            x_r[i] = x_r[reversed];
            x_r[reversed] = tmp;
            
            tmp = x_i[i];
            x_i[i] = x_i[reversed];
            x_i[reversed] = tmp;
        }
    }
}

int main() 
{
    float x_r[MAX], x_i[MAX];
    int i;
    int correct_flag = 1;
    double ts, te;

    //initialization
    for (i = 0; i < MAX; i++) {
        x_r[i] = cos(N * 2 * M_PI * i / MAX);
        x_i[i] = 0;
    }

    bit_reverse(x_r, x_i);
    ts = omp_get_wtime();
    fft(x_r, x_i);
    te = omp_get_wtime();

    for (i = 0; i < MAX; i++) {
        if (i == N || i == MAX - N) {
            if (round(x_r[i]) != MAX/2 || round(x_i[i]) != 0)
                correct_flag = 0;
        } else {
            if (round(x_r[i]) != 0 || round(x_i[i]) != 0)
                correct_flag = 0;
        }
    }

    if (correct_flag == 1) {
        printf("time[sec]:%lf\n", te-ts);
    } else {
        fprintf(stderr, "Failed\n");
    }
}
