
/*
 *   hello.c  ---  $B%5%s%W%k%W%m%0%i%`!'(BMPI$BHG%O%m!<%o!<%k%I(B
 */

#include <stdio.h>
#include <mpi.h>
#include <time.h>
#define N 4096

int main(int argc, char **argv)
{
  int pid, nproc, i,j;
  FILE *fin;
  double mat[N];
  double sum, psum;
  double start, startcomp, endcomp;
  MPI_Status status;
	if((fin = fopen("mat4k.dat", "r"))==NULL) {
		fprintf(stderr, "mat.dat is not existing\n");
		exit(1);
	}
  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &pid);
  MPI_Comm_size(MPI_COMM_WORLD, &nproc);

  sum=0.0;
  if (pid == 0) {
    for (i = 0; i<N; i++)  {
		fscanf(fin,"%lf", &mat[i]);
	}
	start = MPI_Wtime();
    for (i = 1; i < nproc; i++) 
      MPI_Send(&mat[0], N, MPI_DOUBLE, i, 0, MPI_COMM_WORLD);
	startcomp = MPI_Wtime();
	sum =0;
	for(i = 0; i < N/nproc; i++) 
		for(j = 0; j < N; j++) 
			sum += (mat[i]-mat[j])*(mat[i]-mat[j]);
    for (i = 1; i < nproc; i++) {
      MPI_Recv(&psum, 1, MPI_DOUBLE, i, 0, MPI_COMM_WORLD, &status);
	  sum += psum;
    }
	endcomp = MPI_Wtime();
	  printf("%lf\n", sum);
	  printf("Total time = %lf Exect time= %lf [sec]\n", endcomp-start, endcomp-startcomp);
  }
  else {
    i=0;
    MPI_Recv(&mat[i], N, MPI_DOUBLE, 0, 0, MPI_COMM_WORLD, &status);
	sum=0;
	for(i = pid*(N/nproc); i < (pid+1)*N/nproc; i++) 
		for(j = 0; j < N; j++) 
			sum += (mat[i]-mat[j])*(mat[i]-mat[j]);

    MPI_Send(&sum, 1, MPI_DOUBLE, 0, 0, MPI_COMM_WORLD);
  }

  MPI_Finalize();

  return 0;
}

