/* FPGA top */
`include "def.h"
module fpga (input rst_n, clk, 
	output [`DATA_W-1:0] ddataout, 
	input [`DATA_W-1:0] initdata, 
	input initwe);
   wire [`DATA_W-1:0] ddatain, idatain ;
   wire [`DATA_W-1:0] daddr, iaddr;
   wire we;

   poco poco_1(.clk(clk), .rst_n(rst_n), .idatain(idatain),
               .ddatain(ddatain), .iaddr(iaddr), .daddr(daddr),
               .ddataout(ddataout), .we(we));
   imem imem_1 (.a(iaddr[9:0]), .rd(idatain), .wd(initdata), .we(we), .clk(clk) );
	dmem dmem_1 (.a(daddr[9:0]), .wd(ddataout), .rd(ddatain), .we(we), .clk(clk) );

endmodule
