/* FPGA top */
`include "def.h"
module fpga (input rst_n, clk, 
	output [`DATA_W-1:0] ddataout, 
	input [`DATA_W-1:0] initdata, 
	input initwe,
	output ecall_op);
   wire [`DATA_W-1:0] ddatain, ddataout, idata ;
   wire [`DATA_W-1:0] daddr, iaddr;
   wire we;

   rv32i rv32i_1(.clk(clk), .rst_n(rst_n), .instr(idata),
               .readdata(ddatain), .pc(iaddr), .aluresult(daddr),
			   .writedata(ddataout), .ecall_op(ecall_op),
               .we(we));
   fimem imem_1 (.a(iaddr[9:0]), .rd(idata), .wd(initdata), .we(we), .clk(clk) );
	fdmem dmem_1 (.a(daddr[9:0]), .wd(ddataout), .rd(ddatain), .we(we), .clk(clk) );

endmodule
