proc initialize_pg {} {
		derive_pg_connection -power_net {VDD} -create_port all
		derive_pg_connection  -power_pin {VDD} -create_port all
		derive_pg_connection -ground_net {VSSV} -create_port all -cells {*}
		derive_pg_connection -ground_pin {VSSV} -create_port all -cells {*}
		derive_pg_connection -ground_net {VSS} -create_port all
		derive_pg_connection -ground_pin {VSS} -create_port all
}

proc end_tap_pg {} {
		derive_pg_connection -power_net {VDD} -power_pin {VDD} -create_port all -cells {*CUBA*}
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -create_port all -cells {*CUBA*}
		derive_pg_connection -power_net {VDD} -create_port all
		derive_pg_connection  -power_pin {VDD} -create_port all
		derive_pg_connection -ground_net {VSS} -create_port all
		derive_pg_connection -ground_pin {VSS} -create_port all
}

proc update_pg {} {
		derive_pg_connection -power_net {VDD} -power_pin {VDD} -create_port all -cells {RFPS*}
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -create_port all -cells {RFPS*}
		derive_pg_connection -ground_net {VSSV} -ground_pin {VSSV} -create_port all -cells {RFPS*}
}

proc report_timing_preroute {} {
	set_zero_interconnect_delay_mode true
	report_constraint -all
	report_timing
	set_zero_interconnect_delay_mode false 
}

set filler_without_metal_list ""
lappend filler_without_metal_list SC23YUZS031
lappend filler_without_metal_list SC23YUZS021
lappend filler_without_metal_list SC23YUZS011

set filler_list ""
foreach filler_cell $filler_without_metal_list {lappend filler_list $filler_cell}

set buffer_list ""
lappend buffer_list SC23BUFXA1
lappend buffer_list SC23BUFXC1
lappend buffer_list SC23BUFXH1
lappend buffer_list SC23BUFXJ1
lappend buffer_list SC23BUFXL1
lappend buffer_list SC23BUFXN1
lappend buffer_list SC23BUFXP1
lappend buffer_list SC23BUFXQ1
lappend buffer_list SC23BUFXR1
lappend buffer_list SC23BUFXT1

set clock_bufinv_list ""
lappend clock_bufinv_list SC23CKBUFCLXH1
lappend clock_bufinv_list SC23CKBUFCLXL1
lappend clock_bufinv_list SC23CKBUFCLXP1
lappend clock_bufinv_list SC23CKBUFCLXR1
lappend clock_bufinv_list SC23CKBUFCLXT1
lappend clock_bufinv_list SC23CKINVCLXH1
lappend clock_bufinv_list SC23CKINVCLXL1
lappend clock_bufinv_list SC23CKINVCLXP1
lappend clock_bufinv_list SC23CKINVCLXR1
lappend clock_bufinv_list SC23CKINVCLXT1

set clock_sizing_list ""
lappend clock_sizing_list SC23CKBUFBCLXH1
lappend clock_sizing_list SC23CKBUFBCLXL1
lappend clock_sizing_list SC23CKINVBCLXH1
lappend clock_sizing_list SC23CKINVBCLXL1
lappend clock_sizing_list SC23CKINVBCLXP1
lappend clock_sizing_list SC23CKINVBCLXR1
lappend clock_sizing_list SC23CKINVBCLXT1

set clock_delay_list ""
lappend clock_delay_list SC23DLY02XC1
lappend clock_delay_list SC23DLY02XH1
lappend clock_delay_list SC23DLY04XC1
lappend clock_delay_list SC23DLY04XH1
lappend clock_delay_list SC23DLY07XC1
lappend clock_delay_list SC23DLY07XH1
lappend clock_delay_list SC23DLY1XH1
lappend clock_delay_list SC23DLY2XH1
lappend clock_delay_list SC23DLY3XH1
