proc initialize_pg {} {
		derive_pg_connection -power_net {VDD} -create_port all
		derive_pg_connection  -power_pin {VDD}
		derive_pg_connection -ground_net {VSS} -create_port all -cells {ROW_CONV*}
		derive_pg_connection -ground_pin {VSS} -create_port all -cells {ROW_CONV*}
		derive_pg_connection -ground_net {VSSV} -create_port all -cells {ROW_UNSIGN*}
		derive_pg_connection -ground_pin {VSSV} -create_port all -cells {ROW_UNSIGN*}
		derive_pg_connection -ground_net {VSS} -create_port all
		derive_pg_connection -ground_pin {VSS}
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -cells {*CUBA*}
}

proc update_pg {} {
		derive_pg_connection -power_net {VDD} -power_pin {VDD} -cells {RFPS*}
		derive_pg_connection -ground_net {VSS} -create_port all -cells {ROW_CONV*}
		derive_pg_connection -ground_pin {VSS} -create_port all -cells {ROW_CONV*}
		derive_pg_connection -ground_net {VSSV} -create_port all -cells {ROW_UNSIGN*}
		derive_pg_connection -ground_pin {VSSV} -create_port all -cells {ROW_UNSIGN*}
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -cells {RFPS*}
		derive_pg_connection -ground_net {VSSV} -ground_pin {VSSV} -cells {RFPS*}
		derive_pg_connection -power_net {VDD} -create_port all
		derive_pg_connection  -power_pin {VDD}
		derive_pg_connection -ground_net {VSS} -create_port all
		derive_pg_connection -ground_pin {VSS}
}

proc report_timing_preroute {} {
	set_zero_interconnect_delay_mode true
	report_constraint -all
	report_timing
	set_zero_interconnect_delay_mode false 
}

set filler_without_metal_list ""
lappend filler_without_metal_list SC23YUZS031
lappend filler_without_metal_list SC23YUZS021
lappend filler_without_metal_list SC23YUZS011

set filler_list ""
foreach filler_cell $filler_without_metal_list {lappend filler_list $filler_cell}

#set buffer_list ""
#lappend buffer_list SC23BUFXA1
#lappend buffer_list SC23BUFXC1
#lappend buffer_list SC23BUFXH1
#lappend buffer_list SC23BUFXJ1
#lappend buffer_list SC23BUFXL1
#lappend buffer_list SC23BUFXN1
#lappend buffer_list SC23BUFXP1
#lappend buffer_list SC23BUFXQ1
#lappend buffer_list SC23BUFXR1
#lappend buffer_list SC23BUFXT1
