###############################################
# library                       
###############################################

#setup
set std_max_libs1 "../../../lib/CS202SZ/LM/cs202sz_uc_core_s_p125_105v.db" 
set std_max_libs2 "../../../lib/CS202SZ/LM/cs202sz_uc_nscan_s_p125_105v.db"
set std_max_libs  "$std_max_libs1 $std_max_libs2"

set std_typ_libs1 "../../../lib/CS202SZ/LM/cs202sz_uc_core_t_p25_12v.db"
set std_typ_libs2 "../../../lib/CS202SZ/LM/cs202sz_uc_nscan_t_p25_12v.db"
set std_typ_libs  "$std_typ_libs1 $std_typ_libs2"

set std_min_libs1 "../../../lib/CS202SZ/LM/cs202sz_uc_core_f_m40_13v.db"
set std_min_libs2 "../../../lib/CS202SZ/LM/cs202sz_uc_nscan_f_m40_13v.db"
set std_min_libs  "$std_min_libs1 $std_min_libs2" 

#set search_path       "/nfs/process/es65/eShuttle/RDF/lib/milkyway/CS202SZ/LM $search_path"
#set target_library    "$std_max_libs $std_typ_libs $std_min_libs"
set search_path "$search_path /nfs/process/es65/eShuttle/Standerdcell_IOcell/cs202_sciolib_12lay_20081216/db"
set target_library    "$std_typ_libs"
set symbol_library    "/nfs/cad/synopsys/synthesis/syn_vA-2007.12-SP3/libraries/syn/class.sdb"
set synthetic_library "/nfs/cad/synopsys/synthesis/syn_vA-2007.12-SP3/libraries/syn/dw_foundation.sldb"
#set link_library      "$target_library $symbol_library $synthetic_library"
set link_library      "$std_typ_libs"

set auto_restore_mw_cel_lib_setup true

#milkyway
set top_design  "ROW_MULT_UNIT"
set mw_path     "../../../lib"
set libs        "CS202SZ CS202IO CS202RPGTAP"
set tech_file   "../../../lib/tech.tf"
#set mw_ref_libs "../../../lib/CS202SN"

#TLUPlus
set tlup_map    "../../../lib/layer.map"
set tlup_max    "../../../lib/TLUPlus_mfe.worst"
set tlup_min    "../../../lib/TLUPlus_mfe.best"

source ./com.tcl
#source ./com2.tcl

###############################################
# make library                       
###############################################

set mw_ref_libs ""
foreach lib $libs {
	lappend mw_ref_libs $mw_path/$lib
}

create_mw_lib ${top_design} \
	-technology  $tech_file \
	-mw_reference_library $mw_ref_libs \
	-open

set_tlu_plus_files \
	-max_tluplus $tlup_max \
	-min_tluplus $tlup_min \
	-tech2itf_map  $tlup_map 
check_tlu_plus_files

set mw_logic0_net "VSS"
set mw_logic1_net "VDD"

import_designs -format verilog {../../../NET_Row_MULT/Row_MULT.v} \
	-cel $top_design \
	-top $top_design

report_timing_requirements

###############################################
# floorplan                       
###############################################

initialize_floorplan -core_utilization 0.45 -start_first_row -flip_first_row -left_io2core 2 -bottom_io2core 2 -right_io2core 2 -top_io2core 2

set_ignored_layers    -min_routing_layer MET1 -max_routing_layer MET6

initialize_pg

create_placement_blockage -bbox {8.4 34.4 144.0 84.8} -type hard -name PBH
create_placement_blockage -bbox {8.4 88.4 144.0 138.8} -type hard -name PBL

add_tap_cell_array -master_cell_name {SC23YUZTAP021} \
				-offset -8.6 \
                   -distance 30 \
                   -left_boundary_extra_tap no_insert \
                   -right_boundary_extra_tap no_insert \
                   -left_macro_blockage_extra_tap no_insert \
                   -right_macro_blockage_extra_tap no_insert \
                   -connect_power_name {VDD} \
                   -connect_ground_name {VSS} \
				-ignore_soft_blockage true 

add_end_cap -lib_cell {SC23YUZCUBAS321} -mode bottom_left

remove_placement_blockage -all

initialize_pg

###############################################
# floorplan(power switch)                       
###############################################

#create_placement_blockage -bbox {6.8 2.0 8.4 142.4} -type hard -name PB0
create_placement_blockage -bbox {8.4 2.0 144.0 34.4} -type hard -name PBT1
create_placement_blockage -bbox {8.4 84.8 144.0 88.4} -type hard -name PBT2
create_placement_blockage -bbox {8.4 138.8 144.0 142.4} -type hard -name PBT3

create_power_switch_array -lib_cell {SC27RFPSTAPXH1} \
		-x_increment 30 -y_increment 1.8 \
		-start_row 0 \
		-start_column 0 \
		-bounding_box {8.8 34.4 144.0 84.8} \
		-prefix "RFPS_HIGH" \
		-snap_to_row_and_tile \
		-orientation W \
		-respect hard_blockage

create_power_switch_array -lib_cell {SC27RFPSTAPXH1} \
		-x_increment 30 -y_increment 1.8 \
		-start_row 0 \
		-start_column 0 \
		-bounding_box {8.8 88.4 144.0 138.8} \
		-prefix "RFPS_LOW" \
		-snap_to_row_and_tile \
		-orientation W \
		-respect hard_blockage

update_pg

remove_placement_blockage -name PBT1
remove_placement_blockage -name PBT2
remove_placement_blockage -name PBT3

set high [get_cells ROW_UNSIGN/HIGH*]
set low [get_cells ROW_UNSIGN/LOW*]
merge_fp_hierarchy -cells ${high} -design_name {HIGH} -new_cell_name {HIGH}
merge_fp_hierarchy -cells ${low} -design_name {LOW} -new_cell_name {LOW}

report_fp_placement_strategy
#create_fp_placement
create_plan_groups ROW_CONV -coordinate {8.4 2.0 144.0 34.4}
create_plan_groups ROW_UNSIGN/HIGH -coordinate {8.4 34.4 144.0 84.8}
create_plan_groups ROW_UNSIGN/LOW -coordinate {8.4 88.4 144.0 138.8}
create_fp_placement -incremental plan_groups -plan_groups {ROW_CONV HIGH LOW}

legalize_placement

save_mw_cel -as floorplan

###############################################
# MTE
###############################################

remove_net net*
connect_pin -from SLEEPCON -to RFPS_LOW*/MTE
connect_net HIGH_EN {RFPS_HIGH*/MTE}

insert_buffer {RFPS_LOW*/MTE} {SC23BUFXT1} \
		-new_cell_name {PSD_SLEEPCON} \
		-location {68.8 86.6}
insert_buffer {RFPS_HIGH*/MTE} {SC23BUFXT1} \
		-new_cell_name {PSD_HIGH} \
		-location {68.8 140.6}

update_pg

###############################################

set_preroute_drc_strategy  -report_fail  -min_layer MET1  -max_layer METG2

create_power_straps \
	 -direction vertical  \
	 -start_at 10.0 -num_placement_strap 7 -increment_x_or_y 30 -nets  {VSS} \
	 -layer METS1 -width 1.0 \
	 -extend_low_ends force_to_boundary_and_generate_pins \
	 -extend_high_ends force_to_boundary_and_generate_pins \
	 -look_inside_std_cells \
	 -std_cells {*RFPS*}

create_power_straps \
	 -direction vertical  \
	 -start_at 25.0 -num_placement_strap 7 -increment_x_or_y 30 -nets  {VDD} \
	 -layer METS1 -width 1.0 \
	 -extend_low_ends force_to_boundary_and_generate_pins \
	 -extend_high_ends force_to_boundary_and_generate_pins

###############################################
# insert_filler
###############################################

#create_placement_blockage -bbox {6.8 2.0 8.4 142.4} -type hard -name PB0
create_placement_blockage -bbox {8.4 2.0 144.0 34.4} -type hard -name PBT1
create_placement_blockage -bbox {8.4 84.8 144.0 88.4} -type hard -name PBT2
create_placement_blockage -bbox {8.4 138.8 144.0 142.4} -type hard -name PBT3

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSSV}

remove_placement_blockage -all

#create_placement_blockage -bbox {8.4 5.6 144.0 30.8} -type hard -name PBC
create_placement_blockage -bbox {8.4 34.4 144.0 84.8} -type hard -name PBH
create_placement_blockage -bbox {8.4 88.4 144.0 138.8} -type hard -name PBL

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSS}

remove_placement_blockage -all

###############################################

preroute_standard_cells \
	-nets  {VDD VSS} \
	-connect horizontal -extend_to_boundaries_and_generate_pins  \
	-port_filter_mode off -cell_master_filter_mode off \
	-cell_instance_filter_mode off -voltage_area_filter_mode off \
	-do_not_route_over_macros

verify_pg_nets  -macro_pin_connection all -pad_pin_connection all -error_cell ${top_design}_pg
open_mw_cel -not_as_current -readonly ${top_design}_pg

analyze_fp_rail  -nets {VDD VSS} -voltage_supply 1.2 -use_pins_as_pa

remove_stdcell_filler  -stdcell

set_pnet_options -complete {MET6}
report_pnet_options
#create_fp_placement  -timing_driven -incremental all

extract_rc
report_timing_preroute

save_mw_cel 
save_mw_cel -as planned

###############################################
# placement
###############################################

report_clock
report_clock -skew

check_physical_design -for_placement
check_physical_constraints -v

create_placement
legalize_placement

report_timing_preroute

create_placement -timing_driven -congestion
legalize_placement

report_ahfs_options

report_timing_preroute

###############################################
# insert_filler
###############################################

create_placement_blockage -bbox {8.4 2.0 144.0 34.4} -type hard -name PBT1
create_placement_blockage -bbox {8.4 84.8 144.0 88.4} -type hard -name PBT2
create_placement_blockage -bbox {8.4 138.8 144.0 142.4} -type hard -name PBT3

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSSV}

remove_placement_blockage -all

#create_placement_blockage -bbox {8.4 5.6 144.0 30.8} -type hard -name PBC
create_placement_blockage -bbox {8.4 34.4 144.0 84.8} -type hard -name PBH
create_placement_blockage -bbox {8.4 88.4 144.0 138.8} -type hard -name PBL

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSS}

remove_placement_blockage -all

save_mw_cel -as placed

###############################################
# routing
###############################################

report_timing
report_timing -delay min

check_routeability -error_cell ${top_design}.err

report_route_opt_strategy

route_opt

save_mw_cel
verify_route
verify_drc -read_cell_view -check_via_size -check_enclosure -check_end_of_line -check_via_farm -check_fat_poly_contact -check_blockage

set_route_options \
	 -groute_timing_driven true \
	 -groute_skew_control false \
	 -groute_congestion_weight 4 \
	 -groute_clock_routing balanced \
	 -groute_incremental true \
	 -track_assign_timing_driven true \
	 -droute_connect_tie_off true \
	 -droute_connect_open_nets true \
	 -droute_reroute_user_wires false \
	 -droute_CTS_nets minor_change_only \
	 -droute_single_row_column_via_array center \
	 -droute_stack_via_less_than_min_area add_metal_stub \
	 -droute_stack_via_less_than_min_area_cost 0 \
	 -poly_pin_access auto \
	 -drc_distance diagonal \
	 -same_net_notch check_and_fix \
	 -merge_fat_wire_on signal_routing_too \
	 -fat_wire_check merge_then_check \
	 -fat_blockage_as fat_wire \
	 -wire_contact_eol_rule check_and_fix

route_search_repair -loop 10

save_mw_cel
update_pg
verify_drc -read_cell_view -check_via_size -check_enclosure \
	-check_end_of_line -check_via_farm -check_fat_poly_contact -check_blockage
verify_lvs


set_si_options \
	-route_xtalk_prevention ture \
	-delta_delay true \
	-static_noise true 

report_constraint -all
report_timing -crosstalk_delta

route_opt -incremental -xtalk_reduction
report_constraint -all


save_mw_cel 
save_mw_cel -as routed
update_pg
verify_drc -read_cell_view -check_via_size -check_enclosure -check_end_of_line -check_via_farm -check_fat_poly_contact -check_blockage
verify_lvs

###############################################
# finishing
###############################################

route_search_repair -loop 100 -rerun_drc -trim_antenna_of_user_wires
route_global
route_spreadwires -timing_driven -search_repair_loop 5
route_search_repair -loop 100 -rerun_drc -trim_antenna_of_user_wires

set_parameter -module droute -name  doAntennaConx  -value 4
source  -e -v ../../../lib/antenna_rule_icc.sc
report_antenna_rules
report_antenna_ratio
route_search_repair -rerun_drc -loop 1
insert_diode
update_pg
#sizeof [get_cells -hierarchical antenna_diode*]

verify_route -antenna

###############################################
# insert_filler
###############################################

create_placement_blockage -bbox {8.4 2.0 144.0 34.4} -type hard -name PBT1
create_placement_blockage -bbox {8.4 84.8 144.0 88.4} -type hard -name PBT2
create_placement_blockage -bbox {8.4 138.8 144.0 142.4} -type hard -name PBT3

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSSV}

remove_placement_blockage -all

#create_placement_blockage -bbox {8.4 5.6 144.0 30.8} -type hard -name PBC
create_placement_blockage -bbox {8.4 34.4 144.0 84.8} -type hard -name PBH
create_placement_blockage -bbox {8.4 88.4 144.0 138.8} -type hard -name PBL

insert_stdcell_filler \
	 -cell_without_metal $filler_without_metal_list \
	 -connect_to_power {VDD}  -connect_to_ground {VSS}

remove_placement_blockage -all

###############################################

update_pg
save_mw_cel 
verify_drc -read_cell_view \
	-check_via_size \
	-check_enclosure \
	-check_end_of_line \
	-check_via_farm \
	-check_fat_poly_contact \
	-check_blockage
verify_lvs
verify_pg_nets  -macro_pin_connection all \
 -pad_pin_connection all -error_cell ${top_design}_pg

set_delay_calculation -arnoldi
report_constraints
report_timing

###############################################
# output
###############################################

change_names  -hierarchy -rules  verilog -v
save_mw_cel 
write_verilog \
	-force_output_references $filler_list \
	 -output_net_name_for_pg \
	 -diode_ports -pg_ports -split_bus \
	 ./outputs/${top_design}_lvs.v

write -format verilog -hierarchy -output ${top_design}.v

set_write_stream_options -map_layer ../../../lib/gdsout.map \
	 -output_pin {text geometry} -child_depth 10000

#set_write_stream_options -map_layer ../../../lib/gdsout.map \
#	-skip_ref_lib_cells -output_pin {text geometry}
write_stream  -lib_name ${top_design} -cells ${top_design} \
	 -format gds ./outputs/${top_design}.gds

write_sdf -version 3.0 ./outputs/${top_design}.sdf
extract_rc
write_parasitics -output ./outputs/${top_design}.spef

create_macro_fram -library_name ${top_design} -cell_name ${top_design} \
	-routing_blockage_output_layer metBlk \
	-treat_metal_blockage_as_thin { poly m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 m15} \
	-extract_blockage_by_block_core_with_margin "m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 m15"  \
	-extract_pin_connectivity_through { v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14} 

extract_hier_antenna_property  -cell_name  $top_design

create_ilm \
	-include_side_load boundary \
	-latch_level 1 \
	-verbose \
	-keep_boundary_cells \
	-keep_full_clock_tree \
	-keep_parasitics \
	-keep_macro \
	-include_xtalk 

write_sdc ./outputs/${top_design}.sdc
write  -format ddc   -output ./outputs/${top_design}.ddc
