proc connection_pg {} {
		derive_pg_connection -ground_net {VSSV} -cells {MULT_UNIT} -create_port all
		derive_pg_connection -ground_pin {VSSV} -cells {MULT_UNIT} -create_port all
		derive_pg_connection -power_net {VDD} -power_pin {VDD} -cells {Normal_UNSIGN} -create_port all
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -cells {RFPS*} -create_port all
		derive_pg_connection -ground_net {VSSV} -ground_pin {VSSV} -cells {RFPS*} -create_port all
		derive_pg_connection -power_net {VDD} -power_pin {VDD} -create_port all
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS} -create_port all
}

proc report_timing_preroute {} {
	set_zero_interconnect_delay_mode true
	report_constraint -all
	report_timing
	set_zero_interconnect_delay_mode false 
}

set filler_without_metal_list ""
lappend filler_without_metal_list SC23YUZS021
lappend filler_without_metal_list SC23YUZS011

set filler_with_metal_list ""
lappend filler_with_metal_list SC23YUZCUBAS321
lappend filler_with_metal_list SC23YUZCUBAS241
lappend filler_with_metal_list SC23YUZCUBAS161
lappend filler_with_metal_list SC23YUZCUBAS081

set filler_list ""
foreach filler_cell $filler_without_metal_list {lappend filler_list $filler_cell}
foreach filler_cell $filler_with_metal_list    {lappend filler_list $filler_cell}

#set pad_filler_list ""
#lappend pad_filler_list IOCB2ESE4C0A1
#lappend pad_filler_list IOCB2ESD4C0A1
#lappend pad_filler_list IOCB2ESA4C0A1
#lappend pad_filler_list IOCB2ES54C0A1
#lappend pad_filler_list IOCB2ES24C0A1
#lappend pad_filler_list IOCB2ES14C0A1
#lappend pad_filler_list IOCB2ESB4C0A1
