#################################################
#                                               #
#              Output for ALFEE-2               #
#                                               #
#        2010/09/23                 Ohta        #
#                                               #
#################################################

change_names -hierarchy -rules  verilog -v
save_mw_cel -as ${top_design}
write_verilog \
       -force_output_references $filler_list \
       -output_net_name_for_pg \
       -diode_ports -pg_ports -split_bus \
       ./outputs/${top_design}_lvs.v

write -format verilog -hierarchy -output ${top_design}.v

set_write_stream_options \
          -map_layer ../lib/gdsout.map \
	 -output_pin {text geometry} \
         -child_depth 10000

write_stream \
         -lib_name ${top_design} \
         -cells ${top_design} \
	 -format gds ./outputs/${top_design}.gds

write_sdf -version 3.0 ./outputs/${top_design}.sdf
extract_rc
write_parasitics -output ./outputs/${top_design}.spef

create_macro_fram \
        -library_name ${top_design} \
        -cell_name ${top_design} \
        -routing_blockage_output_layer metBlk \
        -treat_metal_blockage_as_thin { poly m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 m15} \
        -extract_blockage_by_block_core_with_margin "m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 m15"  \
        -extract_pin_connectivity_through { v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14} 

extract_hier_antenna_property  -cell_name  $top_design

create_ilm \
        -include_side_load boundary \
        -latch_level 1 \
        -verbose \
        -keep_boundary_cells \
        -keep_full_clock_tree \
        -keep_parasitics \
        -keep_macro \
        -include_xtalk

write_sdc ./outputs/${top_design}.sdc
write  -format ddc   -output ./outputs/${top_design}.ddc
