#################################################
#                                               #
#         Library Setup for ALFEE-2             #
#                                               #
#       2010/09/28                  Ohta        #
#                                               #
#################################################

source -e -v ./env.tcl
source -e -v ./com.tcl
source -e -v ./dont_use.tcl

###############################################
# make library                       
###############################################

set mw_ref_libs ""
foreach lib $libs {
	lappend mw_ref_libs $mw_path/$lib
}

create_mw_lib ${top_design} \
	-technology  $tech_file \
	-mw_reference_library $mw_ref_libs \
	-open

set_tlu_plus_files \
	-max_tluplus $tlup_max \
	-min_tluplus $tlup_min \
	-tech2itf_map  $tlup_map 
check_tlu_plus_files

set mw_logic0_net "VSS"
set mw_logic1_net "VDD"

import_designs -format verilog {../vnet/UNSIGN_MULT.v} \
	-cel $top_design \
	-top $top_design

#read_sdc $sdc_file
#read_sdf $sdf_file

report_timing_requirements
save_mw_cel -as make_library
