#################################################
#                                               #
#              ALFEE-2  TOP Layout              #
#                                               #
#        2010/09/28                Ohta         #
#                                               #
#################################################

source -e -v ./initialize.tcl > ./log/initialize.log
source -e -v ./floorplan.tcl > ./log/floorplan.log

set_preroute_drc_strategy  -report_fail  -min_layer MET1  -max_layer METG2

create_power_straps \
         -direction vertical  \
         -start_at 5.0 \
         -num_placement_strap 5 \
         -increment_x_or_y 30 \
         -nets  {VDD VSS} \
         -layer METS1 \
         -width 0.8 \
         -pitch_within_group 15.0 \
         -extend_low_ends force_to_boundary_and_generate_pins \
         -extend_high_ends force_to_boundary_and_generate_pins \
         -do_not_route_over_macros

save_mw_cel -as power_strap

insert_stdcell_filler \
         -cell_without_metal $filler_without_metal_list \
         -connect_to_power {VDD}  -connect_to_ground {VSS}

preroute_standard_cells \
        -nets  {VDD VSS} \
        -connect horizontal -extend_to_boundaries_and_generate_pins  \
        -port_filter_mode off -cell_master_filter_mode off \
        -cell_instance_filter_mode off -voltage_area_filter_mode off 

verify_pg_nets  -macro_pin_connection all -pad_pin_connection all -error_cell ${top_design}_pg
open_mw_cel -not_as_current -readonly ${top_design}_pg

analyze_fp_rail  -nets {VDD VSS} -voltage_supply 1.2 -use_pins_as_pa

remove_stdcell_filler  -stdcell

save_mw_cel -as preroute

set_pnet_options -complete {MET6}
report_pnet_options
create_fp_placement  -timing_driven -incremental all

#propagate_ilm
#extract_rc
report_timing_preroute

connection_pg

#save_mw_cel 
save_mw_cel -as planned

source -e -v ./placement.tcl > ./log/placement.log
set_ignored_layers    -min_routing_layer MET1 -max_routing_layer MET6
connection_pg_tie
source -e -v ./route.tcl > ./log/route.log
source -e -v ./adjustment.tcl > ./log/adjustment.log
source -e -v ./output.tcl > ./log/output.log
