#################################################
#                                               #
#               Route for ALFEE-2               #
#                                               #
#       2010/09/28                 Ohta         #
#                                               #
#################################################

report_timing
report_timing -delay min

check_routeability -error_cell ${top_design}.err

report_route_opt_strategy

connection_pg
connection_pg_macro
connection_pg_ps
route_opt

verify_route
verify_drc \
       -read_cell_view \
       -check_via_size \
       -check_enclosure \
       -check_end_of_line \
       -check_via_farm \
       -check_fat_poly_contact \
       -check_blockage

set_route_options \
          -groute_timing_driven true \
          -groute_skew_control false \
          -groute_congestion_weight 4 \
          -groute_clock_routing balanced \
          -groute_incremental true \
          -track_assign_timing_driven true \
          -droute_connect_tie_off true \
          -droute_connect_open_nets true \
          -droute_reroute_user_wires false \
          -droute_CTS_nets minor_change_only \
          -droute_single_row_column_via_array center \
          -droute_stack_via_less_than_min_area add_metal_stub \
          -droute_stack_via_less_than_min_area_cost 0 \
          -poly_pin_access auto \
          -drc_distance diagonal \
          -same_net_notch check_and_fix \
          -merge_fat_wire_on signal_routing_too \
          -fat_wire_check merge_then_check \
          -fat_blockage_as fat_wire \
          -wire_contact_eol_rule check_and_fix

route_search_repair -loop 10

connection_pg
verify_drc \
       -read_cell_view \
       -check_via_size \
       -check_enclosure \
       -check_end_of_line \
       -check_via_farm \
       -check_fat_poly_contact \
       -check_blockage
verify_lvs

set_si_options \
        -route_xtalk_prevention ture \
        -delta_delay true \
        -static_noise true 

report_constraint -all
report_timing -crosstalk_delta

route_opt -incremental -xtalk_reduction
report_constraint -all
 
save_mw_cel -as routed
connection_pg
connection_pg_macro
connection_pg_ps
verify_drc \
       -read_cell_view \
       -check_via_size \
       -check_enclosure \
       -check_end_of_line \
       -check_via_farm \
       -check_fat_poly_contact \
       -check_blockage
verify_lvs

