#################################################
#                                               #
#            Floorplan for ALFEE-2              #
#                (Power Gating)                 #
#                                               #
#       2010/09/30                 Ohta         #
#                                               #
#################################################

initialize_floorplan -control_type width_and_height \
        -core_width 159 \
        -core_height 158.4 \
        -start_first_row \
        -flip_first_row \
        -left_io2core 2 \
        -bottom_io2core 2 \
        -right_io2core 2 \
        -top_io2core 2

save_mw_cel -as pad 

add_end_cap -lib_cell {SC23YUZCUBAS321} -mode bottom_left

source -e -v place_macro.tcl > ./log/place_macro.log

#set_ignored_layers    -min_routing_layer MET1 -max_routing_layer MET6
connection_pg_macro
connection_pg

# ====================for Power Switch=========================

source -e -v create_pg_ring.tcl > ./log/create_pg_ring.log
source -e -v insert_ps.tcl > ./log/insert_ps.log
connection_pg_ps

# =============================================================

create_placement_blockage -bbox {21.6 20.2 147.8 145.8} -type hard -name UNSIGN_MULT

add_tap_cell_array -master_cell_name {SC23YUZTAP021} \
                   -offset -13.6 \
                   -distance 30 \
                   -left_boundary_extra_tap must_insert \
                   -right_boundary_extra_tap must_insert \
                   -left_macro_blockage_extra_tap no_insert \
                   -right_macro_blockage_extra_tap no_insert \
                   -connect_power_name {VDD} \
                   -connect_ground_name {VSS} \
                   -ignore_soft_blockage true

report_fp_placement_strategy
create_fp_placement
legalize_placement

save_mw_cel -as floorplan
