###############################################
#                                             #
#            Connection Settings              #
#              (Power Gating)                 #
#                                             #
#    2010/09/30                 Ohta          #                    
#                                             #
###############################################


# =============================================
# Power-Ground Connection
# =============================================

proc connection_pg {} {
		derive_pg_connection -power_net {VDD} -power_pin {VDD}
		derive_pg_connection -ground_net {VSS} -ground_pin {VSS}
}

proc connection_pg_tie {} {
                derive_pg_connection -tie -power_net {VDD} -ground_net {VSS}
}

proc connection_pg_macro {} {
                derive_pg_connection -power_net {VDD} -power_pin {VDD} -cells {UNSIGN_MULT}  
                derive_pg_connection -ground_net {VSSV} -ground_pin {VSS} -cells {UNSIGN_MULT}
}

proc connection_pg_ps {} {
                derive_pg_connection -ground_net {VSS}  -ground_pin {VSS}  -cells {GFPS*}
                derive_pg_connection -power_net  {VDD}  -power_pin  {VDD}  -cells {GFPS*}
                derive_pg_connection -ground_net {VSSV} -ground_pin {VSSV} -cells {GFPS*}
}

proc report_timing_preroute {} {
	set_zero_interconnect_delay_mode true
	report_constraint -all
	report_timing
	set_zero_interconnect_delay_mode false 
}

set filler_without_metal_list ""
lappend filler_without_metal_list SC23YUZS021
lappend filler_without_metal_list SC23YUZS011

set filler_with_metal_list ""
lappend filler_with_metal_list SC23YUZCUBAS321
lappend filler_with_metal_list SC23YUZCUBAS241
lappend filler_with_metal_list SC23YUZCUBAS161
lappend filler_with_metal_list SC23YUZCUBAS081

set filler_list ""
foreach filler_cell $filler_without_metal_list {lappend filler_list $filler_cell}
foreach filler_cell $filler_with_metal_list    {lappend filler_list $filler_cell}

set clock_bufinv_list ""
lappend clock_bufinv_list SC23CKBUFCLXL1
lappend clock_bufinv_list SC23CKBUFCLXP1
lappend clock_bufinv_list SC23CKBUFCLXR1
lappend clock_bufinv_list SC23CKBUFCLXT1
lappend clock_bufinv_list SC23CKINVCLXH1
lappend clock_bufinv_list SC23CKINVCLXL1
lappend clock_bufinv_list SC23CKINVCLXP1
lappend clock_bufinv_list SC23CKINVCLXR1
lappend clock_bufinv_list SC23CKINVCLXT1

set clock_sizing_list ""
lappend clock_sizing_list SC23CKBUFBCLXH1
lappend clock_sizing_list SC23CKBUFBCLXL1
lappend clock_sizing_list SC23CKINVBCLXH1
lappend clock_sizing_list SC23CKINVBCLXL1
lappend clock_sizing_list SC23CKINVBCLXP1
lappend clock_sizing_list SC23CKINVBCLXR1
lappend clock_sizing_list SC23CKINVBCLXT1

set clock_delay_list ""
lappend clock_delay_list SC23DLY02XC1
lappend clock_delay_list SC23DLY02XH1
lappend clock_delay_list SC23DLY04XC1
lappend clock_delay_list SC23DLY04XH1
lappend clock_delay_list SC23DLY07XC1
lappend clock_delay_list SC23DLY07XH1
lappend clock_delay_list SC23DLY1XH1
lappend clock_delay_list SC23DLY2XH1
lappend clock_delay_list SC23DLY3XH1


