#################################################
#                                               #
#              ALFEE-2  TOP Layout              #
#                (Power Gating)                 #
#                                               #
#        2010/09/30                Ohta         #
#                                               #
#################################################

source -e -v ./initialize.tcl > ./log/initialize.log
source -e -v ./floorplan.tcl > ./log/floorplan.log

set_preroute_drc_strategy  -report_fail  -min_layer MET1  -max_layer METG2

create_power_straps \
         -direction vertical  \
         -start_at 5.0 \
         -num_placement_strap 5 \
         -increment_x_or_y 30 \
         -nets  {VDD VSS} \
         -layer METS1 \
         -width 0.8 \
         -pitch_within_group 10.0 \
         -extend_low_ends force_to_boundary_and_generate_pins \
         -extend_high_ends force_to_boundary_and_generate_pins \
         -do_not_route_over_macros

create_power_straps \
         -direction vertical  \
         -start_at 154.84 \
         -num_placement_strap 1 \
         -nets  {VDD} \
         -layer METS1 \
         -width 0.8 \
         -extend_low_ends force_to_boundary_and_generate_pins \
         -extend_high_ends force_to_boundary_and_generate_pins \
         -do_not_route_over_macros

save_mw_cel -as power_strap

insert_stdcell_filler \
         -cell_without_metal $filler_without_metal_list \
         -connect_to_power {VDD}  -connect_to_ground {VSS}

preroute_instance \
        -ignore_pads -ignore_cover_cells \
        -connect_instances specified -cell {UNSIGN_MULT} \
        -select_net_by_type specified \
        -nets {VDD VSSV} \
        -primary_routing_layer specified \
        -specified_horizontal_layer MET1 \
        -specified_vertical_layer METS1 \
        -customize -connect_to_pins low_end \
        -extend_to_boundaries_and_generate_pins

save_mw_cel -as pre_inst

source ./create_vssv_rail.tcl

#create_route_guide -coordinate {21.6 20.2 147.8 145.8} \
#         -no_preroute_layers MET1 \
#         -name {UNSIGN_MULT_1}

preroute_standard_cells \
        -nets  {VDD VSS VSSV} \
        -connect horizontal -extend_to_boundaries_and_generate_pins  \
        -port_filter_mode off -cell_master_filter_mode off \
        -cell_instance_filter_mode off -voltage_area_filter_mode off

#remove_route_guide -all

save_mw_cel -as preroute_std

# source -e -v ./create_vssv_rail.tcl > ./log/create_vssv_rail.log

verify_pg_nets  -macro_pin_connection all -pad_pin_connection all -error_cell ${top_design}_pg
open_mw_cel -not_as_current -readonly ${top_design}_pg

analyze_fp_rail  -nets {VDD VSS} -voltage_supply 1.2 -use_pins_as_pa

remove_stdcell_filler  -stdcell

save_mw_cel -as preroute

set_pnet_options -complete {MET6}
report_pnet_options
create_fp_placement  -timing_driven -incremental all

report_timing_preroute

connection_pg
connection_pg_macro
connection_pg_ps
save_mw_cel -as planned

source -e -v mte.tcl > mte.log

source -e -v ./placement.tcl > ./log/placement.log
set_ignored_layers    -min_routing_layer MET1 -max_routing_layer MET6
# connection_pg_tie
source -e -v ./route.tcl > ./log/route.log
source -e -v ./adjustment.tcl > ./log/adjustment.log
source -e -v ./output.tcl > ./log/output.log
