#include "address.h"

#ifndef NULL
#define NULL 0
#endif

static unsigned int *tas_memory_address;
static unsigned int *tas_memory_end;
static int tas_addr_allocate_start_flag = 0;
static unsigned int *tas_memory_freearea;
static void tas_addr_allocate_init(void);

static void tas_addr_allocate_init(void)
{
  tas_memory_address = (unsigned int*) TAS_MEM_TOP;
  tas_memory_end = (unsigned int*) TAS_MEM_BOTTOM;
  tas_memory_freearea = tas_memory_address;
  tas_addr_allocate_start_flag = 1;
}

void *tas_addr_allocate(unsigned int size)
{
  unsigned int *val;

  if ( size <= 0 )
	return NULL;
  if ( tas_addr_allocate_start_flag == 0 )
	tas_addr_allocate_init();

  if ( tas_memory_freearea + size < tas_memory_end ) {
	val = tas_memory_freearea;
	tas_memory_freearea += size;
	return val;
  } else {
	printf("\nout of tas memory!!!\n");
	exit(0);
  }	
}
