#include "address.h"

#ifndef NULL
#define NULL 0
#endif

static unsigned int *fad_memory_address;
static unsigned int *fad_memory_end;
static int fad_addr_allocate_start_flag = 0;
static unsigned int *fad_memory_freearea;
static void fad_addr_allocate_init(void);

static void fad_addr_allocate_init(void)
{
  fad_memory_address = (unsigned int*) FAD_MEM_TOP;
  fad_memory_end = (unsigned int*) FAD_MEM_BOTTOM;
  fad_memory_freearea = fad_memory_address;
  fad_addr_allocate_start_flag = 1;
}

void *fad_addr_allocate(unsigned int size)
{
  unsigned int *val;

  if ( size <= 0 )
	return NULL;
  if ( fad_addr_allocate_start_flag == 0 )
	fad_addr_allocate_init();

  if ( fad_memory_freearea + size < fad_memory_end ) {
	val = fad_memory_freearea;
	fad_memory_freearea += size;
	return val;
  } else {
	printf("\nout of fad memory!!!\n");
	exit(0);
  }	
}
