#ifndef ISIM_BUFFER
#define ISIM_BUFFER

using namespace std;

#include <isis/machine.h>
#include <isis/mapped_memory.h>

class shared_memory_access_queue
{
 private:
  struct QUEUEList {
	md_addr_t addr;      //$B%a%b%j%"%/%;%9%"%I%l%9(B
	int time,            //$BE}7W%G!<%?MQ(B
	  inst_id,           //$BL?Na(BID
	  puid,              //$B%W%m%;%C%5(BID
	  data_size,         //$B%a%b%j%"%/%;%9$N:]$N(Bbyte$BI}(B  
	  rw;                //Read or Write or Reply
	bool flag;           //PU$B$H%a%b%j!"$I$A$i$+$i$NMW5a$+(B
	// $B%G!<%?(B
	word_t data_w, data_w2;   //unsigned int$B7?(B
	half_t data_h;            //unsigned short$B7?(B
	byte_t data_b;            //unsigned char$B7?(B
	struct QUEUEList *next;	
  };

  struct QUEUEList *ListHead; 
  struct QUEUEList *ListTail; 

 public:
  shared_memory_access_queue();

  //$B%-%e!<$NKvHx$K%Q%1%C%H$N>pJs$rDI2C(B
  void insertlist(int, md_addr_t, word_t, word_t, half_t,
				  byte_t, int, int, int, size_t, bool);

  //$B%-%e!<Fb$N3:Ev$9$k%Q%1%C%H$N>pJs$r:o=|(B
  void deletelist(int, md_addr_t, int);

  //$B%-%e!<Fb$N%Q%1%C%H$N;2>H(B
  bool get_data(int*, md_addr_t*, word_t*, word_t*,
				half_t*, byte_t*, int*, int*, int*, size_t*, bool*);
};

#endif
