#include "shared_memory_access_queue.h"

shared_memory_access_queue::shared_memory_access_queue()
{
  ListHead = ListTail = NULL;
}

//$B%-%e!<$NKvHx$K%Q%1%C%H$N>pJs$rDI2C(B
void
shared_memory_access_queue::insertlist(int inst_id, md_addr_t addr, word_t dw1,
									   word_t dw2, half_t dh, byte_t db,
									   int data_size,
									   int rw, int puid, size_t time,
									   bool flag)
{
  struct QUEUEList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct QUEUEList*)malloc(sizeof(struct QUEUEList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	ListHead->inst_id = inst_id;
	ListHead->addr = addr;
	ListHead->data_w = dw1;
	ListHead->data_w2 = dw2;
	ListHead->data_h = dh;
	ListHead->data_b = db;
	ListHead->time = time;
	ListHead->puid = puid;
	ListHead->data_size = data_size;
	ListHead->rw = rw;
	ListHead->flag = flag;
	ListHead->next = NULL;
  } else {
	temp = (struct QUEUEList*)malloc(sizeof(struct QUEUEList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	temp->inst_id = inst_id;
	temp->addr = addr;
	temp->data_w = dw1;
	temp->data_w2 = dw2;
	temp->data_h = dh;
	temp->data_b = db;
	temp->time = time;
	temp->puid = puid;
	temp->data_size = data_size;
	temp->rw = rw;
	temp->flag = flag;
	temp->next = NULL;
	ListTail->next = temp;
	ListTail = temp;
  }
}

//$B%-%e!<Fb$N3:Ev$9$k%Q%1%C%H$N>pJs$r:o=|(B
void
shared_memory_access_queue::deletelist(int inst_id, md_addr_t addr, int puid)
{
  struct QUEUEList *Listptr;
  struct QUEUEList *temp;
  Listptr = ListHead;

  while(1){
	if (Listptr == ListHead
		&& Listptr->inst_id == inst_id
		&& Listptr->addr == addr
		&& Listptr->puid == puid ){
	  ListHead = Listptr->next;
	  if (Listptr == ListTail) {
		ListTail = NULL;
	  }
	  free(Listptr);
	  break;
	}
	if (Listptr->next != NULL
		&& Listptr->next->inst_id == inst_id
		&& Listptr->next->addr == addr
		&& Listptr->puid == puid ){
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  free(temp);
	  break;
	}
	if (Listptr->next == NULL)
	  break;
	Listptr = Listptr->next;
  }
}

//$B%-%e!<Fb$N%Q%1%C%H$N;2>H(B
bool
shared_memory_access_queue::get_data(int* inst_id, md_addr_t* addr,
									 word_t* dw1, word_t* dw2,
									 half_t* dh, byte_t* db, int* data_size,
									 int* rw, int* puid, size_t* time,
									 bool* flag)
{
  struct QUEUEList *Listptr;
  Listptr = ListHead;

  while(Listptr != NULL){
	*inst_id = Listptr->inst_id;
	*addr = Listptr->addr;
	*dw1 = Listptr->data_w;
	*dw2 = Listptr->data_w2;
	*dh = Listptr->data_h;
	*db = Listptr->data_b;
	*puid = Listptr->puid;
	*data_size = Listptr->data_size;
	*rw = Listptr->rw;
	*time = Listptr->time;
	*flag = Listptr->flag;
	return true;
  }
  return false;
}

