#ifndef ISIM_SHARED_MEMORY_H
#define ISIM_SHARED_MEMORY_H

using namespace std;

#include <isis/isim_bus_port.h>
#include "shared_memory_access_queue.h"
#include <isis/machine.h>
#include <isis/mapped_memory.h>

class shared_memory
{
 private:
  typedef isim_bus_port isim_bus_port_type;
  typedef mapped_memory<md_addr_t, md_addr_t, sizeof(md_addr_t),char> mem_type;
  isim_bus_port_type shbus_port;
  shared_memory_access_queue queue_A, queue_B;

  md_addr_t addr, send_addr;
  word_t data, data2, send_data, send_data2;
  half_t data_half, send_data_half;
  byte_t data_byte, send_data_byte;
  int rw, send_rw;
  int inst_id, send_inst_id;
  int data_size, send_data_size;
  bool flag, send_flag;
  int puid, send_puid;
  int latency;

  //$BE}7W%G!<%?MQ(B
  size_t clock_, overflow_counter, access_num,
	time, send_time, total_stall_time;
  bool clock_flag;

  enum state_type {
	READY,
	LATENCY,
	ACCESS
  };
  state_type state;

 public:
  mem_type* mem;
  shared_memory();
  void connect_mem(mem_type& a) { mem = &a; }
  void clock(void);

  const isim_bus_port_type& ref_shbus_port(void) const
  { return shbus_port; }
  isim_bus_port_type& ref_shbus_port(void)
  { return shbus_port; }  
};

#endif
