/* sim-outorder.c - sample out-of-order issue perf simulator implementation */

/* SimpleScalar(TM) Tool Suite
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 * All Rights Reserved. 
 * 
 * THIS IS A LEGAL DOCUMENT, BY USING SIMPLESCALAR,
 * YOU ARE AGREEING TO THESE TERMS AND CONDITIONS.
 * 
 * No portion of this work may be used by any commercial entity, or for any
 * commercial purpose, without the prior, written permission of SimpleScalar,
 * LLC (info@simplescalar.com). Nonprofit and noncommercial use is permitted
 * as described below.
 * 
 * 1. SimpleScalar is provided AS IS, with no warranty of any kind, express
 * or implied. The user of the program accepts full responsibility for the
 * application of the program and the use of any results.
 * 
 * 2. Nonprofit and noncommercial use is encouraged. SimpleScalar may be
 * downloaded, compiled, executed, copied, and modified solely for nonprofit,
 * educational, noncommercial research, and noncommercial scholarship
 * purposes provided that this notice in its entirety accompanies all copies.
 * Copies of the modified software can be delivered to persons who use it
 * solely for nonprofit, educational, noncommercial research, and
 * noncommercial scholarship purposes provided that this notice in its
 * entirety accompanies all copies.
 * 
 * 3. ALL COMMERCIAL USE, AND ALL USE BY FOR PROFIT ENTITIES, IS EXPRESSLY
 * PROHIBITED WITHOUT A LICENSE FROM SIMPLESCALAR, LLC (info@simplescalar.com).
 * 
 * 4. No nonprofit user may place any restrictions on the use of this software,
 * including as modified by the user, by any other authorized user.
 * 
 * 5. Noncommercial and nonprofit users may distribute copies of SimpleScalar
 * in compiled or executable form as set forth in Section 2, provided that
 * either: (A) it is accompanied by the corresponding machine-readable source
 * code, or (B) it is accompanied by a written offer, with no time limit, to
 * give anyone a machine-readable copy of the corresponding source code in
 * return for reimbursement of the cost of distribution. This written offer
 * must permit verbatim duplication by anyone, or (C) it is distributed by
 * someone who received only the executable form, and is accompanied by a
 * copy of the written offer of source code.
 * 
 * 6. SimpleScalar was developed by Todd M. Austin, Ph.D. The tool suite is
 * currently maintained by SimpleScalar LLC (info@simplescalar.com). US Mail:
 * 2395 Timbercrest Court, Ann Arbor, MI 48105.
 * 
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 */

#ifndef ISIM_SYSTEM_H
#define ISIM_SYSTEM_H

#include <stdio.h>
#include <setjmp.h>
#include <time.h>
#include <isis/array.h>
#include <isis/isis.h>
#include <isis/options.h>
#include <isis/stats.h>
#include <isis/memory_s.h>
#include <isis/isim_bus_port.h>
#include <isis/isim_processor.h>
#include "shared_bus.h"
#include "shared_memory.h"

class isim_system
{
private:
  typedef isim_system thisclass;
  typedef option_simple op_simple_type;
  typedef stats_simple st_simple_type;
  memory_simple mem_simple;
  op_simple_type *op_simple;
  st_simple_type *st_simple;
  //$BE}7W%G!<%?=PNOJ}K!(B
  int output_condition;  
  
public:
  //$B%7%_%e%l!<%7%g%s;~4V7WB,MQ(B
  int sim_elapsed_time;  
  
public:
  isim_system();
  void connect_option(op_simple_type& a){
	op_simple = &a;
	for ( unsigned int i = 0; i < soo.size(); i++ ) {
	  soo[i].connect_option(a);
	}
  }
  void connect_stats(st_simple_type& a) {
	st_simple = &a;
	for ( unsigned int i = 0; i < soo.size(); i++ ) {
	  soo[i].connect_stats(a);
	}
  }
  void connect_loader(jmp_buf* buf, FILE* file, char* a, char* b) {
	for ( unsigned int i = 0; i < soo.size(); i++ ) {
	  soo[i].connect_loader(buf, file, a, b);
	}
  }
  //$B%3%^%s%I%i%$%s%*%W%7%g%s(B
  void sim_reg_options(struct opt_odb_t *odb);
  //$B;XDj$5$l$?%3%^%s%I%i%$%s%*%W%7%g%s$N%A%'%C%/(B
  void sim_check_options(struct opt_odb_t *odb, int argc, char **argv);
  //$B<hF@$9$kE}7W%G!<%?(B
  void sim_reg_stats(struct stat_sdb_t *sdb);
  //$B%7%_%e%l!<%?$,<B9T$9$k%P%$%J%j$r%a%b%j$K%m!<%I(B
  void sim_load_prog(char *fname, int argc, char **argv, char **envp);
  void sim_aux_config(FILE *stream);
  void sim_aux_stats(FILE *stream);
  //$B%W%m%;%C%5$N=i4|@_Dj(B
  void sim_init(void);
  void sim_uninit(void);
  //$B<hF@$7$?E}7W%G!<%?$N=PNO(B
  void sim_print_stats(FILE *fd);  


  /*********************************************
  
 $B"-(B $B<BAu$9$k%7%9%F%`$K0MB8$9$kItJ,(B $B"-(B 

  **********************************************/

private:
  //$B6&M-%P%9(B
  shared_bus shbus;
  //$B6&M-%a%b%j%f%K%C%H(B
  shared_memory shmem;
  //$B6&M-%a%b%j(B
  mapped_memory<md_addr_t,md_addr_t,sizeof(md_addr_t),char> shared_mem_isis;

public:
  //$B%W%m%;%C%5(B
  array<isim_processor> soo;
  //$B%b%8%e!<%k4V$N@\B3(B
  void initialize(unsigned int, int);
  //$B3F%b%8%e!<%k$K%/%m%C%/$rF~$l$k(B
  void sim_main(void);
};

#endif
