#include "writeback_buffer.h"

writeback_buffer::writeback_buffer(void)
{
  ListHead = ListTail = NULL;
}

//$B%j%9%H$KDI2C(B ($BL?Na(BID$B=g$KJB$Y$i$l$k(B)
void
writeback_buffer::insertlist(instqueue::INSTList_type* inst, int reg1,
							 int reg2, bool r1_f, sword_t r1, bool r2_f,
							 sword_t r2, bool ri_f, int ri, bool rf_f,
							 sfloat_t rf, bool rd_f, dfloat_t rd, int sim_c)
{
  struct WBList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct WBList*)malloc(sizeof(struct WBList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	if ( r1_f ) ListHead->flag = 1;
	if ( r2_f ) ListHead->flag = 2;
	if ( ri_f ) ListHead->flag = 3;
	if ( rf_f ) ListHead->flag = 4;
	if ( rd_f ) ListHead->flag = 5;
	ListHead->reg1 = reg1;
	ListHead->reg2 = reg2;
	ListHead->r_1 = r1;
	ListHead->r_2 = r2;
	ListHead->r_i = ri;
	ListHead->r_f = rf;
	ListHead->r_d = rd;
	ListHead->inst = inst;
	ListHead->time = 0;
	ListHead->sim_cycle = sim_c;
    ListHead->next = NULL;
  } else {
	temp = (struct WBList*)malloc(sizeof(struct WBList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	if ( r1_f ) temp->flag = 1;
	if ( r2_f ) temp->flag = 2;
	if ( ri_f ) temp->flag = 3;
	if ( rf_f ) temp->flag = 4;
	if ( rd_f ) temp->flag = 5;
	temp->reg1 = reg1;
	temp->reg2 = reg2;
	temp->r_1 = r1;
	temp->r_2 = r2;
	temp->r_i = ri;
	temp->r_f = rf;
	temp->r_d = rd;
	temp->time = 0;
	temp->sim_cycle = sim_c;
	temp->inst = inst;

	struct WBList *Listptr;
	Listptr = ListHead;	

	while(1){
	  if (Listptr->inst->seq > inst->seq ) {
		temp->next = ListHead;
		ListHead = temp;
		break;
	  }
	  if (Listptr->next != NULL && Listptr->next->inst->seq > inst->seq ) {
		temp->next = Listptr->next;
		Listptr->next = temp;
		break;
	  }
	  if (Listptr->next == NULL) {
		temp->next = NULL;
		ListTail->next = temp;
		ListTail = temp;
		break;
	  }
	  Listptr = Listptr->next;
	}
  }
}


//$B%j%9%H$+$i:o=|(B
void
writeback_buffer::deletelist(INST_SEQ_TYPE label0)
{
  struct WBList *Listptr;
  struct WBList *temp;
  Listptr = ListHead;

  while(1){
	if (Listptr == ListHead && Listptr->inst->seq == label0 ){
	  ListHead = Listptr->next;
	  if (Listptr == ListTail)
		ListTail = NULL;
	  free(Listptr);
	  break;
	}
	if (Listptr->next != NULL && Listptr->next->inst->seq == label0) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  free(temp);
	  break;
	}
	if (Listptr->next == NULL)
	  break;
	Listptr = Listptr->next;
  }
}


//$B%j%9%H$+$i:o=|(B
void
writeback_buffer::deletelist_after_this(INST_SEQ_TYPE label0)
{
  struct WBList *Listptr;
  struct WBList *temp;
  Listptr = ListHead;
  bool flag = false;

  while( Listptr != NULL ) {
	if ( Listptr == ListHead && Listptr->inst->seq > label0 ) {
	  ListHead = Listptr->next;
	  if ( Listptr == ListTail ) {
		ListTail = NULL;
		free(Listptr);
		break;
	  } else {
		temp = Listptr;
		Listptr = Listptr->next;
		free(temp);
		flag = true;
	  }
	} else if ( Listptr->next != NULL
				&& Listptr->next->inst->seq > label0 ) {
	  if ( Listptr->next == ListTail ) {
		ListTail = Listptr;
		temp = Listptr->next;
		Listptr->next = NULL;
		free(temp);
		break;
	  } else {
		temp = Listptr->next;
		Listptr->next = temp->next;
		free(temp);
	  }
	} else {
	  Listptr = Listptr->next;
	}
  }
}


/* $B0z?t$H$7$FM?$($i$l$?L?Na(BID$B$r;}$DL?Na$N<B9T7k2L$rEO$9(B
   $B3FL?Na$,%l%8%9%?$r99?7$9$k:]$K8F$S=P$5$l$k(B */
void
writeback_buffer::get_element(INST_SEQ_TYPE label0,
							  sword_t* r1,
							  sword_t* r2,
							  int* ri,
							  sfloat_t* rf,
							  dfloat_t* rd)
{
  struct WBList *Listptr;
  Listptr = ListHead;

  while(Listptr != NULL){
	if (Listptr->inst->seq == label0){
	  *r1 = Listptr->r_1;
	  *r2 = Listptr->r_2;
	  *ri = Listptr->r_i;
	  *rf = Listptr->r_f;
	  *rd = Listptr->r_d;
	  break;
	}
	Listptr = Listptr->next;
  }
}

//$BL?Na$rJV$9(B
instqueue::INSTList_type*
writeback_buffer::ready_label(int time0)
{
  struct WBList *Listptr;
  Listptr = ListHead;
  
  while( Listptr != NULL ) {
	if ( Listptr->time < time0 ) {
	  Listptr->time = time0;
	  return Listptr->inst;
	}
	Listptr = Listptr->next;
  }
  return NULL;
}

//$B0z?t$GM?$($i$l$?L?Na(BID$B$r;}$DL?Na$,%j%9%H$KB8:_$9$k$+(B
bool
writeback_buffer::is(INST_SEQ_TYPE seq0)
{
  struct WBList *Listptr;
  Listptr = ListHead;
  
  while(Listptr != NULL){
	if (Listptr->inst->seq == seq0){
	  return 1;
	}
	Listptr = Listptr->next;
  }
  return 0;
}


void
writeback_buffer::printlist()
{
  struct WBList *Listptr;
  Listptr = ListHead;
  if ( ListHead == NULL ) {
	printf("No List\n");
  }
  while (Listptr != NULL){
	printf("%d ", Listptr->inst->seq);
	Listptr = Listptr->next;
  }
  printf("\n");
}


/* $B0z?t$H$7$FM?$($i$l$?L?Na(BID$B$r;}$DL?Na$,!"(B
   $B0z?t$H$7$FM?$($i$l$?%l%8%9%?HV9f$N%l%8%9%?$K(B
   $B=q$-9~$`CM(B($B$=$NL?Na$N<B9T7k2L(B)$B$rEO$9(B
   reorder buffer$B$NCM$r<hF@$7$?$$L?Na$K$h$C$F8F$S=P$5$l$k(B */
void
writeback_buffer::get_data(int reg_num, INST_SEQ_TYPE label0,
						   bool* r1_f, sword_t* r1,
						   bool* r2_f, sword_t* r2,
						   bool* ri_f, int* ri,
						   bool* rf_f, sfloat_t* rf,
						   bool* rd_f, dfloat_t* rd,
						   int sim_c)
{
  struct WBList *Listptr;
  Listptr = ListHead;

  while(Listptr != NULL){
	if (Listptr->inst->seq == label0){
	  switch( Listptr->flag ) {
	  case 1:
		*r1_f = true;
		*r1 = Listptr->r_1;
		break;
	  case 2:
		if ( Listptr->reg1 == reg_num ) {
		  *r1_f = true;
		  *r1 = Listptr->r_1;
		} else if ( Listptr->reg2 == reg_num ) {
		  *r2 = Listptr->r_2;
		  *r2_f = true;
		} else {
		  assert(0);
		}
		break;
	  case 3:
		assert( Listptr->reg1 == reg_num );
		*ri = Listptr->r_i;
		*ri_f = true;
		break;
	  case 4:
		assert( Listptr->reg1 == reg_num );
		*rf = Listptr->r_f;
		*rf_f = true;
		break;
	  case 5:
		assert( Listptr->reg1 == reg_num );
		*rd = Listptr->r_d;
		*rd_f = true;
		break;
	  }
	}
	Listptr = Listptr->next;
  }
}		
