#include "addr_order_buffer.h"

addr_order_buffer::addr_order_buffer()
{
  ListHead = ListTail = NULL;  
}

//$B%a%b%j%"%/%;%9$9$kL?Na$rEjF~(B
void
addr_order_buffer::insertlist(INST_SEQ_TYPE seq0, bool ls_flag)
{

  struct ADList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct ADList*)malloc(sizeof(struct ADList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	ListHead->seq = seq0;
	ListHead->addr = 0;
	ListHead->addr2 = 0;
	ListHead->addr_area = 0;
	ListHead->l_or_s = ls_flag;
	ListHead->lsq_data_flag = false;
	ListHead->lsq_data = 0;
	ListHead->lsq_data2 = 0;
	ListHead->lsq_data_get = false;
    ListHead->next = NULL;
	ListHead->prev = NULL;
  } else {
	temp = (struct ADList*)malloc(sizeof(struct ADList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	temp->seq = seq0;
	temp->addr = 0;
	temp->addr2 = 0;
	temp->addr_area = 0;
    temp->next = NULL;
	temp->l_or_s = ls_flag;
	temp->lsq_data = 0;
	temp->lsq_data2 = 0;
	temp->lsq_data_flag = false;
	temp->lsq_data_get = false;
    temp->prev = ListTail;
	ListTail->next = temp;
	ListTail = temp;
  }
}


/* $B%a%b%j%"%/%;%9%"%I%l%9$,7hDj$7$?$H$3$m$G!"(B
   $B3:Ev$9$kL?Na$N(Baddr$B!"(Baddr2$B!"(Baddr_area$B$r99?7(B */
void
addr_order_buffer::updatelist(INST_SEQ_TYPE seq0, 
							  md_addr_t addr, md_addr_t addr2, int addr_area)
{
  struct ADList *Listptr;
  Listptr = ListHead;

  while ( Listptr != NULL ) {
	if ( Listptr->seq == seq0 ) {
	  Listptr->addr = addr;
	  Listptr->addr2 = addr2;
	  Listptr->addr_area = addr_area;
	  return;
	}
	Listptr = Listptr->next;
  }
}


/* Store$BL?Na$,%a%b%j$K=q$-9~$`CM$,7h$^$C$?$H$3$m$G!"(B
   $B3:Ev$9$kL?Na$N(Blsq_data$B!"(Blsq_data2$B$r99?7(B */
void
addr_order_buffer::insert_store_data(INST_SEQ_TYPE seq0, 
									 sword_t r1, sword_t r2)
{
  struct ADList *Listptr;
  Listptr = ListHead;

  while ( Listptr != NULL ) {
	if ( Listptr->seq == seq0 ) {
	  Listptr->lsq_data = r1;
	  Listptr->lsq_data2 = r2;
	  Listptr->lsq_data_flag = true;
	  return;
	}
	Listptr = Listptr->next;
  }
}

//$BL?Na$N:o=|(B
void
addr_order_buffer::deletelist(INST_SEQ_TYPE seq0)
{
  struct ADList *Listptr;
  struct ADList *temp;
  Listptr = ListHead;

  if ( Listptr == NULL )
	return;

  while (1) {
	if ( Listptr == ListHead && Listptr->seq == seq0 ) {
	  ListHead = Listptr->next;
	  if ( ListHead != NULL)
		ListHead->prev = NULL;
	  if ( Listptr == ListTail )
		ListTail = NULL;
	  free(Listptr);
	  return;
	}
	if ( Listptr->next != NULL && Listptr->next->seq == seq0 ) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  if ( temp->next != NULL )
		temp->next->prev = Listptr;
	  free(temp);
	  return;
	}
	if ( Listptr->next == NULL )
	  return;
	Listptr = Listptr->next;
  }
  assert(0);
}


//$BL?Na$N:o=|(B
void
addr_order_buffer::deletelist_after_this(INST_SEQ_TYPE seq0)
{
  struct ADList *Listptr;
  struct ADList *temp;
  Listptr = ListHead;
  
  while( Listptr != NULL ) {
	if ( Listptr == ListHead && Listptr->seq > seq0 ) {
	  ListHead = Listptr->next;
	  if ( ListHead != NULL )
		ListHead->prev = NULL;
	  if ( ListTail == Listptr ) {
		ListTail = NULL;
		free(Listptr);
		break;
	  } else {
		temp = Listptr;
		Listptr = Listptr->next;
		free(temp);
	  }
	} else if ( Listptr->next != NULL
				&& Listptr->next->seq > seq0 ) {
	  if ( ListTail == Listptr->next ) {
		ListTail = Listptr;
		temp = Listptr->next;
		Listptr->next = NULL;
		free(temp);
		break;
	  } else {
		temp = Listptr->next;
		Listptr->next = temp->next;
		if ( temp->next != NULL )
		  temp->next->prev = Listptr;
		free(temp);
	  }
	} else {
	  Listptr = Listptr->next;
	}
  }
}


/* Load$BL?Na$K4X$9$k%a%b%j%"%/%;%9%"%I%l%9$N0MB84X78$rD4$Y!"(B
   $B0MB84X78$,$"$k>l9g$K$O(Bfalse$B!"$J$$>l9g$K$O(Btrue$B$rJV$9(B
   --- $B0MB84X78$,$"$k>l9g$G$b!"(B
   --- $BA0$K$"$k(BStore$BL?Na$H%"%/%;%9$9$k%"%I%l%9$,F1$8$G!"(B
   --- $B$=$N(BStore$BL?Na$N(BStore$B$9$kCM$,7h$^$C$F$$$k>l9g$K$O!"(B
   --- $B$=$NCM(B(lsq_data$B!"(Blsq_data2)$B$r(BLoad$BL?Na$KN.$7!"(Btrue$B$rJV$9(B */
bool
addr_order_buffer::checklist(INST_SEQ_TYPE seq0,
							 md_addr_t addr, md_addr_t addr2,
							 int area, bool ls_flag,
							 sword_t* data, sword_t* data2,
							 bool* lsq_data_flag, 
							 bool use_lsq_flag)
{
  struct ADList *Listptr;
  struct ADList *Reqptr;
  Listptr = ListHead;

  bool break_flag = false;
  if ( addr == 0 //$B%a%b%j%"%/%;%9%"%I%l%9L$3NDj(B
	   || ls_flag == 1 ) { //Store$BL?Na(B
	return true;
  }
  
  if ( addr < MACHINE_ADDRESS ) { //$B%m!<%+%k%a%b%j%"%/%;%9(B
	while ( Listptr != NULL ) {
	  if ( Listptr->seq > seq0 ) {
		return true;
	  }
	  if ( Listptr->seq == seq0 ) {
		Reqptr = Listptr;
		Listptr = Listptr->prev;
		break;
	  }
	  Listptr = Listptr->next;
	}
	  
	//$B%a%b%j%"%/%;%9%"%I%l%9$N0MB84X78%A%'%C%/3+;O(B
	while ( Listptr != NULL ) {
	  if ( Listptr->addr == 0 && Listptr->l_or_s == 1 ) {
		return false;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr
				  && (Listptr->addr + Listptr->addr_area) > addr ) {
		break_flag = true;
		break;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr2
				  && (Listptr->addr + Listptr->addr_area) > addr2 ) {
		break_flag = true;
		break;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr + area - 1
				  && (Listptr->addr + Listptr->addr_area) > addr + area - 1) {
		break_flag = true;
		break;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr2 + area - 1
				  && (Listptr->addr + Listptr->addr_area) > addr2 + area - 1) {
		break_flag = true;
		break;
	  } else if ( Listptr->addr2 != 0 ) {
		if ( Listptr->l_or_s == 1
			 && Listptr->addr2 <= addr
			 && (Listptr->addr2 + Listptr->addr_area) > addr ) {
		  break_flag = true;
		  break;
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr2
					&& (Listptr->addr2 + Listptr->addr_area) > addr2 ) {
		  break_flag = true;
		  break;
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr+area-1
					&& (Listptr->addr2 + Listptr->addr_area) > addr+area- 1) {
		  break_flag = true;
		  break;
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr2+area-1
					&& (Listptr->addr2 + Listptr->addr_area) > addr2+area-1 ) {
		  break_flag = true;
		  break;
		}
	  }
	  Listptr = Listptr->prev;
	}
	//$B%a%b%j%"%/%;%9%"%I%l%9$N0MB84X78%A%'%C%/=*N;(B

	if ( break_flag ) {

	  //Store$BL?Na$,%a%b%j$K=q$-9~$`CM(B(lsq_data)$B$r(BLoad$BL?Na$KN.$9(B
	  if ( !Reqptr->lsq_data_get && area == Listptr->addr_area
		   && Listptr->lsq_data_flag && use_lsq_flag ) {
		Reqptr->lsq_data_get = true;
		*data = Listptr->lsq_data;
		*lsq_data_flag = true;
		return true;
	  }	
	  return false;
	}

  } else { //$B6&M-%a%b%j%"%/%;%9(B
	
	//$B%a%b%j%"%/%;%9%"%I%l%9$N0MB84X78%A%'%C%/3+;O(B
	while ( Listptr != NULL ) {
	  if ( Listptr->seq >= seq0 ) {
		return true;
	  } else if ( Listptr->addr == 0 
				  && ( Listptr->l_or_s == 1 )) {
		return false;
		
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr
				  && (Listptr->addr + Listptr->addr_area) > addr ) {
		return false;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr2
				  && (Listptr->addr + Listptr->addr_area) > addr2 ) {
		return false;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr + area - 1
				  && (Listptr->addr + Listptr->addr_area) > addr + area - 1) {
		return false;
	  } else if ( Listptr->l_or_s == 1
				  && Listptr->addr <= addr2 + area - 1
				  && (Listptr->addr + Listptr->addr_area) > addr2 + area - 1) {
		return false;
	  } else if ( Listptr->addr2 != 0 ) {
		if ( Listptr->l_or_s == 1
			 && Listptr->addr2 <= addr
			 && (Listptr->addr2 + Listptr->addr_area) > addr ) {
		  return false;		  
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr2
					&& (Listptr->addr2 + Listptr->addr_area) > addr2 ) {
		  return false;
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr+area-1
					&& (Listptr->addr2 + Listptr->addr_area) > addr+area- 1) {
		  return false;
		} else if ( Listptr->l_or_s == 1
					&& Listptr->addr2 <= addr2+area-1
					&& (Listptr->addr2 + Listptr->addr_area) > addr2+area-1 ) {
		  return false;
		}
	  }
	  Listptr = Listptr->next;
	}
	//$B%a%b%j%"%/%;%9%"%I%l%9$N0MB84X78%A%'%C%/=*N;(B
  }
  return true;
}

void
addr_order_buffer::printlist()
{
  struct ADList *Listptr;
  Listptr = ListHead;
  if ( ListHead == NULL ) {
	printf("No List\n");
  }
  while (Listptr != NULL){
	printf("%10d  %10x  %10x\n",
		   Listptr->seq, Listptr->addr, Listptr->addr2);
	Listptr = Listptr->next;
  }
  printf("\n\n");
}
