#include "order_buffer.h"

order_buffer::order_buffer()
{
  ListHead = ListTail = NULL;
}

//$BL?Na$H%l%8%9%?HV9f$NEjF~(B
void
order_buffer::insertlist(INST_SEQ_TYPE seq0, int reg0, bool rw0)
{
  struct ORDERList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct ORDERList*)malloc(sizeof(struct ORDERList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	ListHead->seq = seq0;
	ListHead->reg = reg0;
	ListHead->rw = rw0;
    ListHead->next = NULL;
	ListHead->prev = NULL;
  } else {
	temp = (struct ORDERList*)malloc(sizeof(struct ORDERList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	temp->seq = seq0;
	temp->reg = reg0;
	temp->rw = rw0;
    temp->next = NULL;
    temp->prev = ListTail;
	ListTail->next = temp;
	ListTail = temp;
  }
}

//$BL?Na$N:o=|(B
void
order_buffer::deletelist(INST_SEQ_TYPE seq0)
{
  struct ORDERList *Listptr;
  struct ORDERList *temp;
  Listptr = ListHead;

  while ( 1 ) {
	if ( Listptr == NULL )
	  return;
	else if ( Listptr == ListHead && Listptr->seq == seq0 ) {
	  ListHead = Listptr->next;
	  if ( ListHead != NULL)
		ListHead->prev = NULL;
	  if ( Listptr == ListTail )
		ListTail = NULL;
	  temp = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	} else if ( Listptr->seq == seq0 ) {
	  if ( Listptr == ListTail ) {
		ListTail = Listptr->prev;
		Listptr->prev->next = NULL;
	  } else {
		Listptr->prev->next = Listptr->next;
		Listptr->next->prev = Listptr->prev;
	  }
	  temp = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	} else if ( Listptr->next != NULL && Listptr->next->seq == seq0 ) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  if ( temp->next != NULL )
		temp->next->prev = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	} else if ( Listptr->seq > seq0 ){
	  return;
	} else {
	  Listptr = Listptr->next;
	}
  }
}


//$BL?Na$N:o=|(B
void
order_buffer::deletelist_after_this(INST_SEQ_TYPE seq0)
{
  struct ORDERList *Listptr;
  struct ORDERList *temp;
  Listptr = ListHead;

  while ( 1 ) {
	if ( Listptr == NULL )
	  return;
	else if ( Listptr == ListHead && Listptr->seq > seq0 ) {
	  ListHead = Listptr->next;
	  if ( ListHead != NULL)
		ListHead->prev = NULL;
	  if ( Listptr == ListTail )
		ListTail = NULL;
	  temp = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	} else if ( Listptr->seq > seq0 ) {
	  if ( Listptr == ListTail ) {
		ListTail = Listptr->prev;
		Listptr->prev->next = NULL;
	  } else {
		Listptr->prev->next = Listptr->next;
		Listptr->next->prev = Listptr->prev;
	  }
	  temp = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	} else if ( Listptr->next != NULL && Listptr->next->seq > seq0 ) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  if ( temp->next != NULL )
		temp->next->prev = Listptr;
	  free(temp);
	  Listptr = Listptr->next;
	  //} else if ( Listptr->seq > seq0 ){
	} else if ( Listptr->next == NULL ){
	  return;
	} else {
	  Listptr = Listptr->next;
	}
  }
}


/* $B0z?t$H$7$F!"L?Na$,;HMQ$9$k%l%8%9%?HV9f$r<u$1<h$j!"(B
   $B%l%8%9%?4V$N0MB84X78$rD4$Y$k(B
   -  $B0MB84X78$,$J$$>l9g$K$OIi$N?t$rJV$9(B
   -  $B0MB84X78$,$"$k>l9g$K$O0MB84X78$N?t$rJV$7!"(B
   -  $B0MB84X78$N$"$kL?Na$NL?Na(BID$B$H%l%8%9%?HV9f$J$I$rEO$9(B
   -      $B0MB84X78$N?t$r<u$1<h$C$?3FL?Na$O(Breorder buffer$B$rD4$Y$k(B
   -      reorder buffer$B$+$i0MB84X78$N?tJ,$@$1CM$r<u$1<h$k$3$H$,(B
   -      $B$G$-$l$P!"(Breorder buffer$B$NCM$rMQ$$$FL?Na$r<B9T$9$k(B */
int
order_buffer::check_order(INST_SEQ_TYPE seq0, bool addr_flag,
						  int in01, int in02, int in03, int in04,
						  int out01, int out02, int out03,
						  int *label, int *opr, int *d_rw, int *my_rw)
{
  int check_reg[5];
  int check_rw[5];
  int j = 0;
  int d = 0;
  bool flag = false;

  /* $B<+J,$,;HMQ$9$k%l%8%9%?$K$D$$$F!"(B
	 check_reg$B$H(Bcheck_rw$B$K$^$H$a$k(B ($B3+;O(B) */
  if ( in01 != 0 ){
	check_reg[j] = in01;
	check_rw[j] = 0;
	j++;
  }
  if ( in02 != 0 ){
	check_reg[j] = in02;
	check_rw[j] = 0;
	j++;
  }
  if ( in03 != 0 ){
	check_reg[j] = in03;
	check_rw[j] = 0;
	j++;
  }
  if ( in04 != 0 ){
	check_reg[j] = in04;
	check_rw[j] = 0;
	j++;
  }
  if (!addr_flag) {
	if ( out01 != 0 ){
	  check_reg[j] = out01;
	  check_rw[j] = 1;
	  j++;
	}
	if ( out02 != 0 ){
	  check_reg[j] = out02;
	  check_rw[j] = 1;
	  j++;
	}
	if ( out03 != 0 ){
	  check_reg[j] = out03;
	  check_rw[j] = 1;
	  j++;
	}
  }
  /* $B<+J,$,;HMQ$9$k%l%8%9%?$K$D$$$F!"(B
	 check_reg$B$H(Bcheck_rw$B$K$^$H$a$k(B ($B=*N;(B) */

  if ( j == 0 ) { //$B%l%8%9%?$r;HMQ$7$J$$(B
	flag = true;
  }

  struct ORDERList *Listptr;
  Listptr = ListHead;

  if ( Listptr == NULL //$B%j%9%H$KL?Na$,$J$$(B
	   && flag ) //$B<+J,$O%l%8%9%?$r;HMQ$7$J$$(B
	return -3;  
  
  while ( Listptr != NULL ) {
	if ( Listptr->seq >= seq0 ) {
	  Listptr = Listptr->prev;
	  if ( Listptr == NULL ) { //$B<+J,$NA0$KL?Na$,$J$$(B
		return -2;
	  }
	  break;
	}
	Listptr = Listptr->next;
  }

  /* $B%l%8%9%?4V$K0MB84X78$,$"$kL?Na$N%l%8%9%?$K4X$9$k>pJs$r3NJ](B */
  while ( Listptr != NULL ) {
	for ( int i = 0; i < j; i++ ) {
	  if ( Listptr->reg == check_reg[i] && Listptr->rw == 1
		   && check_reg[i] != 0 ) {
		label[d] = Listptr->seq;
		opr[d] = Listptr->reg;
		d_rw[d] = Listptr->rw;
		my_rw[d] = check_rw[i];
		d++;
		check_reg[i] = 0;
	  } else if ( Listptr->reg == check_reg[i] && check_rw[i] == 1
				  && check_reg[i] != 0 ) {
		label[d] = Listptr->seq;
		opr[d] = Listptr->reg;
		d_rw[d] = Listptr->rw;
		my_rw[d] = check_rw[i];
		d++;
	  }
	}
	Listptr = Listptr->prev;
  }

  if ( d == 0 ) { //$B0MB84X78$,$"$kL?Na$,$J$$(B
	return -1;
  }
  else {
  	return d;     //$B0MB8?t$rJV$9(B
  }
}


void
order_buffer::printlist()
{
  printf("\n\n===========\n");

  struct ORDERList *Listptr;
  Listptr = ListHead;
  if ( ListHead == NULL ) {
	printf("No List\n");
  }
  while (Listptr != NULL){
	printf("%10d %10d\n", Listptr->seq, Listptr->reg);
	Listptr = Listptr->next;
  }
  printf("===========\n\n");
}
