/* sim-outorder.c - sample out-of-order issue perf simulator implementation */

/* SimpleScalar(TM) Tool Suite
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 * All Rights Reserved. 
 * 
 * THIS IS A LEGAL DOCUMENT, BY USING SIMPLESCALAR,
 * YOU ARE AGREEING TO THESE TERMS AND CONDITIONS.
 * 
 * No portion of this work may be used by any commercial entity, or for any
 * commercial purpose, without the prior, written permission of SimpleScalar,
 * LLC (info@simplescalar.com). Nonprofit and noncommercial use is permitted
 * as described below.
 * 
 * 1. SimpleScalar is provided AS IS, with no warranty of any kind, express
 * or implied. The user of the program accepts full responsibility for the
 * application of the program and the use of any results.
 * 
 * 2. Nonprofit and noncommercial use is encouraged. SimpleScalar may be
 * downloaded, compiled, executed, copied, and modified solely for nonprofit,
 * educational, noncommercial research, and noncommercial scholarship
 * purposes provided that this notice in its entirety accompanies all copies.
 * Copies of the modified software can be delivered to persons who use it
 * solely for nonprofit, educational, noncommercial research, and
 * noncommercial scholarship purposes provided that this notice in its
 * entirety accompanies all copies.
 * 
 * 3. ALL COMMERCIAL USE, AND ALL USE BY FOR PROFIT ENTITIES, IS EXPRESSLY
 * PROHIBITED WITHOUT A LICENSE FROM SIMPLESCALAR, LLC (info@simplescalar.com).
 * 
 * 4. No nonprofit user may place any restrictions on the use of this software,
 * including as modified by the user, by any other authorized user.
 * 
 * 5. Noncommercial and nonprofit users may distribute copies of SimpleScalar
 * in compiled or executable form as set forth in Section 2, provided that
 * either: (A) it is accompanied by the corresponding machine-readable source
 * code, or (B) it is accompanied by a written offer, with no time limit, to
 * give anyone a machine-readable copy of the corresponding source code in
 * return for reimbursement of the cost of distribution. This written offer
 * must permit verbatim duplication by anyone, or (C) it is distributed by
 * someone who received only the executable form, and is accompanied by a
 * copy of the written offer of source code.
 * 
 * 6. SimpleScalar was developed by Todd M. Austin, Ph.D. The tool suite is
 * currently maintained by SimpleScalar LLC (info@simplescalar.com). US Mail:
 * 2395 Timbercrest Court, Ann Arbor, MI 48105.
 * 
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 */

#ifndef ISIM_PROCESSOR_H
#define ISIM_PROCESSOR_H

using namespace std;

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <signal.h>
#include <iostream>
#include <vector>
#include <isis/isis.h>
#include <isis/host.h>
#include <isis/misc.h>
#include <isis/machine.h>
#include <isis/cache.h>
#include <isis/memory_s.h>
#include <isis/loader_s.h>
#include <isis/bpred.h>
#include <isis/resource.h>
#include <isis/options.h>
#include <isis/stats.h>
#include <isis/instqueue.h>
#include <isis/order_buffer.h>
#include <isis/addr_order_buffer.h>
#include <isis/exec_buffer.h>
#include <isis/writeback_buffer.h>
#include <isis/isim_bus_port.h>
#include <isis/address.h>

/*
 * This file implements a very detailed out-of-order issue superscalar
 * processor with a two-level memory system and speculative execution support.
 * This simulator is a performance simulator, tracking the latency of all
 * pipeline operations.
 */

typedef unsigned int INST_TAG_TYPE;
typedef unsigned int INST_SEQ_TYPE;

#define FU_IALU_INDEX 0
#define FU_IMULT_INDEX 1
#define FU_MEMPORT_INDEX 2
#define FU_FPALU_INDEX 3
#define FU_FPMULT_INDEX 4

class isim_processor
{
 private:
  typedef isim_processor thisclass;
  typedef stats_simple stats_simple_type;
  typedef option_simple option_simple_type;
  typedef isim_bus_port isim_bus_port_type;

  //$B%Q%1%C%H$r30It$XH/9T$9$k$?$a$N%]!<%H(B
  vector<isim_bus_port_type> outgoing_port;
  //$B30It$+$i$N%Q%1%C%H$r<u?.$9$k$?$a$N%]!<%H(B
  vector<isim_bus_port_type> incoming_port; 
  instqueue instq;
  exec_buffer exec_buf;
  writeback_buffer wb_buf;
  order_buffer order_buf;
  addr_order_buffer addr_order_buf;
  INST_SEQ_TYPE branch_seq;
  byte_t temp_byte;
  half_t temp_half;
  word_t temp_word;
  md_addr_t addr2, access_adr, access_adr2, t_adr, req_adr;
  int req_label, addr_area;
  word_t store_data;
  word_t load_data, load_data2;
  half_t load_data_half;
  byte_t load_data_byte;
  sword_t lsq_data, lsq_data2;
  half_t lsq_data_half;
  byte_t lsq_data_byte;
  bool lsq_data_flag;
  size_t punum;
  int result_i;
  sfloat_t result_ff;
  dfloat_t result_fd;
  sword_t result1, result2;
  bool result_i_flag, result_ff_flag, result_fd_flag,
	result1_flag, result2_flag, load_flag, use_lsq_flag;  
  int s_i[4];
  sfloat_t s_ff[4];
  dfloat_t s_fd[4];
  sword_t s1[4], s2[4];
  bool s_i_flag[4], s_ff_flag[4], s_fd_flag[4], s1_flag[4], s2_flag[4];
  bool in1_flag, in2_flag, in3_flag, in4_flag;  
  int fetch_num;
  bool exec_stop_flag, clock_flag;

 public:
  unsigned int max_insts;
  unsigned int inst_seq, ruu_fetch_issue_delay;
  int fastfwd_count, ruu_ifq_size,
	/*ruu_branch_penalty,*/ fetch_speed, tlb_miss_lat;
  int twolev_nelt, twolev_config[4], comb_nelt, comb_config[1],
	bimod_nelt, bimod_config[1];
  char *pred_type;
  int ras_size;
  int btb_nelt, btb_config[2];
  int ruu_decode_width, ruu_issue_width, ruu_commit_width;
  int /*RUU_tail, RUU_num, LSQ_tail, LSQ_num*/, RUU_size, LSQ_size;
  char *cache_dl1_opt, *cache_dl2_opt, *cache_il1_opt, *cache_il2_opt;
  int cache_dl1_lat, cache_dl2_lat, cache_il1_lat, cache_il2_lat;
  int /*flush_on_syscalls*/, compress_icache_addrs;
  int cache_flush_flag;
  int mem_bus_width;
  char *itlb_opt, *dtlb_opt;
  int res_ialu, res_imult, res_memport, res_fpalu, res_fpmult;
  int mem_nelt, mem_lat[2];
  //  int pcstat_nelt;
  int outside_port_num;
  struct res_desc fu_config[5];
  counter_t sim_num_insn, sim_total_insn, sim_total_refs, sim_total_loads,
	sim_total_branches, local_read_access, local_write_access,
	shared_read_access, shared_write_access,
	sync_read_access, sync_write_access, other_inst,
	IFQ_count,IFQ_fcount, RUU_count, RUU_fcount,
	LSQ_count, LSQ_fcount,
	pts_sim_total_insn, pts_sim_total_refs, pts_sim_total_loads,
	pts_sim_total_branches, pts_local_read_access, pts_local_write_access,
	pts_shared_read_access, pts_shared_write_access,
	pts_sync_read_access, pts_sync_write_access, pts_other_inst,
	pts_IFQ_count, pts_IFQ_fcount, pts_RUU_count, pts_RUU_fcount,
	pts_LSQ_count, pts_LSQ_fcount;
  tick_t sim_cycle, clock;
  struct cache_t *cache_il1, *cache_il2, *cache_dl1, *cache_dl2, *itlb, *dtlb,
	*s_cache_il1, *s_cache_il2, *s_cache_dl1, *s_cache_dl2, *s_itlb, *s_dtlb;
  unsigned int mem_access_latency(int);
  struct bpred_t *pred;
  struct res_pool *fu_pool;
  memory_simple mem_simple;
  bpred_simple bpred;
  cache_simple cache, stat_cache;
  resource_simple resrc_simple;
  loader_simple load_simple;
  int puid;
  md_addr_t addr;
  enum md_fault_type fault;
  md_inst_t inst;
  md_addr_t pred_PC, fetch_regs_PC , fetch_pred_PC, prev_branch_PC;
  struct fetch_rec {
	md_inst_t IR;
	md_addr_t regs_PC, pred_PC;
	struct bpred_update_t dir_update;
	int stack_recover_idx;
  };
  struct fetch_rec *fetch_data;
  int fetch_tail, fetch_head;
  struct regs_t regs;
  struct mem_t *mem;
  stats_simple_type *st_simple;
  option_simple_type *op_simple;

 public:
  isim_processor();
  void ruu_release_fu(void);
  void ruu_init(void);
  void lsq_init(void);
  void fetch_init(void);
  void ruu_issue(void);
  void get_data(void);
  void ruu_commit(void);
  void ruu_writeback(void);
  void ruu_dispatch(void);
  void ruu_fetch(void);
  void clock_in(void);
  void clock_out(void);
  md_addr_t iacompress(md_addr_t);
  int iscompress(size_t size) ;
  counter_t statval(struct stat_stat_t *);
  void connect_stats(stats_simple_type& a){
  	st_simple = &a;
	mem_simple.connect_stats(a);
	bpred.connect_stats(a);
	cache.connect_stats(a);
	stat_cache.connect_stats(a);
	load_simple.connect_stats(a);
  }
  void connect_loader(jmp_buf* buf, FILE* file, char* a, char* b) {
	load_simple.connect_eval(buf, file, a, b);
  }
  void connect_option(option_simple_type& a){ op_simple = &a; }
  void set_port(int portnum) {
	outgoing_port.resize(portnum);
	incoming_port.resize(portnum);
  }
  void set_puid(int a) { puid = a; }
  void set_punum(int a) { punum = a; }
  const isim_bus_port_type& ref_from_pu_port(int a) const
  { return outgoing_port[a]; }
  isim_bus_port_type& ref_from_pu_port(int a)
  { return outgoing_port[a]; }
  const isim_bus_port_type& ref_to_pu_port(int a) const
  { return incoming_port[a]; }
  isim_bus_port_type& ref_to_pu_port(int a)
  { return incoming_port[a]; }

  void NOP_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void NOP_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void NOP_impl(instqueue::INSTList_type* inst=NULL){}
  void NOP_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void JUMP_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void JUMP_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void JUMP_impl(instqueue::INSTList_type* inst=NULL);
  void JUMP_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void JAL_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void JAL_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void JAL_impl(instqueue::INSTList_type* inst=NULL);
  void JAL_reg_impl(instqueue::INSTList_type* inst=NULL);

  void JR_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void JR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void JR_impl(instqueue::INSTList_type* inst=NULL);
  void JR_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void JALR_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void JALR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void JALR_impl(instqueue::INSTList_type* inst=NULL);
  void JALR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void BEQ_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BEQ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BEQ_impl(instqueue::INSTList_type* inst=NULL);
  void BEQ_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BNE_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BNE_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BNE_impl(instqueue::INSTList_type* inst=NULL);
  void BNE_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BLEZ_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BLEZ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BLEZ_impl(instqueue::INSTList_type* inst=NULL);
  void BLEZ_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BGTZ_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BGTZ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BGTZ_impl(instqueue::INSTList_type* inst=NULL);
  void BGTZ_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BLTZ_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BLTZ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BLTZ_impl(instqueue::INSTList_type* inst=NULL);
  void BLTZ_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BGEZ_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BGEZ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BGEZ_impl(instqueue::INSTList_type* inst=NULL);
  void BGEZ_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BC1F_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BC1F_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BC1F_impl(instqueue::INSTList_type* inst=NULL);
  void BC1F_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BC1T_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BC1T_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BC1T_impl(instqueue::INSTList_type* inst=NULL);
  void BC1T_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void ADD_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ADD_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ADD_impl(instqueue::INSTList_type* inst=NULL);
  void ADD_reg_impl(instqueue::INSTList_type* inst=NULL);

  void ADDI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDI_impl(instqueue::INSTList_type* inst=NULL);
  void ADDI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void ADDU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDU_impl(instqueue::INSTList_type* inst=NULL);
  void ADDU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void ADDIU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDIU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ADDIU_impl(instqueue::INSTList_type* inst=NULL);
  void ADDIU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SUB_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SUB_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SUB_impl(instqueue::INSTList_type* inst=NULL);
  void SUB_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SUBU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SUBU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SUBU_impl(instqueue::INSTList_type* inst=NULL);
  void SUBU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MULT_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MULT_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MULT_impl(instqueue::INSTList_type* inst=NULL);
  void MULT_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MULTU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MULTU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MULTU_impl(instqueue::INSTList_type* inst=NULL);
  void MULTU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DIV_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void DIV_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DIV_impl(instqueue::INSTList_type* inst=NULL);
  void DIV_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DIVU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void DIVU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DIVU_impl(instqueue::INSTList_type* inst=NULL);
  void DIVU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MFHI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MFHI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MFHI_impl(instqueue::INSTList_type* inst=NULL);
  void MFHI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MTHI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MTHI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MTHI_impl(instqueue::INSTList_type* inst=NULL);
  void MTHI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MFLO_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MFLO_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MFLO_impl(instqueue::INSTList_type* inst=NULL);
  void MFLO_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MTLO_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MTLO_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MTLO_impl(instqueue::INSTList_type* inst=NULL);
  void MTLO_reg_impl(instqueue::INSTList_type* inst=NULL);

  void AND__addr_impl(instqueue::INSTList_type* inst=NULL){}
  void AND__set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void AND__impl(instqueue::INSTList_type* inst=NULL);
  void AND__reg_impl(instqueue::INSTList_type* inst=NULL);

  void ANDI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ANDI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ANDI_impl(instqueue::INSTList_type* inst=NULL);
  void ANDI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void OR_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void OR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void OR_impl(instqueue::INSTList_type* inst=NULL);
  void OR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void ORI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void ORI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void ORI_impl(instqueue::INSTList_type* inst=NULL);
  void ORI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void XOR_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void XOR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void XOR_impl(instqueue::INSTList_type* inst=NULL);
  void XOR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void XORI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void XORI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void XORI_impl(instqueue::INSTList_type* inst=NULL);
  void XORI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void NOR_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void NOR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void NOR_impl(instqueue::INSTList_type* inst=NULL);
  void NOR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLL_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLL_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLL_impl(instqueue::INSTList_type* inst=NULL);
  void SLL_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLLV_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLLV_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLLV_impl(instqueue::INSTList_type* inst=NULL);
  void SLLV_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SRL_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SRL_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SRL_impl(instqueue::INSTList_type* inst=NULL);
  void SRL_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SRLV_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SRLV_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SRLV_impl(instqueue::INSTList_type* inst=NULL);
  void SRLV_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SRA_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SRA_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SRA_impl(instqueue::INSTList_type* inst=NULL);
  void SRA_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SRAV_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SRAV_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SRAV_impl(instqueue::INSTList_type* inst=NULL);
  void SRAV_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLT_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLT_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLT_impl(instqueue::INSTList_type* inst=NULL);
  void SLT_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLTI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTI_impl(instqueue::INSTList_type* inst=NULL);
  void SLTI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLTU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTU_impl(instqueue::INSTList_type* inst=NULL);
  void SLTU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SLTIU_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTIU_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SLTIU_impl(instqueue::INSTList_type* inst=NULL);
  void SLTIU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FADD_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FADD_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FADD_S_impl(instqueue::INSTList_type* inst=NULL);
  void FADD_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FADD_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FADD_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FADD_D_impl(instqueue::INSTList_type* inst=NULL);
  void FADD_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FSUB_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FSUB_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FSUB_S_impl(instqueue::INSTList_type* inst=NULL);
  void FSUB_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FSUB_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FSUB_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FSUB_D_impl(instqueue::INSTList_type* inst=NULL);
  void FSUB_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FMUL_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FMUL_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FMUL_S_impl(instqueue::INSTList_type* inst=NULL);
  void FMUL_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FMUL_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FMUL_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FMUL_D_impl(instqueue::INSTList_type* inst=NULL);
  void FMUL_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FDIV_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FDIV_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FDIV_S_impl(instqueue::INSTList_type* inst=NULL);
  void FDIV_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FDIV_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FDIV_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FDIV_D_impl(instqueue::INSTList_type* inst=NULL);
  void FDIV_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FABS_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FABS_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FABS_S_impl(instqueue::INSTList_type* inst=NULL);
  void FABS_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FABS_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FABS_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FABS_D_impl(instqueue::INSTList_type* inst=NULL);
  void FABS_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FMOV_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FMOV_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FMOV_S_impl(instqueue::INSTList_type* inst=NULL);
  void FMOV_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FMOV_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FMOV_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FMOV_D_impl(instqueue::INSTList_type* inst=NULL);
  void FMOV_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FNEG_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FNEG_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FNEG_S_impl(instqueue::INSTList_type* inst=NULL);
  void FNEG_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FNEG_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FNEG_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FNEG_D_impl(instqueue::INSTList_type* inst=NULL);
  void FNEG_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_S_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_S_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_S_D_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_S_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_S_W_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_S_W_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_S_W_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_S_W_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_D_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_D_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_D_S_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_D_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_D_W_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_D_W_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_D_W_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_D_W_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_W_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_W_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_W_S_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_W_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CVT_W_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_W_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CVT_W_D_impl(instqueue::INSTList_type* inst=NULL);
  void CVT_W_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_EQ_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_EQ_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_EQ_S_impl(instqueue::INSTList_type* inst=NULL);
  void C_EQ_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_EQ_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_EQ_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_EQ_D_impl(instqueue::INSTList_type* inst=NULL);
  void C_EQ_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_LT_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LT_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LT_S_impl(instqueue::INSTList_type* inst=NULL);
  void C_LT_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_LT_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LT_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LT_D_impl(instqueue::INSTList_type* inst=NULL);
  void C_LT_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_LE_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LE_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LE_S_impl(instqueue::INSTList_type* inst=NULL);
  void C_LE_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void C_LE_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LE_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void C_LE_D_impl(instqueue::INSTList_type* inst=NULL);
  void C_LE_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FSQRT_S_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FSQRT_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FSQRT_S_impl(instqueue::INSTList_type* inst=NULL);
  void FSQRT_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void FSQRT_D_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void FSQRT_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void FSQRT_D_impl(instqueue::INSTList_type* inst=NULL);
  void FSQRT_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SYSCALL_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void SYSCALL_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SYSCALL_impl(instqueue::INSTList_type* inst=NULL);
  void SYSCALL_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void BREAK_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void BREAK_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void BREAK_impl(instqueue::INSTList_type* inst=NULL);
  void BREAK_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void LUI_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void LUI_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void LUI_impl(instqueue::INSTList_type* inst=NULL);
  void LUI_reg_impl(instqueue::INSTList_type* inst=NULL);

  void MFC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MFC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MFC1_impl(instqueue::INSTList_type* inst=NULL);
  void MFC1_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DMFC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void DMFC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DMFC1_impl(instqueue::INSTList_type* inst=NULL);
  void DMFC1_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CFC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CFC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CFC1_impl(instqueue::INSTList_type* inst=NULL){}
  void CFC1_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void MTC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void MTC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void MTC1_impl(instqueue::INSTList_type* inst=NULL);
  void MTC1_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DMTC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void DMTC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DMTC1_impl(instqueue::INSTList_type* inst=NULL);
  void DMTC1_reg_impl(instqueue::INSTList_type* inst=NULL);

  void CTC1_addr_impl(instqueue::INSTList_type* inst=NULL){}
  void CTC1_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void CTC1_impl(instqueue::INSTList_type* inst=NULL){}
  void CTC1_reg_impl(instqueue::INSTList_type* inst=NULL){}

  void LB_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LB_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LB_impl(instqueue::INSTList_type* inst=NULL);
  void LB_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LBU_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LH_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LH_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LH_impl(instqueue::INSTList_type* inst=NULL);
  void LH_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LHU_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LW_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LW_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LW_impl(instqueue::INSTList_type* inst=NULL);
  void LW_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DLW_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_reg_impl(instqueue::INSTList_type* inst=NULL);

  void L_S_addr_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void L_D_addr_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LWL_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LWL_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LWL_impl(instqueue::INSTList_type* inst=NULL);
  void LWL_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LWR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LWR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LWR_impl(instqueue::INSTList_type* inst=NULL);
  void LWR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SB_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SB_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SB_impl(instqueue::INSTList_type* inst=NULL);
  void SB_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SH_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SH_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SH_impl(instqueue::INSTList_type* inst=NULL);
  void SH_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SW_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SW_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SW_impl(instqueue::INSTList_type* inst=NULL);
  void SW_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DSW_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DSW_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DSW_impl(instqueue::INSTList_type* inst=NULL);
  void DSW_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DSZ_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DSZ_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DSZ_impl(instqueue::INSTList_type* inst=NULL);
  void DSZ_reg_impl(instqueue::INSTList_type* inst=NULL);

  void S_S_addr_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void S_S_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_reg_impl(instqueue::INSTList_type* inst=NULL);

  void S_D_addr_impl(instqueue::INSTList_type* inst=NULL);
  void S_D_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void S_D_impl(instqueue::INSTList_type* inst=NULL);
  void S_D_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SWL_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SWL_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void SWL_impl(instqueue::INSTList_type* inst=NULL);
  void SWL_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SWR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SWR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void SWR_impl(instqueue::INSTList_type* inst=NULL);
  void SWR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LB_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LB_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LB_RR_impl(instqueue::INSTList_type* inst=NULL);
  void LB_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LBU_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_RR_impl(instqueue::INSTList_type* inst=NULL);
  void LBU_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LH_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LH_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LH_RR_impl(instqueue::INSTList_type* inst=NULL);
  void LH_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LHU_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_RR_impl(instqueue::INSTList_type* inst=NULL);
  void LHU_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LW_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DLW_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_RR_impl(instqueue::INSTList_type* inst=NULL);
  void DLW_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void L_S_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void L_D_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_RR_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_RR_impl(instqueue::INSTList_type* inst=NULL);
  void L_D_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SB_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SB_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SB_RR_impl(instqueue::INSTList_type* inst=NULL);
  void SB_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SH_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SH_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SH_RR_impl(instqueue::INSTList_type* inst=NULL);
  void SH_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SW_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SW_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SW_RR_impl(instqueue::INSTList_type* inst=NULL);
  void SW_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DSW_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DSW_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DSW_RR_impl(instqueue::INSTList_type* inst=NULL);
  void DSW_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void DSZ_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void DSZ_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void DSZ_RR_impl(instqueue::INSTList_type* inst=NULL);
  void DSZ_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void S_S_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void S_S_RR_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void S_D_RR_addr_impl(instqueue::INSTList_type* inst=NULL);
  void S_D_RR_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void S_D_RR_impl(instqueue::INSTList_type* inst=NULL);
  void S_D_RR_reg_impl(instqueue::INSTList_type* inst=NULL);

  void L_S_RR_R2_addr_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_R2_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_R2_impl(instqueue::INSTList_type* inst=NULL);
  void L_S_RR_R2_reg_impl(instqueue::INSTList_type* inst=NULL);

  void S_S_RR_R2_addr_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_RR_R2_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void S_S_RR_R2_impl(instqueue::INSTList_type* inst=NULL);
  void S_S_RR_R2_reg_impl(instqueue::INSTList_type* inst=NULL);

  void LW_RR_R2_addr_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_R2_set_req_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_R2_impl(instqueue::INSTList_type* inst=NULL);
  void LW_RR_R2_reg_impl(instqueue::INSTList_type* inst=NULL);

  void SW_RR_R2_addr_impl(instqueue::INSTList_type* inst=NULL);
  void SW_RR_R2_set_req_impl(instqueue::INSTList_type* inst=NULL){}
  void SW_RR_R2_impl(instqueue::INSTList_type* inst=NULL);
  void SW_RR_R2_reg_impl(instqueue::INSTList_type* inst=NULL);

  void set_tpc(md_addr_t);
  md_addr_t target_PC;
  void set_npc(md_addr_t);
  md_addr_t cpc(void);
  void set_cpc(md_addr_t);
  signed int gpr(int);
  void set_gpr(int, signed int);
  signed int fpr_l(int);
  void set_fpr_l(int, signed int);
  float fpr_f(int);
  void set_fpr_f(int, float);
  double fpr_d(int);
  void set_fpr_d(int, double);
  signed int hi(void);
  void set_hi(signed int);
  signed int lo(void);
  void set_lo(signed int);  
  int fcc(void);
  void set_fcc(int);  
  byte_t read_byte(md_addr_t, md_fault_type);
  half_t read_half(md_addr_t, md_fault_type);
  word_t read_word(md_addr_t, md_fault_type);
  void write_byte(md_addr_t, md_addr_t, md_fault_type);
  void write_half(md_addr_t, md_addr_t, md_fault_type);
  void write_word(md_addr_t, md_addr_t, md_fault_type);
  void syscall(md_inst_t);
  void md_fetch_inst(md_addr_t);
  void declare_fault(md_fault_type);
  unsigned int extractl(int, int, int);
  void choose_operand(bool, sword_t*, int, int);
  void choose_operand_l(bool, sword_t*, int, int, bool*);
  void choose_operand_fcc(bool, sword_t*, int, bool*);
  void choose_operand_hi(bool, sword_t*, int);
  void choose_operand_lo(bool, sword_t*, int);
  void choose_operand_ff(bool, sfloat_t*, int, int, bool*);
  void choose_operand_fd(bool, dfloat_t*, int, int, bool*);
  
 private:
  void debug_output_pc(instqueue::INSTList_type *inst){
	if( inst == NULL ) {
	  return ;
	}
	ios_base::fmtflags flags = cout.flags();
	enum md_opcode op = MD_SET_OPCODE(op, inst->inst); // Operation Code
	string opname = string(MD_OP_NAME(op)); // Operation Name
	md_addr_t pc = inst->now_PC;
	cout << dec ;
	cout << "PU[" << puid << "] ";
	cout << hex ;
	cout.fill('0');
	cout << "PC: 0x" << setw(8) << pc << " ";
	cout << opname << " ";
	cout.flush();
	cout.flags(flags);
  }
};

#endif
