/* This doesn't look like -*- C++ -*-, but it is! */

/* pisa.def - SimpleScalar portable ISA (pisa) machine definition */

/* SimpleScalar(TM) Tool Suite
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 * All Rights Reserved. 
 * 
 * THIS IS A LEGAL DOCUMENT, BY USING SIMPLESCALAR,
 * YOU ARE AGREEING TO THESE TERMS AND CONDITIONS.
 * 
 * No portion of this work may be used by any commercial entity, or for any
 * commercial purpose, without the prior, written permission of SimpleScalar,
 * LLC (info@simplescalar.com). Nonprofit and noncommercial use is permitted
 * as described below.
 * 
 * 1. SimpleScalar is provided AS IS, with no warranty of any kind, express
 * or implied. The user of the program accepts full responsibility for the
 * application of the program and the use of any results.
 * 
 * 2. Nonprofit and noncommercial use is encouraged. SimpleScalar may be
 * downloaded, compiled, executed, copied, and modified solely for nonprofit,
 * educational, noncommercial research, and noncommercial scholarship
 * purposes provided that this notice in its entirety accompanies all copies.
 * Copies of the modified software can be delivered to persons who use it
 * solely for nonprofit, educational, noncommercial research, and
 * noncommercial scholarship purposes provided that this notice in its
 * entirety accompanies all copies.
 * 
 * 3. ALL COMMERCIAL USE, AND ALL USE BY FOR PROFIT ENTITIES, IS EXPRESSLY
 * PROHIBITED WITHOUT A LICENSE FROM SIMPLESCALAR, LLC (info@simplescalar.com).
 * 
 * 4. No nonprofit user may place any restrictions on the use of this software,
 * including as modified by the user, by any other authorized user.
 * 
 * 5. Noncommercial and nonprofit users may distribute copies of SimpleScalar
 * in compiled or executable form as set forth in Section 2, provided that
 * either: (A) it is accompanied by the corresponding machine-readable source
 * code, or (B) it is accompanied by a written offer, with no time limit, to
 * give anyone a machine-readable copy of the corresponding source code in
 * return for reimbursement of the cost of distribution. This written offer
 * must permit verbatim duplication by anyone, or (C) it is distributed by
 * someone who received only the executable form, and is accompanied by a
 * copy of the written offer of source code.
 * 
 * 6. SimpleScalar was developed by Todd M. Austin, Ph.D. The tool suite is
 * currently maintained by SimpleScalar LLC (info@simplescalar.com). US Mail:
 * 2395 Timbercrest Court, Ann Arbor, MI 48105.
 * 
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 */


/* This file defines all aspects of the SimpleScalar instruction set
 * architecture.  Each instruction set in the architecture has a DEFINST()
 * macro call included below.  The contents of a instruction definition are
 * as follows:
 *
 *   DEFINST(<enum>,			<opcode>,
 *	     <opname>,			<operands>,
 *	     <fu_req>,			<iflags>,
 *	     <output deps...>,		<input deps...>,
 *	     <expr>)
 *
 * Where:
 *
 *   <enum>	- is an enumerator that is returned when an instruction is
 *		  decoded by SS_OP_ENUM()
 *   <opcode>	- is the opcode of this instruction
 *   <opname>   - name of this instruction as a string, used by disassembler
 *   <operands>	- specified the instruction operand fields and their printed
 * 		  order for disassembly, used by disassembler, the recognized
 *		  operand field are (the instruction format is detailed in
 *		  the header file ss.h):
 *		    J - target field
 *		    j - PC relative target (offset + PC)
 *		    s - S register field
 *		    b - S register field (base register)
 *		    t - T register field
 *		    d - D register field
 *		    S - S register field (FP register)
 *		    T - T register field (FP register)
 *		    D - D register field (FP register)
 *		    o - load address offset (offset)
 *		    i - signed immediate field value
 *		    u - unsigned immediate field value
 *		    U - upper immediate field value
 *		    H - shift amount immediate field value
 *		    B - break code
 *
 *   <fu_req>	- functional unit requirements for this instruction
 *   <iflags>	- instruction flags, accessible via the SS_OP_FLAGS()
 *		  macro, flags are defined with F_* prefix in ss.h
 *   <output deps...>
 *		- a list of up to two output dependency designators, the
 *		  following designators are recognized (place an DNA in any
 *		  unused fields:
 *		    DGPR(N)   - general purpose register N
 *		    DGPR_D(N) - double word general purpose register N
 *		    DCGPR(N)  - general purpose register conditional on
 *			        pre/post- increment/decrement mode
 *		    DFPR_L(N) - floating-point register N, as word
 *		    DFPR_F(N) - floating-point reg N, as single-prec float
 *		    DFPR_D(N) - floating-point reg N, as double-prec double
 *		    DHI	      - HI result register
 *		    DLO	      - LO result register
 *		    DFCC      - floating point condition codes
 *		    DCPC      - current PC
 *		    DNPC      - next PC
 *		    DNA	      - no dependence
 */
/*   <input deps...>
 *		- a list of up to three input dependency designators, the
 *		  designators are defined above (place an DNA in any unused
 *		  fields.
 *
 *   <expr>	- a C expression that implements the instruction being
 * 		  defined, the expression must modify all architected state
 *		  affected by the instruction's execution, by default, the
 *		  next PC (NPC) value defaults to the current PC (CPC) plus
 *		  SS_INST_SIZE, as a result, only taken branches need to set
 *		  NPC
 *
 *		  The following predefined macros are available for use in
 *		  DEFINST() instruction expressions to access the value of
 *		  instruction operand/opcode field values:
 *
 *		    RS	    - RS register field value
 *		    RT	    - RT register field value
 *		    RD	    - RD register field value
 *		    FS	    - RS register field value
 *		    FT	    - RT register field value
 *		    FD	    - RD register field value
 *		    BS	    - RS register field value
 *		    TARG    - jump target field value
 *		    OFS	    - signed offset field value
 *		    IMM	    - signed offset field value
 *		    UIMM    - unsigned offset field value
 *		    SHAMT   - shift amount field value
 *		    BCODE   - break code field value
 */
/*		  To facilitate the construction of performance simulators
 *		  (which may want to specialize their architected state
 *		  storage format), all architected register and memory state
 *		  is accessed through the following macros:
 *
 *		    GPR(N)         - read general purpose register N
 *		    SET_GPR(N,E)   - write general purpose register N with E
 *		    GPR_D(N)       - read double word general purpose reg N
 *		    SET_GPR_D(N,E) - write double word gen purpose reg N w/ E
 *		    FPR_L(N)       - read floating-point register N, as word
 *		    SET_FPR_L(N,E) - floating-point reg N, as word, with E
 *		    FPR_F(N)       - read FP reg N, as single-prec float
 *		    SET_FPR_F(N,E) - write FP reg N, as single-prec float w/ E
 *		    FPR_D(N)       - read FP reg N, as double-prec double
 *		    SET_FPR_D(N,E) - write FP reg N, as double-prec double w/E
 *		    HI	           - read HI result register
 *		    SET_HI(E)      - write HI result register with E
 *		    LO	           - read LO result register
 *		    SET_LO(E)      - write LO result register with E
 *		    FCC	           - read floating point condition codes
 *		    SET_FCC(E)     - write floating point condition codes w/ E
 *		    CPC	           - read current PC register
 *		    NPC	           - read next PC register
 *		    SET_NPC(E)     - write next PC register with E
 *		    TPC	           - read target PC register
 *		    SET_TPC(E)     - write target PC register with E
 *
 *		    READ_SIGNED_BYTE(A)   - read signed byte from address A
 *		    READ_UNSIGNED_BYTE(A) - read unsigned byte from address A
 *		    READ_SIGNED_HALF(A)   - read signed half from address A
 *		    READ_UNSIGNED_HALF(A) - read unsigned half from address A
 *		    READ_WORD(A)          - read word from address A
 *		    WRITE_BYTE(E,A)       - write byte value E to address A
 *		    WRITE_HALF(E,A)       - write half value E to address A
 *		    WRITE_WORD(E,A)       - write word value E to address A
 *
 *		  Finally, the following helper functions are available to
 *		  assist in the construction of instruction expressions:
 *
 *		    INC_DEC(E,N,S) - execute E and update N as per pre/post-
 *				     incr/decr addressing sementics for an
 *				     access of S bytes
 *		    OVER(X,Y)      - check for overflow for X+Y, both signed
 *		    UNDER(X,Y)	   - check for umderflow for X-Y, both signed
 *		    DIV0(N)	   - check for divide by zero, N is denom
 *		    INTALIGN(N)    - check double word int reg N alignment
 *		    FPALIGN(N)	   - check double word FP reg N alignment
 *		    TALIGN(T)	   - check jump target T alignment
 */

#include "isim_processor.h"
//#define DEBUG_ISIM_PROCESSOR

void
isim_processor::JUMP_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  set_tpc((cpc() & 036000000000) | (TARG << 2));
  set_npc((cpc() & 036000000000) | (TARG << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::JAL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  set_tpc((cpc() & 036000000000) | (TARG << 2));
  set_npc((cpc() & 036000000000) | (TARG << 2));
  result1 = cpc() + 8;
  result1_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::JAL_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(31, result1);

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::JR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  if (temp & 0x7)
	assert(0);
  set_tpc(temp);
  set_npc(temp);

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::JALR_impl(instqueue::INSTList_type* inst_st)   
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  if (temp & 0x7)
	assert(0);
  result1 = cpc() + 8;
  set_tpc(temp);
  set_npc(temp);
  result1_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::JALR_reg_impl(instqueue::INSTList_type* inst_st)   
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BEQ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp == temp2)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BNE_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp != temp2)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}
   
void
isim_processor::BLEZ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp <= 0)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BGTZ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp > 0)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BLTZ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp < 0)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BGEZ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  set_tpc(cpc() + 8 + (OFS << 2));
  if (temp >= 0)
	set_npc(cpc() + 8 + (OFS << 2));

#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BC1F_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  int temp;
  exec_stop_flag = false;
  choose_operand_fcc(in1_flag, &temp, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	set_tpc(cpc() + 8 + (OFS << 2));
	if (!temp)
	  set_npc(cpc() + 8 + (OFS << 2));
  }

#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BC1T_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  int temp;
  exec_stop_flag = false;
  choose_operand_fcc(in1_flag, &temp, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	set_tpc(cpc() + 8 + (OFS << 2));
	if (temp)
	  set_npc(cpc() + 8 + (OFS << 2));
  }

#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout.fill('0');
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 1;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << " addr_impl ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet() 
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sbyte_t _result;

  if ( load_flag ) {
	_result = load_data_byte;
  } else {
	if ( lsq_data_flag ) {
	  _result = (byte_t)(word_t)lsq_data;
	} else {
	  enum md_fault_type _fault;
	  _result = read_byte(access_adr, _fault);
	}
  }
  result1 = (word_t)(sword_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}


void
isim_processor::LBU_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 1;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  byte_t _result;

  if ( load_flag ) {
	_result = load_data_byte;
  } else {
	enum md_fault_type _fault;
	if ( lsq_data_flag )
	  _result = (byte_t)(word_t)lsq_data;
	else
	  _result = read_byte(access_adr, _fault);
  }

  result1 = (word_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 2;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  shalf_t _result;

  if ( load_flag ) {
	_result = load_data_half;
  } else {
	if ( lsq_data_flag ) {
	  _result = (half_t)(word_t)lsq_data;
	} else {
	  enum md_fault_type _fault;
	  _result = read_half(access_adr, _fault);
	}
  }
	
  result1 = (word_t)(sword_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 2;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  half_t _result;

  if ( load_flag ) {
	_result = load_data_half;
  } else {
	if ( lsq_data_flag ) {
	  _result = (half_t)(word_t)lsq_data;
	} else {
	  enum md_fault_type _fault;
	  _result = read_half(access_adr, _fault);
	}
  }

  result1 = (word_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ( load_flag ) {
	result1 = load_data;
  } else {
	enum md_fault_type _fault;
	if ( lsq_data_flag )
	  result1 = lsq_data;
	else
	  result1 = read_word(access_adr, _fault);
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr2 = (temp + OFS + 4); 
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label,
									   addr_area*2, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ((RT) & 01)
	assert(0);
  if ( load_flag ) {
	result1 = load_data;
	result2 = load_data2;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
	result2 = read_word(access_adr2, _fault);
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
  set_gpr((RT)+1, result2);  
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
  use_lsq_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ( load_flag ) {
	result1 = load_data;	
  } else {
	if ( lsq_data_flag ) {
	  result1 = lsq_data;
	} else {
	  enum md_fault_type _fault;
	  result1 = read_word(access_adr, _fault);
	}
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS);
  addr2 = (temp + OFS + 4); 
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label,
									   addr_area*2, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ((FT) & 01)
	assert(0);

  if ( load_flag ) {
	result1 = load_data;
	result2 = load_data2;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
	result2 = read_word(access_adr2, _fault);
  }

  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FT, result1);
  set_fpr_l((FT)+1, result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWL_addr_impl(instqueue::INSTList_type* inst_st)
{ 
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  md_addr_t _temp_bs;
  _temp_bs = temp;
  addr = WL_BASE(_temp_bs + OFS); 
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWL_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  md_addr_t _temp_bs;
  word_t _lr_temp;
  _temp_bs = temp;

  if ( load_flag ) {
	_lr_temp = load_data;
  } else {
	enum md_fault_type _fault;
	_lr_temp = read_word(access_adr, _fault);
  }
  result1 = ((gpr(RT) & WR_PROT_MASK1(_temp_bs + OFS))
			 | ((_lr_temp << (8 * (WL_SIZE(_temp_bs + OFS)-1)))
				& ~WR_PROT_MASK1(_temp_bs + OFS)));
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWL_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWR_addr_impl(instqueue::INSTList_type* inst_st)
{ 
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  md_addr_t _temp_bs;
  _temp_bs = temp;
  addr = _temp_bs + OFS; 
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  access_adr = WR_BASE(access_adr);
	  t_adr = access_adr%sizeof(word_t);
	  access_adr = access_adr - t_adr;	  
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  word_t _lr_temp;
  if ( load_flag ) {
	_lr_temp = load_data;
  } else {
	enum md_fault_type _fault;
	_lr_temp = read_word(WR_BASE(access_adr), _fault);
  }
  result1 = ((gpr(RT) & ~WL_PROT_MASK2(access_adr))
			 | ((_lr_temp >> (8 * (WR_SIZE(access_adr)-1)))
				& WL_PROT_MASK2(access_adr)));  
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LWR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr_area = 1;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  temp = gpr(RT);
  byte_t _src;
  _src = (byte_t)(word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_byte(_src, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, 0, 0, 0, _src,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << 0 << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << _src << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SH_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr_area = 2;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SH_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SH_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  temp = gpr(RT);
  half_t _src;
  _src = (half_t)(word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_half(_src, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, 0, 0, _src, 0,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << 0 << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << _src << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  temp = gpr(RT);
  word_t _src;
  _src = (word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(_src, access_adr, _fault);
	store_data = _src;
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, _src, 0, 0, 0,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << _src << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr2 = (temp + OFS + 4); 
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
  choose_operand(in4_flag, &result2, RT+1, 4);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp, temp2;
  temp = gpr(RT);
  temp2 = gpr((RT)+1);

  if ((RT) & 01)
	assert(0);
  
  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(temp, access_adr, _fault);
	write_word(temp2, access_adr2, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, temp, temp2, 0, 0,
									 req_label, addr_area*2, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << temp2 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr2 = (temp + OFS + 4); 
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  result1 = 0;
  result2 = 0;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(gpr(0), access_adr, _fault);
	write_word(gpr(0), access_adr2, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, gpr(0), gpr(0), 0, 0,
									 req_label, addr_area*2, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << gpr(0) << " ";
  cout << " Dt2: 0x" << hex << setw(8) << gpr(0) << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " S_impl ";
#endif
  
  exec_stop_flag = false;
  /*
	if ( !in1_flag )
	result1 = fpr_l(FT);
	else
	exec_stop_flag = true;
  */
  choose_operand_l(in1_flag, &result1, FT, 1, &exec_stop_flag);

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp;
  exec_stop_flag = false;
  temp = fpr_l(FT);

  if ( !exec_stop_flag ) {
	if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	  enum md_fault_type _fault;
	  write_word(temp, access_adr, _fault);
	} else {
	  bool flag = false;
	  for ( int i = 0; i < outside_port_num; i++ ) {
		if ( !outgoing_port[i].have_packet()
			 || outgoing_port[i].have_packet()
			 && outgoing_port[i].inst_id() == -1 ) {
		  outgoing_port[i].set_write_detail(access_adr, temp, 0, 0, 0,
									   req_label, addr_area, puid);
		  flag = true;
		  break;
		}
	  }
	  if ( !flag )
		exec_stop_flag = true;
	}
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = (temp + OFS); 
  addr2 = (temp + OFS + 4); 
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  exec_stop_flag = false;
  choose_operand_l(in1_flag, &result1, FT, 1, &exec_stop_flag);
  choose_operand_l(in4_flag, &result2, FT+1, 4, &exec_stop_flag);
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp, temp2;
  exec_stop_flag = false;
  temp = fpr_l(FT);
  temp2 = fpr_l((FT)+1);

  if ( !exec_stop_flag ) {
	enum md_fault_type _fault;
	if ((FT) & 01)
	  assert(0);
	if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	  write_word(temp, access_adr, _fault);
	  write_word(temp2, access_adr2, _fault);
	} else {
	  bool flag = false;
	  for ( int i = 0; i < outside_port_num; i++ ) {
		if ( !outgoing_port[i].have_packet()
			 || outgoing_port[i].have_packet()
			 && outgoing_port[i].inst_id() == -1 ) {
		  outgoing_port[i].set_write_detail(access_adr, temp, temp2, 0, 0,
									   req_label, addr_area*2, puid);
		  flag = true;
		  break;
		}
	  }
	  if ( !flag )
		exec_stop_flag = true;
	}
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << temp2 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWL_addr_impl(instqueue::INSTList_type* inst_st)
{  
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = temp + OFS;  
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWL_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  access_adr = WL_BASE(access_adr);
	  t_adr = access_adr%sizeof(word_t);
	  access_adr = access_adr - t_adr;	  
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWL_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp;
  temp = gpr(RT);
  word_t _lr_temp;
  enum md_fault_type _fault;

  if ( load_flag ) 
	_lr_temp = load_data;
  else 
	_lr_temp = read_word(WL_BASE(access_adr), _fault);
  
  _lr_temp = (((temp >> (8 * (4 - WR_SIZE(access_adr))))
			   & WR_PROT_MASK2(access_adr))
			  | (_lr_temp & ~WR_PROT_MASK2(access_adr)));

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	write_word(_lr_temp, WL_BASE(access_adr), _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(WL_BASE(access_adr), _lr_temp,
										  0, 0, 0, req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << WL_BASE(access_adr) << " ";
  cout << " Dt: 0x" << hex << setw(8) << _lr_temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWR_addr_impl(instqueue::INSTList_type* inst_st)
{ 
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp;
  choose_operand(in2_flag, &temp, BS, 2);

  addr = temp + OFS;  
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
} 

void
isim_processor::SWR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  access_adr = WR_BASE(access_adr);
	  t_adr = access_adr%sizeof(word_t);
	  access_adr = access_adr - t_adr;	  
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SWR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp;
  temp = gpr(RT);
  word_t _lr_temp;
  enum md_fault_type _fault;

  if ( load_flag )
	_lr_temp = load_data;
  else
	_lr_temp = read_word(WR_BASE(access_adr), _fault);

  _lr_temp = (((temp << (8 * (4 - WL_SIZE(access_adr))))
			   & ~WL_PROT_MASK1(access_adr))
			  | (_lr_temp & WL_PROT_MASK1(access_adr)));

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	write_word(_lr_temp, WR_BASE(access_adr), _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(WR_BASE(access_adr),
										  _lr_temp, 0, 0, 0,
										  req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << WR_BASE(access_adr) << " ";
  cout << " Dt: 0x" << hex << setw(8) << _lr_temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 1;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  sbyte_t _result;

  if ( load_flag ) {
	_result = load_data_byte;
  } else {
	enum md_fault_type _fault;
	_result = read_byte(access_adr, _fault);
  }
  result1 = (word_t)(sword_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LB_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 1;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  byte_t _result;

  if ( load_flag ) {
	_result = load_data_byte;
  } else {
	enum md_fault_type _fault;
	_result = read_byte(access_adr, _fault);
  }
  result1 = (word_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LBU_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);    
  addr_area = 2;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  shalf_t _result;

  if ( load_flag ) {
	_result = load_data_half;
  } else {
	enum md_fault_type _fault;
	_result = read_half(access_adr, _fault);
  }

  result1 = (word_t)(sword_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LH_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 2;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  half_t _result;

  if ( load_flag ) {
	_result = load_data_half;
  } else {
	enum md_fault_type _fault;
	_result = read_half(access_adr, _fault);
  }
  result1 = (word_t)_result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LHU_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  if ( load_flag ) {
	result1 = load_data;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);    
  addr2 = (temp2 + temp3 + 4);    
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label,
									   addr_area*2, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  if ((RT) & 01)
	assert(0);
  if ( load_flag ) {
	result1 = load_data;
	result2 = load_data2;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
	result2 = read_word(access_adr2, _fault);
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DLW_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RT, result1);
  set_gpr((RT)+1, result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  word_t _result;
  enum md_fault_type _fault;

  if ( load_flag )
	_result = load_data;
  else
	_result = read_word(access_adr, _fault);

  result1 = _result;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_fpr_l(FT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr2 = (temp2 + temp3 + 4);    
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_RR_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label,
									   addr_area*2, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  if ((FT) & 01)
	assert(0);

  if ( load_flag ) {
	result1 = load_data;
	result2 = load_data2;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
	result2 = read_word(access_adr2, _fault);
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_D_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_fpr_l(FT, result1);
  set_fpr_l((FT)+1, result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 1;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SB_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp;
  temp = gpr(RT);
  byte_t _src;
  _src = (byte_t)(word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_byte(_src, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, 0, 0, 0, _src,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;	
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << 0 << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << _src << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SH_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 2;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SH_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}
void
isim_processor::SH_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  sword_t temp;
  temp = gpr(RT);
  half_t _src;
  _src = (half_t)(word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_half(_src, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, 0, 0, _src, 0,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << 0 << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << _src << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  temp = gpr(RT);
  word_t _src;
  _src = (word_t)temp;

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(_src, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, _src, 0, 0, 0,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << _src << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr2 = (temp2 + temp3 + 4);
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
  choose_operand(in4_flag, &result2, RT+1, 4);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSW_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp, temp2;
  temp = gpr(RT);
  temp2 = gpr((RT)+1);

  if ((RT) & 01)
	assert(0);

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(temp, access_adr, _fault);
	write_word(temp2, access_adr2, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, temp, temp2, 0, 0,
									 req_label, addr_area*2, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << temp2 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);    
  addr2 = (temp2 + temp3 + 4);    
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  result1 = 0;
  result2 = 0;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DSZ_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(gpr(0), access_adr, _fault);
	write_word(gpr(0), access_adr2, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, gpr(0), gpr(0), 0, 0,
									 req_label, addr_area*2, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;	
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << gpr(0) << " ";
  cout << " Dt2: 0x" << hex << setw(8) << gpr(0) << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  exec_stop_flag = false;
  /*
	if ( !in1_flag )
	result1 = fpr_l(FT);
	else
	exec_stop_flag = true;
  */
  choose_operand_l(in1_flag, &result1, FT, 1, &exec_stop_flag);
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  exec_stop_flag = false;
  temp = fpr_l(FT);

  if ( !exec_stop_flag ) {
	if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	  enum md_fault_type _fault;
	  write_word(temp, access_adr, _fault);
	} else {
	  bool flag = false;
	  for ( int i = 0; i < outside_port_num; i++ ) {
		if ( !outgoing_port[i].have_packet()
			 || outgoing_port[i].have_packet()
			 && outgoing_port[i].inst_id() == -1 ) {
		  outgoing_port[i].set_write_detail(access_adr, temp, 0, 0, 0,
									   req_label, addr_area, puid);
		  flag = true;
		  break;
		}
	  }
	  if ( !flag )
		exec_stop_flag = true;
	}
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_RR_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3);    
  addr2 = (temp2 + temp3 + 4);    
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_RR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  exec_stop_flag = false;
  /*
	if ( !in1_flag )
	result1 = fpr_l(FT);
	else
	exec_stop_flag = true;
  */
  choose_operand_l(in1_flag, &result1, FT, 1, &exec_stop_flag);
  /*
	if ( !in4_flag )
	result2 = fpr_l((FT)+1);
	else
	exec_stop_flag = true;
  */
  choose_operand_l(in4_flag, &result2, FT+1, 4, &exec_stop_flag);
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_D_RR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp ,temp2;
  exec_stop_flag = false;
  temp = fpr_l(FT);
  temp2 = fpr_l((FT)+1);

  if ( !exec_stop_flag ) {
	if ((FT) & 01)
	  assert(0);	
	if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	  enum md_fault_type _fault;	
	  write_word(temp, access_adr, _fault);
	  write_word(temp2, access_adr2, _fault);
	} else {
	  bool flag = false;
	  for ( int i = 0; i < outside_port_num; i++ ) {
		if ( !outgoing_port[i].have_packet()
			 || outgoing_port[i].have_packet()
			 && outgoing_port[i].inst_id() == -1 ) {
		  outgoing_port[i].set_write_detail(access_adr, temp, temp2, 0, 0,
									   req_label, addr_area*2, puid);
		  flag = true;
		  break;
		}
	  }
	  if ( !flag )
		exec_stop_flag = true;
	}
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << temp2 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_R2_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3 + 4);    
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_R2_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_R2_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ( load_flag ) {
	result1 = load_data;
  } else {
	enum md_fault_type _fault;
	result1 = read_word(access_adr, _fault);
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::L_S_RR_R2_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_R2_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3 + 4);    
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_R2_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  exec_stop_flag = false;
	  
  /*
	if ( !in1_flag )
	result1 = fpr_l(FT);
	else
	exec_stop_flag = true;
  */
  choose_operand_l(in1_flag, &result1, FT, 1, &exec_stop_flag);
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::S_S_RR_R2_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  exec_stop_flag = false;
  temp = fpr_l(FT);

  if ( !exec_stop_flag ) {
	if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	  enum md_fault_type _fault;
	  write_word(temp, access_adr, _fault);
	} else {
	  bool flag = false;
	  for ( int i = 0; i < outside_port_num; i++ ) {
		if ( !outgoing_port[i].have_packet()
			 || outgoing_port[i].have_packet()
			 && outgoing_port[i].inst_id() == -1 ) {
		  outgoing_port[i].set_write_detail(access_adr, temp, 0, 0, 0,
									   req_label, addr_area, puid);
		  flag = true;
		  break;
		}
	  }
	  if ( !flag )
		exec_stop_flag = true;
	}
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_R2_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3 + 4);    
  addr_area = 4;
  if ( addr > MACHINE_ADDRESS_BOTTOM )
	load_flag = true;

#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_R2_set_req_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " set_req_impl ";
#endif
  bool flag = false;
  for ( int i = 0; i < outside_port_num; i++ ) {
	if ( !outgoing_port[i].have_packet()
		 || outgoing_port[i].have_packet()
		 && outgoing_port[i].inst_id() == -1 ) {
	  outgoing_port[i].set_read_detail(access_adr, req_label, addr_area, puid);
	  flag = true;
	  break;
	}
  }
  if ( !flag )
	exec_stop_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_R2_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  if ( load_flag ) {
	result1 = load_data;
  } else {
	enum md_fault_type _fault;	
	result1 = read_word(access_adr, _fault);
  }

  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LW_RR_R2_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_R2_addr_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " addr_impl ";
#endif
  sword_t temp2, temp3;
  choose_operand(in2_flag, &temp2, BS, 2);
  choose_operand(in3_flag, &temp3, RD, 3);

  addr = (temp2 + temp3 + 4);    
  addr_area = 4;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: " << hex << setw(8) << addr << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_R2_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  choose_operand(in1_flag, &result1, RT, 1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SW_RR_R2_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  sword_t temp;
  temp = gpr(RT);

  if ( access_adr <= MACHINE_ADDRESS_BOTTOM ) {
	enum md_fault_type _fault;
	write_word(temp, access_adr, _fault);
  } else {
	bool flag = false;
	for ( int i = 0; i < outside_port_num; i++ ) {
	  if ( !outgoing_port[i].have_packet()
		   || outgoing_port[i].have_packet()
		   && outgoing_port[i].inst_id() == -1 ) {
		outgoing_port[i].set_write_detail(access_adr, temp, 0, 0, 0,
									 req_label, addr_area, puid);
		flag = true;
		break;
	  }
	}
	if ( !flag )
	  exec_stop_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << " ADR: 0x" << hex << setw(8) << access_adr << " ";
  cout << " Dt: 0x" << hex << setw(8) << temp << " ";
  cout << " Dt2: 0x" << hex << setw(8) << 0 << " ";
  cout << " Hlf: 0x" << hex << setw(4) << 0 << " ";
  cout << " Byt: 0x" << hex << setw(2) << 0 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADD_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  if (OVER(temp, temp2)) assert(0);
  result1 = temp + temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADD_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  if (OVER(temp, IMM)) assert(0);

  result1 = temp + IMM;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);
  result1 = temp + temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDIU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  result1 = temp + IMM;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ADDIU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SUB_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  if (UNDER(temp, temp2)) assert(0);
  result1 = temp - temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SUB_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SUBU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  result1 = temp - temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SUBU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}


void
isim_processor::MULT_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  bool_t _sign1, _sign2;
  int _i;
  sword_t _op1, _op2;

  _sign1 = _sign2 = FALSE;
  result1 = 0;
  result2 = 0;
  _op1 = temp2;
  _op2 = temp;

  if (_op1 & 020000000000) {
	_sign1 = TRUE;
	_op1 = (~_op1) + 1;
  }
  if (_op2 & 020000000000) {
	_sign2 = TRUE;
	_op2 = (~_op2) + 1;
  }
  if (_op1 & 020000000000)
	result2 = _op2;
	
  for (_i = 0; _i < 31; _i++) {
	result1 = result1 << 1;
	result1 = result1 + extractl(result2, 31, 1);
	result2 = result2 << 1;
	if ((extractl(_op1, 30 - _i, 1)) == 1) {
	  if (((unsigned)037777777777 - (unsigned)result2) < (unsigned)_op2) {
		result1 = result1 + 1;
	  }
	  result2 = result2 + _op2;
	}
  }	
	
  if (_sign1 ^ _sign2) {
	result2 = ~result2;
	result1 = ~result1;
	if ((unsigned)result2 == 037777777777) {
	  result1 = result1 + 1;
	}
	result2 = result2 + 1;
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MULT_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_hi(result1);
  set_lo(result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}


void
isim_processor::MULTU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  int _i;
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  result1 = 0;
  result2 = 0;
  if (temp2 & 020000000000)
	result2 = temp;
	
  for (_i = 0; _i < 31; _i++) {
	result1 = result1 << 1;
	result1 = result1 + extractl(result2, 31, 1);
	result2 = result2 << 1;
	if ((extractl(temp2, 30 - _i, 1)) == 1) {
	  if (((unsigned)037777777777 - (unsigned)result2)
		  < (unsigned)temp) {
		result1 = result1 + 1;
	  }
	  result2 = result2 + temp;
	}
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MULTU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_hi(result1);
  set_lo(result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DIV_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  if (temp == 0)
	declare_fault(md_fault_div0);
	
  if ( temp == 0 ) {
	result1 = 0;
	result2 = 0;
  } else {
	result1 = temp2 % temp;
	result2 = temp2 / temp;
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DIV_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_hi(result1);
  set_lo(result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DIVU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  if (temp == 0) {
	declare_fault(md_fault_div0);
	result1 = 0;
	result2 = 0;
  } else {
	result1 = ((unsigned)temp2) % ((unsigned)temp);
	result2 = ((unsigned)temp2) / ((unsigned)temp);
  }
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DIVU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_hi(result1);
  set_lo(result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFHI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand_hi(in1_flag, &temp, 1);

  result1 = temp;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFHI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTHI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  result1 = temp;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTHI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_hi(result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFLO_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand_lo(in1_flag, &temp, 1);

  result1 = temp;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFLO_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTLO_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  result1 = temp;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTLO_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_lo(result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::AND__impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " _impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  result1 = temp & temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::AND__reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " _reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ANDI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  result1 = temp & UIMM;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ANDI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::OR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  result1 = (temp | temp2);
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::OR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ORI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  result1 = (temp | UIMM);
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::ORI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::XOR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  result1 = temp ^ temp2;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::XOR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::XORI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);
  result1 = temp ^ UIMM;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::XORI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::NOR_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  result1 = ~(temp | temp2);
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::NOR_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RT, 1);

  result1 = temp << SHAMT;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLL_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLLV_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  result1 = temp << (temp2 & 037);
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLLV_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SRL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RT, 1);

  if ((SHAMT) != 0) {
	word_t _rd;
	
	_rd = (((unsigned)temp) >> 1) & ~0x80000000;
	result1 = (_rd >> ((SHAMT) - 1));
  } else {
	result1 = temp;
  }	
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SRL_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SRLV_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  int _shamt = temp2 & 037;	
  if (_shamt != 0) {
	word_t _rd;
	
	_rd = (((unsigned)temp) >> 1) & ~0x80000000;
	result1 = (_rd >> (_shamt - 1));
  } else {
	result1 = temp;
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SRLV_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SRA_impl(instqueue::INSTList_type* inst_st)
{             
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RT, 1);

  unsigned int _i;                         
  if (temp & 0x80000000) {
	result1 = temp;                                         
	for (_i = 0; _i < SHAMT; _i++) {
	  result1 = (result1 >> 1) | 0x80000000;                     
	}                                                               
  } else {                                                          
	result1 = temp >> SHAMT;                                        
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif                                                          
}

void
isim_processor::SRA_reg_impl(instqueue::INSTList_type* inst_st)
{             
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);                                        
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif                                                          
}

void
isim_processor::SRAV_impl(instqueue::INSTList_type* inst_st)
{             
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in2_flag, &temp2, RS, 2);

  int _i;                                                               
  int _shamt = temp2 & 037;

  if (temp & 0x80000000) {
	result1 = temp;                                         
	for (_i = 0; _i < _shamt; _i++) {
	  result1 = (result1 >> 1) | 0x80000000;
	}                                                               
  } else {
	result1 = temp >> _shamt;                                       
  }
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif                                                          
}

void
isim_processor::SRAV_reg_impl(instqueue::INSTList_type* inst_st)
{             
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif                                                          
}

void
isim_processor::SLT_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  if (temp < temp2)
	result1 = 1;
  else
	result1 = 0;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLT_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);
  
  if (temp < IMM)
	result1 = 1;
  else	
	result1 = 0;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RS, 1);
  choose_operand(in2_flag, &temp2, RT, 2);

  if (((unsigned)temp) < ((unsigned)temp2))
	result1 = 1;
  else
	result1 = 0;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTIU_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RS, 1);

  if ((unsigned)temp < (unsigned)IMM)
	result1 = 1;
  else
	result1 = 0;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SLTIU_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FADD_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	result_ff = temp + temp2;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FADD_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FADD_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_fd = temp + temp2;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FADD_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSUB_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_ff = temp - temp2;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSUB_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSUB_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_fd = temp - temp2;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSUB_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMUL_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;

  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_ff = temp * temp2;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMUL_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMUL_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_fd = temp * temp2;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMUL_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FDIV_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	if ( temp2 == 0 ) {
	  result_ff = 0;
	} else {
	  result_ff = temp / temp2;
	}
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FDIV_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FDIV_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	if ( temp2 == 0 )
	  result_fd = 0;
	else
	  result_fd = temp / temp2;
	
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FDIV_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FABS_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_ff = (sfloat_t)fabs((dfloat_t)temp);
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FABS_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FABS_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_fd = fabs(temp);
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FABS_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMOV_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_ff = temp;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMOV_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMOV_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_fd = temp;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FMOV_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FNEG_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_ff = -temp;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FNEG_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FNEG_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  
  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_fd = -temp;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FNEG_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_S_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_ff = (float)temp;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_S_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}



void
isim_processor::CVT_S_W_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  exec_stop_flag = false;
  choose_operand_l(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_ff = (float)temp;
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_S_W_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_D_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  
  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_fd = (dfloat_t)temp;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_D_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_D_W_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  exec_stop_flag = false;
  choose_operand_l(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result_fd = (dfloat_t)temp;
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_D_W_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_W_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  
  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result1 = (sword_t)temp;
	result1_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_W_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_W_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);
	
	result1 = (sword_t)temp;
	result1_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::CVT_W_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FD, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_EQ_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp == temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_EQ_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_EQ_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp == temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_EQ_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LT_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp < temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LT_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LT_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp < temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LT_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LE_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_ff(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp <= temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LE_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LE_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_fd(in2_flag, &temp2, FT, 2, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FS) & 01) || ((FT) & 01))
	  assert(0);
	
	result_i = (temp <= temp2);
	result_i_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::C_LE_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " LE_D_reg_impl ";
#endif
  set_fcc(result_i);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSQRT_S_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sfloat_t temp;
  exec_stop_flag = false;
  choose_operand_ff(in1_flag, &temp, FS, 1, &exec_stop_flag);
  
  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);	

	result_ff = (sfloat_t)sqrt((dfloat_t)temp);
	result_ff_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSQRT_S_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " S_reg_impl ";
#endif
  set_fpr_f(FD, result_ff);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSQRT_D_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  dfloat_t temp;
  exec_stop_flag = false;
  choose_operand_fd(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((FD) & 01) || ((FS) & 01))
	  assert(0);	
	
	result_fd = sqrt(temp);
	result_fd_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::FSQRT_D_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_d(FD, result_fd);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::SYSCALL_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  syscall(inst);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::BREAK_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  declare_fault(md_fault_break);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LUI_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  result1 = UIMM << 16;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::LUI_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFC1_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  exec_stop_flag = false;
  choose_operand_l(in1_flag, &temp, FS, 1, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	result1 = temp;
	result1_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MFC1_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DMFC1_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  exec_stop_flag = false;
  choose_operand_l(in1_flag, &temp, FS, 1, &exec_stop_flag);
  choose_operand_l(in4_flag, &temp2, FS+1, 4, &exec_stop_flag);

  if ( !exec_stop_flag ) {
	if (((RT) & 01) || ((FS) & 01))
	  assert(0);
	
	result1 = temp;
	result2 = temp2;
	result1_flag = true;
	result2_flag = true;
  }
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << "EXEC_STOP: " << exec_stop_flag << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DMFC1_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_gpr(RT, result1);
  set_gpr((RT)+1, result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTC1_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp;
  choose_operand(in1_flag, &temp, RT, 1);

  result1 = temp;
  result1_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::MTC1_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FS, result1);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DMTC1_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " impl ";
#endif
  sword_t temp, temp2;
  choose_operand(in1_flag, &temp, RT, 1);
  choose_operand(in4_flag, &temp2, RT+1, 4);

  if (((FS) & 01) || ((RT) & 01))
	assert(0);
  
  result1 = temp;
  result2 = temp2;
  result1_flag = true;
  result2_flag = true;
#ifdef DEBUG_ISIM_PROCESSOR
  cout.fill('0');
  cout << "Rslt1: 0x" << hex << setw(8) << result1 << " ";
  cout.fill('0');
  cout << "Rslt2: 0x" << hex << setw(8) << result2 << " ";
  cout << endl;
  cout.flags(flags);
#endif
}

void
isim_processor::DMTC1_reg_impl(instqueue::INSTList_type* inst_st)
{
#ifdef DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  debug_output_pc(inst_st);
  cout << " reg_impl ";
#endif
  set_fpr_l(FS, result1);
  set_fpr_l((FS)+1, result2);
#ifdef DEBUG_ISIM_PROCESSOR
  cout << endl;
  cout.flags(flags);
#endif
}
