#include "exec_buffer.h"

exec_buffer::exec_buffer()
{
  ListHead = ListTail = NULL;
}


//$BL?Na$NEjF~(B
void 
exec_buffer::insertlist(instqueue::INSTList_type* inst)
{
  struct EXList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct EXList*)malloc(sizeof(struct EXList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	ListHead->inst = inst;
	ListHead->check_time = 0;
	ListHead->next = NULL;
  } else {
	temp = (struct EXList*)malloc(sizeof(struct EXList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	temp->inst = inst;
	temp->check_time = 0;
	
	struct EXList *Listptr;
	Listptr = ListHead;	

	while(1){
	  if ( Listptr->inst->seq > inst->seq ) {
		temp->next = ListHead;
		ListHead = temp;
		break;
	  }
	  if ( Listptr->next != NULL
		   && ( Listptr->next->inst->seq > inst->seq )) {
		temp->next = Listptr->next;
		Listptr->next = temp;
		break;
	  }
	  if (Listptr->next == NULL) {
		temp->next = NULL;
		ListTail->next = temp;
		ListTail = temp;
		break;
	  }
	  Listptr = Listptr->next;
	}
  }
}


//$BL?Na$N:o=|(B
void
exec_buffer::deletelist(INST_SEQ_TYPE seq0)
{
  struct EXList *Listptr;
  struct EXList *temp;
  Listptr = ListHead;

  if ( Listptr == NULL )
	return;

  while(1){
	if (Listptr == ListHead && Listptr->inst->seq == seq0){
	  ListHead = Listptr->next;
	  if (Listptr == ListTail) {
		ListTail = NULL;
	  }
	  free(Listptr);
	  break;
	}
	if (Listptr->next != NULL && Listptr->next->inst->seq == seq0) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  free(temp);
	  break;
	}
	if (Listptr->next == NULL)
	  break;
	Listptr = Listptr->next;
  }
}

//$BL?Na$N:o=|(B
void
exec_buffer::deletelist_after_this(INST_SEQ_TYPE seq0)
{
  struct EXList *Listptr;
  struct EXList *temp;
  Listptr = ListHead;
  bool flag = false;

  while( Listptr != NULL ) {
	if ( Listptr == ListHead && Listptr->inst->seq > seq0 ) {
	  ListHead = Listptr->next;
	  if ( Listptr == ListTail ) {
		ListTail = NULL;
		free(Listptr);
		break;
	  } else {
		temp = Listptr;
		Listptr = Listptr->next;
		free(temp);
		flag = true;
	  }
	} else if ( Listptr->next != NULL
				&& Listptr->next->inst->seq > seq0 ) {
	  if ( Listptr->next == ListTail ) {
		ListTail = Listptr;
		temp = Listptr->next;
		Listptr->next = NULL;
		free(temp);
		break;
	  } else {
		temp = Listptr->next;
		Listptr->next = temp->next;
		free(temp);
	  }
	} else {
	  Listptr = Listptr->next;
	}
  }
}

//$BL?Na$rJV$9(B
instqueue::INSTList_type*
exec_buffer::ready_label(int now)
{
  struct EXList *Listptr;
  Listptr = ListHead;

  while(Listptr != NULL){
	if (Listptr->check_time < now) {
	  Listptr->check_time = now;
	  return Listptr->inst;
	}
	Listptr = Listptr->next;
  }
  return NULL;
}

void
exec_buffer::printlist(void)
{
  struct EXList *Listptr;
  Listptr = ListHead;
  if ( ListHead == NULL ) {
	printf("No List\n");
  }
  while (Listptr != NULL){
	printf ("seq=%d\n", Listptr->inst->seq);
	Listptr = Listptr->next;
  }
  printf("\n");
}
