/*
 * <<< vision_test.h >>>
 *
 * --- Test program header for vision
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef TEST_PROGRAM

#include "pico_typedef.h"

#define TEST_PROGRAM 1

enum simulation_command{
	F = 1,
	FORWARD = 1,
	MEM = 2,
	PC = 3,
	REG = 4,
	REGALL = 5,
	SYSTEM_STACK = 6,
	H = 6,
	ASM = 7,
	DISPLAY = 8,
	T = 9,
	SET = 10,
	SET_OPCODE,
	SET_MEMORY,
	SET_REGISTER,
	CAPTURE,
	INPUT,
	SET_PC,
	EXIT,
	QUIT,
	SP,
	TB,
	BB,
};

typedef pico_word D;

template <class D>
void left_right_connect_function(D& a, D& b);

template <class D>
void up_down_connect_function(D& a, D& b);

template <class D>
void input_output_connect_function(D& a);

int command_analysis_function(std::string& command, std::string& opcode,
									int& address, int& value);
			
int string_to_num10(std::string value);
int string_to_num16(std::string value);
void Send_Data_2_Input(vision_port& Port, packet *pkt2);
#endif
