/*
 *
 * VideoDecoder Class (Header) vdec.h
 * ported from ImageCaptureDevice Class (Header) icd.h in SPARCLE library
 * Ported Date : Feb. 17, 2002
 * Updated Date: Mar.  2, 2002
 * Copyright (C) 2000-2002 Yoshiaki Ajioka, Ecchandes Inc.
 *
 */

#if !defined(___CLASS_VDEC)
  #define ___CLASS_VDEC

#include <fstream>
#include <iostream>
#include <iomanip>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#if defined(__V4L__)
#include <linux/types.h>
#include <linux/videodev.h>
#endif
#define INPUTFILE "input.ppm"
#define CAPTUREFILE "capture.ppm"

#if !defined(BUFSIZE)
#define BUFSIZE 256
#endif

class VideoDecoder {

public:
    enum PALETTE {RGB555, RGB565, RGB888};
    enum CHANNEL { TELEVISION, COMPOSITE1, SVIDEO };
    enum NORM { PAL, NTSC, SECAM };

private:
    int capwidth;
    int capheight;
    int capbands;
    int capUnitSize;
    int posX;
    int posY;
    int fd;
    int palette;
    int channel;
    int norm;
    int frameNo;
    unsigned char* map;
#if defined(__V4L__)
    struct video_capability vd;
    struct video_channel vc[10];
    struct video_picture vp;
    struct video_mbuf vm;
    struct video_mmap vmm;
#endif

public:
    VideoDecoder(void);
    VideoDecoder(unsigned short widthnum,
		 unsigned short heightnum,
		 unsigned short bandnum = 1,
		 unsigned short unitsize = 1,
		 int palettenum = RGB888,
		 int channelnum = COMPOSITE1,
		 int normnum = NTSC);

    ~VideoDecoder(void);

    void initialize(void);
    void flush(void);
    void flush(int loop);
    void capture(void);
    unsigned int get(int w, int h, int b);
    void next(void);
};

#if 0
std::ostream& operator<<(std::ostream& s,
						 const VideoDecoder& x);
#endif

#endif
