/*
 *
 * VideoDecoder Class (Body) vdec.cc
 * ported from ImageCaptureDevice Class (Body) icd.cc in SPARCLE library
 * Ported Date : Feb. 17, 2002
 * Updated Date: Mar. 29, 2002
 * Copyright (C) 2000-2002 Yoshiaki Ajioka, Ecchandes Inc.
 *
 */

#include "vdec.h"

using namespace std;

void VideoDecoder::initialize(void)
{
#if defined(__V4L__)
    int n;

    // open Video4Linux device
    if((fd = open("/dev/video0", O_RDWR)) < 0 ) {
	cerr << "open";
	exit (1);
    }

    // get parameters of Video4Linux device
    if(ioctl(fd, VIDIOCGCAP, &vd) < 0 ) {
	cerr << "ioctl(VIDIOCGCAP)";
	exit (1);
    }
    cerr << "vd.name: \"" << vd.name << "\"\n";
    cerr << "vd.type=0x" << setw(8) << setfill('0') << hex << vd.type << dec;
    if (vd.type & VID_TYPE_CAPTURE) cerr << " CAPTURE";
    if (vd.type & VID_TYPE_TUNER) cerr << " TUNER";
    if (vd.type & VID_TYPE_TELETEXT) cerr << " TELETEXT";
    if (vd.type & VID_TYPE_OVERLAY) cerr << " OVERLAY";
    if (vd.type & VID_TYPE_CHROMAKEY) cerr << " CHROMAKEY";
    if (vd.type & VID_TYPE_CLIPPING) cerr << " CLIPPING";
    if (vd.type & VID_TYPE_FRAMERAM) cerr << " FRAMERAM";
    if (vd.type & VID_TYPE_SCALES) cerr << " SCALES";
    if (vd.type & VID_TYPE_MONOCHROME) cerr << " MONOCHROME";
    if (vd.type & VID_TYPE_SUBCAPTURE) cerr << " SUBCAPTURE";
    cerr << '\n';
    cerr << "vd.channels=" << vd.channels << '\n';
    cerr << "vd.audios=" << vd.audios << '\n';
    cerr << "vd.maxwidth=" << vd.maxwidth << '\n';
    cerr << "vd.maxheight=" << vd.maxheight << '\n';
    cerr << "vd.minwidth=" << vd.minwidth << '\n';
    cerr << "vd.minheight=" << vd.minheight << '\n';
    cerr << '\n';

    // check capture size
    if (capwidth > vd.maxwidth) {
	cerr << "capwidth > capture maxwidth\n";
	exit (1);
    }
    if (capwidth < vd.minwidth) {
	cerr << "capwidth < captuer minwidth\n";
	exit (1);
    }
    if (capheight > vd.maxheight) {
	cerr << "capheight > capture maxheight\n";
	exit (1);
    }
    if (capheight < vd.minheight) {
	cerr << "capheight < captuer minheight";
	exit (1);
    }

    // get parameters of each channel
    for (int n = 0; n < vd.channels; n++) {
	vc[n].channel=n;
	if (ioctl(fd, VIDIOCGCHAN, &vc[n]) < 0) {
	    cerr << "ioctl(VIDIOCGCHAN)";
	    exit (1);
	}
	cerr << "vc[" << n << "].channel=" << vc[n].channel << '\n';
	cerr << "vc[" << n << "].name=\"" << vc[n].name << "\"\n";
	cerr << "vc[" << n << "].tuners=" << vc[n].tuners << '\n';
	cerr << "vc[" << n << "].flags=0x" << setw(8) << setfill('0') << hex << vc[n].flags << dec;
	if (vc[n].flags & VIDEO_VC_TUNER) cerr << " TUNER";
	if (vc[n].flags & VIDEO_VC_AUDIO) cerr << " AUDIO";
	cerr << '\n';
	cerr << "vc[" << n << "].type=0x" << setw(8) << setfill('0') << hex << vc[n].type << dec;
	if (vc[n].type & VIDEO_TYPE_TV) cerr << " TV";
	if (vc[n].type & VIDEO_TYPE_CAMERA) cerr << " CAMERA";
	cerr << '\n';
	cerr << "vc[" << n << "].norm=" << vc[n].norm << '\n';
	cerr << '\n';
    }

    // select channel
    vc[channel].norm = norm;
    if (ioctl(fd, VIDIOCSCHAN, &vc[channel]) < 0) {
	cerr << "ioctl(VIDIOCSCHAN)";
	exit (1);
    }

    // set parameters (0-65535)
    vp.brightness=32767;
    vp.hue=32767;
    vp.colour=32767;
    vp.contrast=32767;
    vp.whiteness=32767;
    vp.depth = 24;		    // color depth
    vp.palette=VIDEO_PALETTE_RGB24; // RGB24
    if (ioctl(fd, VIDIOCSPICT, &vp)) {
	cerr << "ioctl(VIDIOCSPICT)";
	exit (1);
    }

    // get mmap information
    if (ioctl(fd, VIDIOCGMBUF, &vm) < 0) {
	cerr << "ioctl(VIDIOCGMBUF)";
	exit (1);
    }
    cerr << "vm.size=0x" << setw(8) << setfill('0') << hex << vm.size << dec << '\n';
    cerr << "vm.frames=0x" << setw(8) << setfill('0') << hex << vm.frames << '\n' << dec;
    for(int n = 0; n < vm.frames; n++) {
	cerr << "vm.offsets[" << n << "]=0x" << setw(8) << setfill('0') << vm.offsets[n] << '\n';
    }
    cerr << '\n';

    // mmap
    if ((map = (unsigned char*)mmap(0, vm.size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0)) == (unsigned char*)-1) {
	cerr << "mmap";
	exit (1);
    }
#else
    char buf[BUFSIZE];
    int w, h;
    ifstream fin(INPUTFILE, ios::in|ios::binary);

    if (!fin) {
        cerr << "fopen";
        exit (1);
    }
    fin >> buf >> w >> h;
    if (strcmp(buf, "P6")) {
        cerr << "file is not ppm";
        exit (1);
    }
    if ((capwidth != w) || (capheight != h)) {
        cerr << "file size is not correct";
        exit (1);
    }

    // mmap
    map = new unsigned char[capwidth * capheight * 3];
    if (!map) {
	cerr << "new array of unsigned char";
	exit (1);
    }

    fin.close();
#endif
}


VideoDecoder::VideoDecoder(void)
{
    capwidth = 640;
    capheight = 480;
    capbands = 1;
    capUnitSize = 1;
    posX = posY = 0;
    palette = RGB888;
    channel = SVIDEO;
    norm = NTSC;
    frameNo = 0;

    initialize();
}

VideoDecoder::VideoDecoder(
    unsigned short widthnum,
    unsigned short heightnum,
    unsigned short bandnum,
    unsigned short unitsize,
    int palettenum,
    int channelnum,
    int normnum)
{
    capwidth = widthnum * unitsize;
    capheight = heightnum * unitsize;
    capbands = bandnum;
    capUnitSize = unitsize;
    posX = posY = 0;
    palette = palettenum;
    channel = channelnum;
    norm = normnum;
    frameNo = 0;

    initialize();
}

VideoDecoder::~VideoDecoder(void)
{
#if defined(__V4L__)
    close(fd);
#endif
}

void VideoDecoder::flush(void)
{
    posX = posY = 0;

#if defined(__V4L__)
    // start captuering next frame
    frameNo++;
    frameNo %= vm.frames;
    vmm.frame = frameNo;
    vmm.width = capwidth;
    vmm.height = capheight;
    vmm.format = vp.palette;
    if (ioctl(fd, VIDIOCMCAPTURE, &vmm) < 0) {
	cerr << "ioctl(VIDIOCMCAPTURE)";
	exit (1);
    }
#endif
}


void VideoDecoder::flush(int loop)
{
    for (int l = 0; l < loop; l++) {
	flush();
    }
}


void VideoDecoder::capture(void)
{
    flush();
#if defined(__V4L__)
    // wait frame #frameNo
    if (ioctl(fd, VIDIOCSYNC, &frameNo) < 0) {
	cerr << "ioctl(VIDIOCSYNC)";
	exit (1);
    }

    unsigned char* p = map + vm.offsets[frameNo];
    int i, b;
    ofstream fout;

    fout.open(CAPTUREFILE);
    if (!fout) {
        cerr << "fopen";
        exit (1);
    }

    fout << "P6 " << capwidth << " " << capheight << " 255" << endl;
    for (i = 0; i < capwidth * capheight; p += 3, i++) {
        for (b = 2; b >= 0; b--) {
	    fout << p[b];
	}
    }

    fout.close();
#else
    unsigned char* p = map;
    char buf[BUFSIZE];
    int w, h, b;
    unsigned char c;
    std::ifstream fin(INPUTFILE, ios::binary);

    if (!fin) {
        cerr << "fopen";
        exit (1);
    }
    fin >> buf >> w >> h >> b;
	c = fin.get(); // for getting NEWLINE

    if (strcmp(buf, "P6")) {
        cerr << "file is not ppm";
        exit (1);
    }
    if ((capwidth != w) || (capheight != h)) {
        cerr << "file size is not correct";
        exit (1);
    }

#if 0
    for (w = 0; w < capwidth * capheight; p += 3, w++) {
        for (b = 2; b >= 0; b--) {
	    fin.get(c);
	    p[b] = c;
	}
    }
#else
	fin.read((char*)p, capwidth * capheight * 3);
    for (w = 0; w < capwidth * capheight; p += 3, w++) {
        unsigned char tmp;

	tmp = p[0];
	p[2] = p[0];
	p[0] = tmp;
    }
#endif
#if 0
    p = map;
    for (h = 0; h < capheight; h++) {
        for (w = 0; w < capwidth; p += 3, w++) {
	    cerr << setw(3) << (unsigned int)*p;
	}
	cerr << endl;
    }
#endif
    fin.close();
#endif
}


unsigned int VideoDecoder::get(int w, int h, int b)
{
#if defined(__V4L__)
    unsigned char* p = map + vm.offsets[frameNo];
#else
    unsigned char* p = map;
#endif
    unsigned int val = 0;
    int i;

    p += ((h * capUnitSize + posY) * capwidth + (w * capUnitSize + posX)) * 3
      + b;

#if 0
    cerr << "(w, h, b) = (" << w << "," << h << "," << b << ")" << endl;
    cerr << "(posX, posY) = (" << posX << "," << posY << ")" << endl;
    cerr << "capwidth = " << capwidth << endl;
    cerr << "capbands = " << capbands << endl;
    cerr << "pixel = " << (unsigned int)*p << endl;
#endif

    switch (palette){
    case RGB555:
        for (i = 0; i < 3; i++) {
	  //	  cerr << "pixel = " << hex << (unsigned int)((*p & 0xf8) >> 3) << endl;
	  val = (val << 5) + ((*p++ & 0xf8) >> 3);
	}
	break;
    case RGB565:
        val = ((*p++ & 0xf8) >> 3);
        val = (val << 5) + ((*p++ & 0xfc) >> 2);
        val = (val << 6) + ((*p++ & 0xf8) >> 3);
	break;
    case RGB888:
        for (i = 0; i < 3; i++) {
	  val = (val << 8) + *p++;
	}
	break;
    default:
        for (i = 0; i < 3; i++) {
	  val = (val << 8) + *p++;
	}
	break;
    }

    //    cerr << "val = " << hex << val << endl;
    return (val);
}


void VideoDecoder::next(void)
{
  if (++posX >= capUnitSize) {
    posX = 0;
    if (++posY >= capUnitSize) {
      posY = 0;
    }
  }
}


#if 0
ostream& operator<<(ostream& s,
		    const VideoDecoder& x)
{
}
#endif

