#include <iostream>
#include <isis/isis.h>

#include "transmit_unit.h"

int main(void)
{

	transmit_unit<int> a, b;

	b.input_data_port().connect(a.output_data_port());
	b.input_status_port().connect(a.output_status_port());

	a.input_data_port().connect(b.output_data_port());
	a.input_status_port().connect(b.output_status_port());

	b.input_send_port().connect(a.output_send_port());
	b.input_receive_port().connect(a.output_receive_port());
	a.input_send_port().connect(b.output_send_port());
	a.input_receive_port().connect(b.output_receive_port());
	

	/* a is send, b is receive */

	/* set send data & status */
	a.data_transmit_register() = 1;
	a.status_transmit_register() = 2;

	/* set send data & status */
	b.data_transmit_register() = 5;
	b.status_transmit_register() = 7;

	/* set status */
	a.input_receive() = 0;
	a.send_status() = 1;


	cout << "set status" << endl;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	cout << "after 1clock" << endl;
	cout << b.data_receive_latch() << " ";
	cout << b.status_receive_latch() << endl;

	/* set status */

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	cout << "after 2clock" << endl;
	cout << b.data_receive_latch() << " ";
	cout << b.status_receive_latch() << endl;
	

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	/* show receive data & status */
	cout << "after 3clock" << endl;
	cout << b.data_receive_latch() << " ";
	cout << b.status_receive_latch() << endl;
	
	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	/* show receive data & status */
	cout << "after 4clock" << endl;
	cout << b.data_receive_latch() << " ";
	cout << b.status_receive_latch() << endl;


	
	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	/* show receive data & status */
	cout << "after 5clock" << endl;
	cout << a.data_receive_latch() << " ";
	cout << a.status_receive_latch() << endl;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	/* show receive data & status */
	cout << "after 6clock" << endl;
	cout << a.data_receive_latch() << " ";
	cout << a.status_receive_latch() << endl;

	return 0;
}
