/* -*- C++ -*-
 *
 * <<< transmit_unit.h >>>
 *
 * --- transmit unit class 'transmit unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef TRANSMIT_UNIT_H
#define TRANSMIT_UNIT_H 1

//#define T_DEBUG
//#define TRA_DEBUG
//#define OUTPUT_RECEIVE_DEBUG

#include <string>
#include <iostream>
#include <isis/isis.h>
#include "vision_port.h"
#include "vision_packet.h"
#include "pico_typedef.h"


class transmit_unit 
{
private:
	typedef transmit_unit thisclass;

public:
	typedef pico_word D;
	typedef D data_type;

private:
	data_type data_, status_;
	data_type r_data_, r_status_;

	enum state_type{
		WAIT,
		TRANSMIT_END,
		TRANSMIT_DURING,
		TRANSMIT_START,
		RESERVED,
		SEND_END,
		SEND_DURING,
		SEND_START,
		RECEIVE,
		RECEIVE_END,
		RECEIVE_DURING,
	};

	state_type send_state;
	state_type receive_state;

	/* status */
	int input_receive_, output_receive_;
	int input_send_, output_send_;
	int send_status_;
	int transmit_status_;
	int receive_status_;
	int send_trans_;
	
	/* port */
	vision_port data_in, data_out;
	vision_port status_in, status_out;
	vision_port send_out, send_in;
	vision_port receive_out, receive_in;

	/* packet */
	packet *data_pkt;
	packet *status_pkt;
	packet *data_r_pkt;
	packet *status_r_pkt;
	packet *send_in_pkt;
	packet *send_out_pkt;
	packet *receive_in_pkt;
	packet *receive_out_pkt;

public:
	/* constractor & destractor */
	transmit_unit(void);
	transmit_unit(const thisclass&);
	~transmit_unit();

	/* Transmit Unit I/O */
	/*
	void read_deliver(){};
	void write_deliver() {};
	void read_receive() {};
	void write_receive() {};
	*/

	/* port connection  */
	vision_port& input_data_port() { return data_in; }
	vision_port& input_status_port(){ return status_in; }
	vision_port& output_data_port() { return data_out; }
	vision_port& output_status_port(){ return status_out; }
	
	vision_port& input_send_port() { return send_in; }
	vision_port& output_send_port() { return send_out;}
	vision_port& input_receive_port() { return receive_in; }
	vision_port& output_receive_port() { return receive_out; }
	
	/* Function */
	void reset(void);

	/* set & read status or register */
	data_type& data_transmit_register() { return data_; }
	data_type& status_transmit_register() { return status_; }
	data_type data_receive_latch() { return r_data_; }
	data_type status_receive_latch() { return  r_status_; }

	int& input_receive() { return input_receive_; }
	int& output_receive() { return output_receive_; }
	int& input_send() { return input_send_; }
	int& output_send() { return output_send_; }
	int& send_status() { return send_status_; }
	int& transmit_status() { return transmit_status_; }
	int& receive_status() { return receive_status_; }
	int& send_trans() { return send_trans_; }
//	void output_receive_test(int i) { output_receive_ = i; }

	/* Clock */
	void clock_in(void);
	void clock_out(void);

};

#endif //TRANSMIT_UNIT_H
