/* -*- C++ -*-
 *
 * <<< transmit_unit.cc >>>
 *
 * --- transmit unit class 'transmit unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <string>
#include <iostream>
#include <isis/isis.h>
#include "vision_port.h"
#include "vision_packet.h"
#include "pico_typedef.h"
#include "transmit_unit.h"

void transmit_unit::clock_in(void)
{
	switch(receive_state){
	case WAIT:
	#ifdef T_DEBUG
		cout << "WAIT" << endl;
	#endif //T_DEBUG

		if(data_in.have_packet()){
			receive_state = RECEIVE;
		}
		/*
		else if(input_receive_ == 0 && transmit_status_ == 0 && send_status_ == 1){
			send_trans_ = 1;
			state = SEND_START;
		}
		else if(input_receive_ == 0 && transmit_status_ == 1){
			state = TRANSMIT_START;
		}
		*/
		
		/*
		if(input_receive_ == 0 && transmit_status_ == 0 && send_status_ == 1){
			send_trans_ = 1;
			state = SEND_START;
		}
		else if(input_receive_ == 0 && transmit_status_ == 1){
			state = TRANSMIT_START;
		}
		else if(data_in.have_packet()){
			state = RECEIVE;
		}
		*/

		break;
	case RECEIVE_DURING:
	#ifdef T_DEBUG
		cout << "RECEIVE_DURING" << endl;
	#endif //T_DEBUG

	#ifdef OUTPUT_RECEIVE_DEBUG
		cout << "DEBUG: " << output_receive_ << endl;
	#endif	
		
		break;
	default:
		break;
	}

	switch(send_state){
	case WAIT:
	#ifdef T_DEBUG
		cout << "WAIT" << endl;
	#endif //T_DEBUG

		//if(input_receive_ == 0 && send_status_ == 1){
		if(send_status_ == 1){
			send_trans_ = 1;
			send_state = SEND_START;
		}
		//else if(input_receive_ == 0 && transmit_status_ == 1){
		else if(transmit_status_ == 1){
			send_state = TRANSMIT_START;
		}
		
		/*
		if(input_receive_ == 0 && transmit_status_ == 0 && send_status_ == 1){
			send_trans_ = 1;
			state = SEND_START;
		}
		else if(input_receive_ == 0 && transmit_status_ == 1){
			state = TRANSMIT_START;
		}
		else if(data_in.have_packet()){
			state = RECEIVE;
		}
		*/

		break;
	case TRANSMIT_END:
	#ifdef T_DEBUG
		cout << "TRANSMIT_END" <<  endl;
	#endif //T_DEBUG
		break;
	case TRANSMIT_DURING:
	#ifdef T_DEBUG
		cout << "TRANSMIT_DURING" << endl;
	#endif //T_DEBUG

		break;
	case TRANSMIT_START:

		break;
	case RESERVED:

		break;
	case SEND_END:
	#ifdef T_DEBUG
		cout << "SEND_END" <<  endl;
	#endif //T_DEBUG
		break;
	case SEND_DURING:
	#ifdef T_DEBUG
		cout << "SEND_DURING" <<  endl;
	#endif //T_DEBUG
/*
		if(input_receive_ == 1){
			state = SEND_END;
		}
*/
		break;
	case SEND_START:

		break;
	default:
	#ifdef T_DEBUG
		cout << "default" << endl;
	#endif //T_DEBUG
		break;

	}

}
	
void transmit_unit::clock_out(void)
{

	if(send_in.have_packet()){
		send_in_pkt = send_in.get();
		input_send_ =((vision_packet<D>*)(send_in_pkt)) -> data();
		delete send_in_pkt;
	}

	if(receive_in.have_packet()){
		receive_in_pkt = receive_in.get();
		input_receive_ =((vision_packet<D>*)(receive_in_pkt)) -> data();
		delete receive_in_pkt;
	}

	switch(receive_state){
	case WAIT:
	#ifdef T_DEBUG
		cout << "WAIT" << endl;
	#endif

		/*
		if(input_receive_ == 0 && transmit_status_ == 1){
			transmit_status_ = 1;
			receive_state = TRANSMIT_START;
		}
		else if(input_receive_ == 0 && transmit_status_ == 0 && send_status_ == 1){
			send_trans_ = 1;
			state = SEND_START;
		}
		*/

		break;
	case RECEIVE_END:
	#ifdef T_DEBUG
		cout << "RECEIVE_END" << endl;
	#endif //T_DEBUG
		transmit_status_ = 0;

		break;
	case RECEIVE_DURING:
	#ifdef OUTPUT_RECEIVE_DEBUG
		cout << "DEBUG: " << output_receive_ << endl;
	#endif	
	#ifdef T_DEBUG
		cout << "RECEIVE_DURING2 " << input_send_ << " " << output_receive_ << endl;
	#endif //T_DEBUG
		if(input_send_ == 0 && output_receive_ == 0){
			receive_status_ = 0;
			transmit_status_ = 0;
			r_data_ = 0;
			r_status_ = 0;
			receive_state = WAIT;
		}
		
		break;
	case RECEIVE:
	#ifdef T_DEBUG
		cout << "RECEIVE" << endl;
	#endif //T_DEBUG
		/* receive */

		output_receive_ = 1;
		receive_status_ = 1;
		transmit_status_ = 1;

		data_r_pkt = data_in.get();
		status_r_pkt = status_in.get();
		r_data_ = ((vision_packet<D>*)(data_r_pkt)) -> data();
		r_status_ = ((vision_packet<D>*)(status_r_pkt)) -> data();

		delete data_r_pkt;
		delete status_r_pkt;

		receive_state = RECEIVE_DURING;

		break;
	default:
		break;
	}

	switch(send_state){
	case WAIT:
		break;
	case TRANSMIT_END:
	#ifdef T_DEBUG
		cout << "TRANSMIT_END" << endl;
	#endif //T_DEBUG
		/* change status */
		if(input_receive_ == 0){
			transmit_status_ = 0;
			//output_send_ = 0;
			send_state = WAIT;
		}
		
		break;
	case TRANSMIT_DURING:
	#ifdef T_DEBUG
		cout << "TRANSMIT_DURING" << endl;
	#endif //T_DEBUG
		if(input_receive_ == 1){
			send_state = TRANSMIT_END;
			//state = WAIT;
			//transmit_status_ = 0;
			output_send_ = 0;
		}
		break;
	case TRANSMIT_START:
	#ifdef T_DEBUG
		cout << "TRANSMIT_START" << endl;
	#endif //T_DEBUG
		/* change status */
		output_send_ = 1;
		
		/* create packet */
		data_pkt = new vision_packet<D>;
		status_pkt = new vision_packet<D>;
		((vision_packet<D>*)(data_pkt)) -> data() = data_;
		((vision_packet<D>*)(status_pkt)) -> data() = status_;

		/* send packet */
		data_out.put(data_pkt);
		status_out.put(status_pkt);

		send_state = TRANSMIT_DURING;

		break;
	case RESERVED:

		break;
	case SEND_END:
	#ifdef T_DEBUG
		cout << "SEND_END" << endl;
	#endif //T_DEBUG
		/* change status */
		if(input_receive_ == 0){
			send_status_ = 0;
			send_trans_ = 0;
			send_state = WAIT;
		}

		/* delete packet */


		break;
	case SEND_DURING:
	#ifdef T_DEBUG
		cout << "SEND_DURING" << endl;
	#endif //T_DEBUG
		if(input_receive_ == 1){
			send_state = SEND_END;
			//state = WAIT;
		//	send_status_ = 0;
		//	send_trans_ = 0;
			output_send_ = 0;
		}
		break;
	case SEND_START:
	#ifdef T_DEBUG
		cout << "SEND_START" << endl;
	#endif // T_DEBUG
		
		/* change status */
		output_send_ = 1;
		
		/* create packet */
		data_pkt = new vision_packet<D>;
		status_pkt = new vision_packet<D>;
		((vision_packet<D>*)(data_pkt)) -> data() = data_;
		((vision_packet<D>*)(status_pkt)) -> data() = status_;

		/* send packet */
		data_out.put(data_pkt);
		status_out.put(status_pkt);

		send_state = SEND_DURING;

		break;
	default:
	#ifdef T_DEBUG
		cout << "default" << endl;
	#endif //T_DEBUG
		break;

	}

	if(send_out.is_connected()){
		send_out_pkt = new vision_packet<D>;
		((vision_packet<D>*)(send_out_pkt)) -> data() = output_send_;
		send_out.put(send_out_pkt);
	}
	
	if(receive_out.is_connected()){
		receive_out_pkt = new vision_packet<D>;
		((vision_packet<D>*)(receive_out_pkt)) -> data() = output_receive_;
		receive_out.put(receive_out_pkt);
	}

}

transmit_unit::transmit_unit(void)
{
	#ifdef TRA_DEBUG
	r_data_ = 10;
	r_status_ = 400;
	#endif	

	send_state = WAIT;
	receive_state = WAIT;
	r_data_ = 0;
	r_status_ = 0;

	input_receive_ = 0;
	output_receive_ = 0;
	input_send_ = 0;
	output_send_ = 0;
	send_status_ = 0;
	receive_status_ = 0;
	transmit_status_ = 0;

}

transmit_unit::transmit_unit(const thisclass&)
{
	send_state = WAIT;
	receive_state = WAIT;
	r_data_ = 0;
	r_status_ = 0;

	input_receive_ = 0;
	output_receive_ = 0;
	input_send_ = 0;
	output_send_ = 0;
	send_status_ = 0;
	receive_status_ = 0;
	transmit_status_ = 0;

	send_in_pkt = new vision_packet<D>;
	receive_in_pkt = new vision_packet<D>;

}

transmit_unit::~transmit_unit()
{
}

void transmit_unit::reset(void)
{
	input_receive_ = 0;
	output_receive_ = 0;
	input_send_ = 0;
	output_send_ = 0;
	send_status_ = 0;
	receive_status_ = 0;
	transmit_status_ = 0;
}


//ostream& operator<<(ostream&, const transmit_unit&);

