/* -*- C++ -*-
 *
 * <<< transmit_status_buffer.h >>>
 *
 * --- transmit status buffer class 'transmit status buffer'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef TRANSMIT_STATUS_BUFFER
#define TRANSMIT_STATUS_BUFFER 1

#include <iostream>

class transmit_status_buffer{
private:
	struct transmit_status{
		unsigned int left_receive_ : 1;
		unsigned int right_send_ : 1;
		unsigned int right_receive_ : 1;
		unsigned int left_send_ : 1;
		unsigned int up_receive_ : 1;
		unsigned int down_send_ : 1;
		unsigned int down_receive_ : 1;
		unsigned int up_send_ : 1;
		unsigned int result_status_ : 1;
		unsigned int input_status_ : 1;
	};
	transmit_status buffer;

public:
	transmit_status_buffer(void);

	~transmit_status_buffer(){};
	unsigned int get_status(void);

	unsigned int left_receive(){ return buffer.left_receive_; };
	unsigned int right_send() { return buffer.right_send_; };
	unsigned int right_receive() { return buffer.right_receive_; };
	unsigned int left_send() { return buffer.left_send_; };
	unsigned int up_receive() { return buffer.up_receive_; };
	unsigned int down_send() { return buffer.down_send_; };
	unsigned int down_receive() { return buffer.down_receive_; };
	unsigned int up_send() { return buffer.up_send_; };
	unsigned int result_status() { return buffer.result_status_; };
	unsigned int input_status() { return buffer.input_status_; };
	void left_receive(unsigned int i){ buffer.left_receive_ = i; };
	void right_send(unsigned int i) { buffer.right_send_ = i; };
	void right_receive(unsigned int i) { buffer.right_receive_ = i; };
	void left_send(unsigned int i) { buffer.left_send_ = i; };
	void up_receive(unsigned int i) { buffer.up_receive_ = i; };
	void down_send(unsigned int i) { buffer.down_send_ = i; };
	void down_receive(unsigned int i) { buffer.down_receive_ = i; };
	void up_send(unsigned int i) { buffer.up_send_ = i; };
	void result_status(unsigned int i) { buffer.result_status_ = i; };
	void input_status(unsigned int i) { buffer.input_status_ = i; };
};

#endif // TRANSMIT_STATUS_BUFFER
