/* -*- C++ -*-
 *
 * <<< transmit_status_buffer.cc >>>
 *
 * --- transmit status buffer class 'transmit status buffer'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "transmit_status_buffer.h"

using namespace std;

unsigned int transmit_status_buffer::get_status(void) {
	unsigned int i = 0; 
	i = buffer.left_receive_ * 0x01 + buffer.right_send_ * 0x02 +
	 buffer.right_receive_ * 0x04 + buffer.left_send_ * 0x08 +
	 buffer.up_receive_ * 0x10 + buffer.down_send_ * 0x20 +
	 buffer.down_receive_ * 0x40 + buffer.up_send_ * 0x80 +
	 buffer.result_status_ * 0x100 + buffer.input_status_ * 0x200;
	 return i;
}

transmit_status_buffer::transmit_status_buffer(void){
	buffer.left_receive_ = 0;
	buffer.right_send_ = 0;
	buffer.right_receive_ = 0;
	buffer.left_send_ = 0;
	buffer.up_receive_ = 0;
	buffer.down_send_ = 0;
	buffer.down_receive_ = 0;
	buffer.up_send_ = 0;
	buffer.result_status_ = 0;
	buffer.input_status_ = 0;
}
