#! /usr/local/perl/bin/perl 

###################################################
##
##    PICA <PICo Assembler>   2002.02.02
##                                (c)unotan,  2000
##                                   nosuke,  2001
##                                   masahiro,2001
##
###################################################

require 'utils.pl';

### Definition & Initialization ###

%RFUNC = (  #RFUNC Top
           'NOP' => '00000',
           'MV'  => '00001',
           'AND' => '00010',
           'OR'  => '00011',
		   'XOR' => '00100',
           'SL'  => '01100',
           'SR'  => '01101',
		   'CMP' => '01110',
		   'LB'  => '01010',
		   'SB' => '01011',
           'ADD' => '00110',
           'SUB' => '00111',
           'LD'  => '01000',
           'ST'  => '01001',
		   'MUL' => '10101',
		   'MULFI'=> '10110',
		   'MULFF' => '10111',
           #'nop' => '00000',
           #'mv'  => '00001',
           #'and' => '00010',
           #'or'  => '00011',
		   #'xor' => '00100',
           #'sl'  => '01100',
           #'sr'  => '01101',
		   #'cmp' => '01110',
		   #'lb'  => '01010',
		   #'sb' => '01011',
           #'add' => '00110',
           #'sub' => '00111',
           #'ld'  => '01000',
           #'st'  => '01001',
		   #'mul' => '10101',
		   #'mulfi'=> '10110',
		   #'mulff' => '10111',
         ); #RFUNC Bottom
@ROP = keys %RFUNC;

%SFUNC = (  #SFUNC Top
		   'PUSH' => '00000',
		   'POP' => '00001',
		   'LOOK' => '00010',
		   'NEXT' => '00011',
		   'MVR2S' => '10000',
		   'MVS2R' => '10001',
		   'MVR2T' => '10010',
		   'MVT2R' => '10011',
		   'MVR2B' => '10100',
		   'MVB2R' => '10101',
		   'MVT2S' => '10110',
		   'MVB2S' => '10111',
		   'PUSHS'=> '00100',
		   'POPS' => '00101',
		   'SSP2REG' => '00110',
		   'REG2SSP' => '00111',
         ); #SFUNC Bottom
@SOP = keys %SFUNC;

%TypeI = (  #TypeI Top
		   'HALT' => '00001',
           'ANDI' => '00010',
		   'ORI'  => '00011',
		   'XORI' => '00100',
           'ADDI' => '00110',
           'SUBI' => '00111',
		   'CMPI' => '11011',
           'LDLI' => '11100',
           'LDHI' => '11101',
		   'MULI' => '10100',
		   'MULFII' => '10101',
		   'MULFFI' => '10110',
		   #'halt' => '00001',
           #'andi' => '00010',
		   #'ori'  => '00011',
		   #'xori' => '00100',
           #'addi' => '00110',
           #'subi' => '00111',
		   #'cmpi' => '11011',
           #'ldli' => '11100',
           ##'ldhi' => '11101',
		   #'muli' => '10100',
		   #'mulfii' => '10101',
		   #'mulffi' => '10110',
         ); #IFUNC Bottom
@IOP = keys %TypeI;

%TypeJ = (  #TypeJ Top
           'JMP' => '01111',
		   #'JAL' => '01101',
		   'JR'  => '01110',
           'BNEZ' => '01001',
           'BEQZ' => '01010',
           'BPL'  => '01100',
           'BMI'  => '01011',
		   'CALL' => '10000',
		   'RTN'  => '10001',
           #'jmp' => '01111',
		   #'jal' => '01101',
		   #'jr'  => '01110',
           #'bnez' => '01001',
           #'beqz' => '01010',
           #'bpl'  => '01100',
           #'bmi'  => '01011',
		   #'call' => '10000',
		   #'rtn'  => '10001',
         ); #TypeJ Bottom
@JOP = keys %TypeJ;

%TypeP = (  #TypeP Top
		   'PFX'  => '11010',
		   'pfx'  => '11010',
         ); #TypeP Bottom
@POP = keys %TypeP;

%TOLABELS = ();

$OPC = "";
$OPR1 = "";
$OPR2 = "";
$SRC = "";
$DIS = "";
$BINARY = "";
$HEX = "";
$COMMENT = "";
$ORGLINE = "";
$arg = "";
@KEYS = ();

$SOPC  = "";     # pseudo opecode
$SOPR1 = "";     # pseudo operand1
$SOPR2 = "";     # pseudo operand2

$key = "";
$value = "";

$incomment = 0;
$subsuc = 0;
$hex_mode = 1;
$bin_mode = 2;
$nocom_mode = 4;
$verilog_mode = 8;
$all_mode = 16;
$mode = $all_mode;

$infile = "";

if(@ARGV > 2){
	&printhelp();
	exit;
}

while($arg = shift @ARGV){
	if($arg =~ m/^-x$/ || $arg =~ m/^--hex$/){
		$mode = $hex_mode;
	}
	elsif($arg =~ m/^-b$/ || $arg =~ m/^--bin$/){
		$mode = $bin_mode;
	}
	elsif($arg =~ m/^-nc$/ || $arg =~ m/^--nocom$/){
		$mode = $nocom_mode;
	}
	elsif($arg =~ m/^-v$/ || $arg =~ m/^--verilog$/){
		$mode = $verilog_mode;
	}
	elsif($arg =~ m/^-a$/ || $arg =~ m/^--all$/){
		;
	}
	elsif($arg =~ m/^-h$/ || $arg =~ m/^--help$/){
		&printhelp();
		exit;
	}
	elsif($arg =~ m/^-/){
		print "$arg : Invalid option.\n";
		exit;
	}
	else{
		$infile = $arg;
	}
}

if( ! $infile ){
	print "Input file is not specified.\n";
	exit;
}

#################################################
#################### PHASE 1 ####################
#################################################
############## Comment processing ###############
############## Label registration ###############
############### Cleaning format #################
#################################################

$INDEX = 0;
open(FILE, ">upa.$$") or die "Can't Open file\n";
open(IN,"<$infile") or die "Can't Open file\n";
while(<IN>){
    chomp;

	next if m/^\s*$/;

	# PROCESSING COMMENT
	if($incomment){
		$incomment = 0 if s|^.*?\*/||;
	}
	s|/\*.*?\*/||g;
	next if $incomment;
	if(!$incomment){
		$incomment = 1 if s|/\*.*$||;
	}
	
    s|//.*||; # remove comment begin //

	die "Syntax Error: Ambiguous */ used: line$.\n" if m|\*/|;

	# PROCESSING LABEL
	$subsuc = 0;
	$subsuc = s/\s*([^:\s]+):\s*//;
	$TOLABELS{$1} = ($INDEX / 2) if $subsuc;
	#$TOLABELS{$1} = $INDEX * 2 if $subsuc;

	next if m/^\s*$/;

    # PROCESSING PSEUDO INSTRUCT
    $subsuc = 0;
    #$subsuc = s/\s*(\.[A-z][\w]*)\s?\s*([\w]*)$//;

    # .set ADDR 0
    #if(s/\s*\.([A-z][\w]*)\s+([^\s]+)\s+([^\s]+)$//){
    if(s/\s*\.([A-z][\w]*)\s+([^\s]+)\s+([^\s].*)$//){
	$SOPC = $1; $SOPR1 = $2; $SOPR2 = $3; 
	if( $SOPC =~ m/^(SET|set)$/ ){  # support only '.set' instruction
	    ( $SOPR1 =~ m/^\$/) or die "Syntax error: line $.";


		if( $SOPR2 =~ m/\*|\/|\+|\-|\(|\)/ ){
			$SOPR2 =~ s/\$(\w+)/\$DEFINES\{\'\$$1\'\}/g;
			#print $SOPR2,"\n";
			while ( ($set_key, $set_value ) = each %DEFINES ){
				$set_key = '\\'.$set_key;
				#print "$set_key\n*$set_value\n";
				$SOPR2=~s/\$DEFINES\{\'$set_key\'\}/$set_value/g;
				$SOPR2=~s/\#//g;
				#print $SOPR2,"\n";
				}

			$DEFINES{$SOPR1} =  '#'.eval($SOPR2) if (! exists $DEFINES{$SOPR1} )
			or die "Double define error.: line:$. define:$2\n";

		}
		else{
		    $DEFINES{$SOPR1} = $SOPR2 if (! exists $DEFINES{$SOPR1} )
			or die "Double define error.: line:$. define:$2\n";
		}			
	}
	next;
	# other pseudo instructions are ignored
    }

	$subsuc = 0;
	# for TypeR and TypeI and TypeS
	$subsuc += s/^\s*([^\s,]+?)\s+([^\s,]+?)\s*,\s*([^\s,]+)\s*$/\1:\2:\3/;


	# for TypeJ and TypeP
	$subsuc += s/^\s*([^\s,]+?)\s+([^\s,]+?)\s*$/\1:\2/;


	# for NOP
	$subsuc += s/^\s*NOP\s*$/NOP:/;

	# for HALT
	$subsuc += s/^\s*HALT\s*$/HALT:/;

	# for RTN
	$subsuc += s/^\s*RTN\s*$/RTN:/;

    # replace DEFINITIONS
    while (($key,$value) = each(%DEFINES)){
	s/(\$[^:]+)/$DEFINES{$1}/e;
	#s/(\$[^:]+)/$DEFINES{$1}/e;
    }

	if(! $subsuc){
		system("rm upa.$$") if -e "upa.$$";
		die "Syntax error: line $.";
	}
	print FILE "$.",":$_\n";

	#$INDEX++;
	$INDEX += 2;
}
close(FILE);
close(IN);

if($incomment){
	system("rm upa.$$") if -e "upa.$$";
	die "Syntax Error: comment unclosed\n";
}

#################################################
#################### PHASE 2 ####################
#################################################
################## Assembling ###################
#################################################

$INDEX = 0;
open(FILE, "<upa.$$") or die "Can't Open file\n";

while(<FILE>){
	chomp;

	($ORGLINE, $OPC, $OPR1, $OPR2) = split /:/;

    undef $SRC;
    undef $DIS;

    # TypeR
    if("@ROP" =~ m/$OPC/){
        if( $OPC eq "LD" ){
    	    ($SRC) = ( $OPR2 =~ m/^\([rR]([0-7])\)$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: LD r[0-7], (r[0-7])\n";
            }
        }

        ($SRC) = ( $OPR2 =~ m/^[rR]([0-7])$/ ) if !defined $SRC;

        if( $OPC eq "ST" ){
    	    ($DIS) = ( $OPR1 =~ m/^\([rR]([0-7])\)$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: ST (r[0-7]), r[0-7]\n";
            }
        }

        ($DIS) = ( $OPR1 =~ m/^[rR]([0-7])$/ ) if !defined $DIS;

        if( $OPC eq "NOP" ){
             $DIS = 0;
             $SRC = 0;
        }

		if( $OPC eq "HALT" ){
			$DIS = 0;
			$SRC = 0;
		}

        if( ! defined $SRC || ! defined $DIS ){
			system("rm upa.$$") if -e "upa.$$";
			die "Syntax Error: line$ORGLINE\n Format: OPC r[0-7], r[0-7]\n";
        }
		$DIS = &d2b($DIS,3);
		$SRC = &d2b($SRC,3);
		$BINARY = "00000" . $DIS . $SRC . $RFUNC{$OPC};
		$COMMENT = "$OPC $OPR1, $OPR2  00000 $DIS $SRC $RFUNC{$OPC} line $ORGLINE";
		if( $OPC eq NOP ){
			$DIS = &d2b(0,16);
			$COMMENT = "$OPC\t\t$DIS line $ORGLINE";
		}else{
			$COMMENT = "$OPC $OPR1, $OPR2\t00000 $DIS $SRC $RFUNC{$OPC} line $ORGLINE";
		}
    }
	# TypeI
    elsif ("@IOP" =~ m/$OPC/){
		if( $OPC =~ m/^B.+/ ){
    	    ($SRC) = ( $OPR2 =~ m/^(-?[0-9]+)$/ );
    	    ($SRC) = ( $OPR2 =~ m/^(0x[0-9a-zA-Z]+)$/ ) if !defined $SRC;
            if( ! defined $SRC ){
				@KEYS = keys %TOLABELS;
				if("@KEYS" =~ $OPR2){
					$SRC = $TOLABELS{$OPR2} - ($INDEX / 2) - 1;
					$OPR2 = $SRC;
					if($OPC eq "BNEZ" || $OPC eq "BEQZ" || 
								$OPC eq "BMI" || $OPC eq "BPL"){
						if($SRC > 1023 || $SRC < -1024){
							system("rm upa.$$") if -e "upa.$$";
						    die "Branch Address is Over : line$ORGLINE\n";
						}
					}
				}else{
					system("rm upa.$$") if -e "upa.$$";
					die "Such a label don't exist.: line$ORGLINE\n";
				}
            }
		}
		if( $OPC =~ m/^J.+/ ){
    	    ($SRC) = ( $OPR2 =~ m/^(-?[0-9]+)$/ );
    	    ($SRC) = ( $OPR2 =~ m/^(0x[0-9a-zA-Z]+)$/ ) if !defined $SRC;
            if( ! defined $SRC ){
				$SRC =  0;#( $OPR2 =~^
            }
		}

        ($SRC) = ( $OPR2 =~ m/^#(-?[0-9]+)$/ ) if !defined $SRC;
    	($SRC) = ( $OPR2 =~ m/^#(0x[0-9a-zA-Z]+)$/ ) if !defined $SRC;

		#print $SRC."\n";
		
		$SRC = $SRC =~ /0x/ ? (oct($SRC) & 0x00ff) : ($SRC % 256) ;

		#print $SRC."\n";

        ($DIS) = ( $OPR1 =~ m/^[rR]([0-7])$/ );

		if( $OPC eq HALT ){
			$DIS = &d2b(0, 16);
        }elsif( ! defined $SRC || ! defined $DIS ){
			system("rm upa.$$") if -e "upa.$$";
			die "Syntax Error: line$ORGLINE\n Format: OPC r[0-7], #value\n";
        }
		$DIS = &d2b($DIS,3);
		#$SRC = (oct($SRC));
		$SRC = $SRC =~ /0x/ ? &h2b($SRC,8) : &d2b($SRC,8) ;
		$BINARY = $TypeI{$OPC} . $DIS . $SRC;
		$COMMENT = "$OPC $OPR1, $OPR2\t$TypeI{$OPC} $DIS $SRC line $ORGLINE";
	}
	# TypeJ
	elsif ("@JOP" =~ m/$OPC/){
        ($DIS) = ( $OPR1 =~ m/^(-?[0-7])$/ );
        ($DIS) = ( $OPR1 =~ m/^(0x[0-9a-zA-Z]+)$/ ) if !defined $DIS;
		if( $OPC eq RTN){
			$DIS = &d2b(0,8);
		}
        elsif( ! defined $DIS ){
			@KEYS = keys %TOLABELS;
			if("@KEYS" =~ $OPR1){
				$DIS = $TOLABELS{$OPR1} - ($INDEX / 2) - 1;
				#$DIS = $TOLABELS{$OPR1} - $INDEX - 2;
				#$DIS = $TOLABELS{$OPR1} - $INDEX*2 - 2;
				if($OPC eq "JMP" || $OPC eq "CALL"){
				#if($OPC eq "JMP" ){
					if($DIS > 1023|| $DIS < -1024){
						system("rm upa.$$") if -e "upa.$$";
						die "Jump Address is Over : line$ORGLINE\n";
					}
				}
			}else{
				system("rm upa.$$") if -e "upa.$$";
				die "Sucn a label don't exist.: $ORGLINE\n";
			}
        }

        if( ! defined $DIS ){
			system("rm upa.$$") if -e "upa.$$";
			die "Syntax Error: line$ORGLINE\n Format: OPC #value\n";
        }
		$OPR1 = $DIS;
		#$SRC = (oct($SRC));
		$DIS = $DIS =~ /0x/ ? &h2b($DIS,11) : &d2b($DIS,11) ; 
		$BINARY = $TypeJ{$OPC} . $DIS;
		$OPR1_ = $OPR1 * 2;
		$COMMENT = "$OPC $OPR1_\t\t$TypeJ{$OPC} $DIS line $ORGLINE";
	}
	# TypeP
	elsif ("@POP" =~ m/$OPC/){
        ($SRC) = ( $OPR1 =~ m/^#(-?[0-9]+)$/ ) if !defined $SRC;
        #($SRC) = ( $OPR1 =~ m/^#([0-9]+)$/ ) if !defined $SRC;
    	($SRC) = ( $OPR1 =~ m/^#(0x[0-9a-zA-Z]+)$/ ) if !defined $SRC;
		if( ! defined $SRC ){
			@KEYS = keys %TOLABELS;
		}

        if( ! defined $SRC ){
			system("rm upa.$$") if -e "upa.$$";
			die "Syntax Error: line$ORGLINE\n Format: OPC #value\n";
        }
		
		$DIS = &d2b(0,3);
		#print $SRC,"\n";
		$SRC = $SRC =~ /0x/ ? (oct($SRC) >> 8) : ($SRC >> 8);
		#print $SRC,"\n";
		$SRC = $SRC =~ /0x/ ? &h2b($SRC, 8) : &d2b($SRC, 8) ;
		$BINARY = $TypeP{$OPC} . $DIS . $SRC;
		$COMMENT = "$OPC $OPR1, $OPR2\t$TypeP{$OPC} $DIS $SRC line $ORGLINE";

#		$OPR1 = $SRC;
#		$SRC = $SRC =~ /0x/ ? &h2b($SRC,11) : &d2b($SRC,11) ; 
#		$BINARY = $TypeP{$OPC} . $SRC;
#		$OPR1_ = $OPR1 * 2;
#		$COMMENT = "$OPC $OPR1_\t\t$TypeP{$OPC} $SRC line $ORGLINE";
	}
    # TypeS
    elsif("@SOP" =~ m/$OPC/){
        if( $OPC eq "MVR2S" || $OPC eq "MVR2T" || $OPC eq "MVR2B" ){
    	    ($SRC) = ( $OPR2 =~ m/^[rR]([0-7])$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVR2* r[0-7], *[0-7]\n";
            }
        }
        elsif( $OPC eq "POP" || $OPC eq "LOOK" || $OPC eq "NEXT" ){
    	    ($SRC) = ( $OPR2 =~ m/^\([sS][pP]([0-7])\)$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: (POP | LOOK | NEXT)  r[0-7], (sp[0-7])\n";
            }
        }
        elsif( $OPC eq "MVS2R" ){
    	    ($SRC) = ( $OPR2 =~ m/^[sS][pP]([0-7])$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVS2R r[0-7], sp[0-7]\n";
            }
        }
        elsif( $OPC eq "MVT2R" || $OPC eq "MVT2S" ){
    	    ($SRC) = ( $OPR2 =~ m/^[tT][bB]([0-7])$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVT2* *[0-7], tb[0-7]\n";
            }
        }
        elsif( $OPC eq "MVB2R" || $OPC eq "MVB2S" ){
    	    ($SRC) = ( $OPR2 =~ m/^[bB][bB]([0-7])$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVB2* *[0-7], bb[0-7]\n";
            }
        }

        ($SRC) = ( $OPR2 =~ m/^[rR]([0-7])$/ ) if !defined $SRC;

        if( $OPC eq "PUSH" ){
    	    ($DIS) = ( $OPR1 =~ m/^\([sS][pP]([0-7])\)$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: PUSH (sp[0-7]), r[0-7]\n";
            }
        }
        elsif( $OPC eq "MVS2R" || $OPC eq "MVB2R" || $OPC eq "MVB2R" ){
    	    ($DIS) = ( $OPR1 =~ m/^[rR]([0-7])$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MV*2R *[0-7], r[0-7]\n";
            }
        }
        elsif( $OPC eq "MVB2S" || $OPC eq "MVT2S" || $OPC eq "MVR2S"){ 
    	    ($DIS) = ( $OPR1 =~ m/^[sS][pP]([0-7])$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MV*2S *[0-7], sp[0-7]\n";
            }
        }
        elsif( $OPC eq "MVR2T" ){
    	    ($DIS) = ( $OPR1 =~ m/^[tT][bB]([0-7])$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVR2T r[0-7], tb[0-7]\n";
            }
        }
        elsif( $OPC eq "MVR2B" ){
    	    ($DIS) = ( $OPR1 =~ m/^[bB][bB]([0-7])$/ );
            if( ! defined $DIS ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: MVR2B r[0-7], bb[0-7]\n";
            }
        }

        elsif( $OPC eq "PUSHS" || $OPC eq "POPS" || $OPC eq "SSP2REG" 
				|| $OPC eq "REG2SSP" ){
    	    ($SRC) = ( $OPR1 =~ m/^[rR]([0-7])$/ );
            if( ! defined $SRC ){
				system("rm upa.$$") if -e "upa.$$";
			    die "Syntax Error: line$ORGLINE\n Format: pushs pops r[0-7]\n";
            }
        }
			
        ($DIS) = ( $OPR1 =~ m/^[rR]([0-7])$/ ) if !defined $DIS;

        if( ! defined $SRC || ! defined $DIS ){
			system("rm upa.$$") if -e "upa.$$";
			die "Syntax Error: line$ORGLINE\n Format: OPC r[0-7], r[0-7]\n";
        }
		$DIS = &d2b($DIS,3);
		$SRC = &d2b($SRC,3);
		$BINARY = "11111" . $DIS . $SRC . $SFUNC{$OPC};
		$COMMENT = "$OPC $OPR1, $OPR2  11111 $DIS $SRC $SFUNC{$OPC} line $ORGLINE";
		if( $OPC eq NOP ){
			$DIS = &d2b(0,16);
			$COMMENT = "$OPC\t\t$DIS line $ORGLINE";
		}else{
			$COMMENT = "$OPC $OPR1, $OPR2\t11111 $DIS $SRC $SFUNC{$OPC} line $ORGLINE";
		}
    }
	else{
		system("rm upa.$$") if -e "upa.$$";
		die "Such a OPCODE is not defined. : line$ORGLINE\n";
	}

	$HEX = &b2h($BINARY);


	if($mode == $hex_mode){
		print "$HEX\n";
	}
	elsif($mode == $bin_mode){
		print "$BINARY\n";
	}
	elsif($mode == $nocom_mode){
		print "memset /IMEM/memory $INDEX X$HEX\n";
	}
	else{
		
		if($mode == $verilog_mode){
			$HEX1 = substr($HEX, 0, 2);
			$HEX2 = substr($HEX, 2, 4);
			printf("\@%08x $HEX1 $HEX2 // %s\n", $INDEX, $COMMENT);
		}
		else{
			$HEX1 = int($HEX / 100);
			$HEX2 = $HEX % 100;
			##print "memset /IMEM/memory $INDEX X$HEX \# $COMMENT\n";
			##print "\@${INDEX} $HEX1 $HEX2 \# $COMMENT\n";
			##printf("\@%08x $HEX1 $HEX2 \# %s\n", $INDEX, $COMMENT);
			printf("\@%08x $HEX \# %s\n", $INDEX, $COMMENT);
		}
	}

	$INDEX += 2;
	#$INDEX++;
}

system("rm upa.$$") if -e "upa.$$";

sub printhelp(){
	print <<END_OF_TEXT;

Copyright (C) 2000 M.U(\@hunga lab.)
pica 0.07.00.2 (Feburary 02 2002)
Usage: pica [option] <srcfile>
  The default action is to print IMEM information to stdout 
  as same as "-a" is specified.
  <<option>>
    -a,--all
          : print out perfect IMEM format.
    -nc,--nocom
          : print out IMEM format without comment.
    -b,--bin
          : print out only binarys of instructions
    -x,--hex
          : print out only hexadecimals of instructions
    -h,--help
          : show this help
	-v, --verilog
		  : print out verilog simulation mode


END_OF_TEXT
}

