
#include "pico_timer_unit.h"
#include <iostream>

using namespace std; 

pico_timer_unit::pico_timer_unit(mapped_memory<word>& c)
	:local_memory(c)
{
	memory_address_ = 0x32fe;
	operation_memory_address_ = 0x32fc;
	counter_set_address_ = 0x32fa;
	memory_counter_ = 0;
	counter_ = 0;
	clock_count_ = 0xffff;

}

pico_timer_unit::pico_timer_unit(mapped_memory<word>& c,
						address_type a, data_type d = 0xffff)
	:local_memory(c)
{
	memory_address_ = a;
	clock_count_ = d;
	operation_memory_address_ = 0x32fc;
	counter_set_address_ = 0x32fa;
	memory_counter_ = 0;
	counter_ = 0;
	
}


void pico_timer_unit::clock_in(void)
{

	operation_ = local_memory.read(operation_memory_address_);
	clock_count_ = local_memory.read(counter_set_address_);
	//memory_counter_ = local_memory.read(counter_set_address_);

	switch(operation_){
	case 1: //START:
		counter_++;
		if(counter_ >= clock_count_){
			counter_ = 0;
			//memory_counter_ = local_memory.read(memory_counter_);
			memory_counter_++;
			/* memory counter incriment */
			local_memory.write(memory_address_, memory_counter_);
		}	
		break;
	case 2: //RESET:
		reset();
		break;
	case 0: //STOP:
	default:
		break;
	}

}

void pico_timer_unit::reset(void)
{
	counter_ = 0;
	memory_counter_ = 0;

}

void pico_timer_unit::output(ostream& os) const
{
	os << read_count();
#ifdef DEBUG
	os.flush();
#endif // DEUBG

}

