/* -*- C++ -*-
 *
 * <<< pico_processing_element.h >>>
 *
 * --- pico processing element class 'pico_processing_element'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_PROCESSING_ELEMENT_H
#define PICO_PROCESSING_ELEMENT_H 1

#include <string>
#include <isis/generic_processing_element.h>
#include "pico_typedef.h"
#include "pico.h"
#include "control_unit.h"


class pico_processing_element
	: public generic_processing_element<pico, pico_word, pico_word,
										sizeof_pico_word, char>
{
private:
	typedef pico_processing_element thisclass;
	typedef generic_processing_element<pico, pico_word, pico_word,
									   sizeof_pico_word, char> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	typedef pico_word word_type;
	static const size_type sizeof_data_type = inherited::sizeof_data_type;
private:
	static const address_type default_multi_io_area_address;
	static const size_type default_multi_io_area_size;
public:
	pico_processing_element(void);
	pico_processing_element(const thisclass&);
	virtual ~pico_processing_element();
	virtual void output(std::ostream&) const;
	virtual bool output(std::ostream&, const std::string&) const;
	virtual bool load(const char*, int&);
	virtual void disassemble(std::ostream&, address_type, size_type) const;
	void clock_in(void);
	void clock_out(void);
};


#endif /* PICO_PROCESSING_ELEMENT_H */
