/*
 * <<< pico_multiply_unit.h >>>
 *
 * --- pico multiply/divide unit class 'pico_multiply_unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "pico_multiply_unit.h"

const unsigned int pico_multiply_unit::default_mult_wait = 12;
const unsigned int pico_multiply_unit::default_div_wait = 35;

using namespace std;

pico_multiply_unit::pico_multiply_unit(void)
	: hi_(data_type(0)),
	  lo_(data_type(0)),
	  mult_wait_(default_mult_wait),
	  div_wait_(default_div_wait),
	  count(0)
{}

pico_multiply_unit::pico_multiply_unit(const pico_multiply_unit& a)
	: hi_(a.hi_),
	  lo_(a.lo_),
	  mult_wait_(a.mult_wait_),
	  div_wait_(a.div_wait_),
	  count(a.count)
{}

void pico_multiply_unit::clear(void)
{
	hi_ = lo_ = data_type(0);
	count = 0;
}

void pico_multiply_unit::set_mult_wait(unsigned int a)
{
	mult_wait_ = a;
}

void pico_multiply_unit::set_div_wait(unsigned int a)
{
	div_wait_ = a;
}
