/* -*- C++ -*-
 *
 * <<< pico_memory_map.h >>>
 *
 * --- Definitions of types for pico 'pico_typedef'
 *     Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_MEMORY_MAP_H

#define PICO_MEMORY_MAP_H

//const int SYSTEM_STACK_POINTER_INITIAL_VALUE = 0x2a00;
	const int System_Stack_Initial_Address = 0x2a00;

	// pico_integer_unit.cc
enum memory_mapped_address{
		LEFTD0 = 0x3200, 
		LEFTC0 = 0x3202, 
		RIGHTD0 = 0x3204, 
		RIGHTC0 = 0x3206, 
		UPD0 	= 0x3208, 
		UPC0 	= 0x320a, 
		DOWND0	= 0x320c, 
		DOWNC0 = 0x320e, 
		RESULT0 = 0x3210, 
		RESULT_C0 = 0x3212,
		INPUT0 = 0x3214, 
		INPUT_C0 = 0x3216,
		STATUS0 = 0x3218, 
		LEFTD1 = 0x3240, 
		LEFTC1 = 0x3242, 
		RIGHTD1 = 0x3244, 
		RIGHTC1 = 0x3246, 
		UPD1 	= 0x3248, 
		UPC1 	= 0x324a, 
		DOWND1	= 0x324c, 
		DOWNC1 = 0x324e, 
		RESULT1 = 0x3250, 
		RESULT_C1 = 0x3252,
		INPUT1 = 0x3254, 
		INPUT_C1 = 0x3256,
		STATUS1 = 0x3258, 
		TIMER_COUNT =0x32fa,
		TIMER_OP = 0x32fc,
		TIMER_VALUE = 0x32fe,
};
	
	// controler.h pico_integer_unit.cc
enum controler_state{
		BEFORE_INPUT = 0x3214,
		BEFORE_INPUT_CONTROL = 0x3216,
		RESULT = 0x3210,
		RESULT_CONTROL = 0x3212,
		UP_SEND_DATA = 0x3208,
		DOWN_SEND_DATA = 0x320c,
		RIGHT_SEND_DATA = 0x3204,
		LEFT_SEND_DATA = 0x3200,
		UP_SEND_STATUS = 0x320a,
		DOWN_SEND_STATUS = 0x320e,
		RIGHT_SEND_STATUS = 0x3206,
		LEFT_SEND_STATUS = 0x3202,
		UP_RECEIVE_DATA = 10,
		DOWN_RECEIVE_DATA = 11,
		RIGHT_RECEIVE_DATA = 12,
		LEFT_RECEIVE_DATA = 13,
		UP_RECEIVE_STATUS = 14,
		DOWN_RECEIVE_STATUS = 15,
		RIGHT_RECEIVE_STATUS = 16,
		LEFT_RECEIVE_STATUS = 17,
		TRANSMIT_STATUS = 0x3218,
		READY = 19,
		TIMER_S_COUNT =0x32fa,
		TIMER_S_OP = 0x32fc,
		TIMER_S_VALUE = 0x32fe,
};
#endif
