/*
 * <<< pico_instruction_test.cc >>>
 *
 * --- Test program for pico_instruction class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <fstream>
#include <iostream>
#include <iomanip>
#include <map>
#include <isis/memory_map.h>
#include "pico_typedef.h"
#include "pico_instruction.h"

//#define DEBUG
//#define MEM_DUMP

static unsigned int string_hex_to_unsigned_int(const string&);
static int loader(istream&);

int main(int argc, char** argv)
{
	typedef pico_word word_type;
	const size_t sizeof_word_type = sizeof_pico_word;
	const int PRO_SIZE = 0x0020;

	if (argc == 1) return 1;
	ifstream file;
#ifdef MEM_DUMP
	ofstream result;
#endif //MEM_DUMP
	mapped_memory<word_type> mem;
	memory_map<word_type> mem_map;
//	mapped_memory<short> mem;
//	memory_map<short> mem_map;
	mem.set_top(0);
//	mem.resize(0x20000000);
	mem.resize(0x1000);
	mem_map.insert(mem);


/*
	typedef mem::char_type char_type;
	typedef mem::address_type address_type;
	typedef mem::size_type size_type;
*/

	file.open(argv[1], ios::in | ios::nocreate);

#ifdef MEM_DUMP
	result.open("result", ios::out);
#endif //MEM_DUMP

	// load program to the memory
/*
	if (file.bad()) return 1;
	obj_file.load_header(file);
	if (!obj_file.is_valid()) return 1;
	obj_file.load_body_to_memory(file, mem_map);
	word_type base = obj_file.entry_point();
*/
	word_type base = 00000000;
	
	//loader(file);
	//load_body_to_memory(file, mem_map);

	typedef word_type char_type;

	word_type i = 0;
	const size_t buf_size = 1024;
	word_type buf[buf_size];
	word_type adr;

	adr = 00000000;
	for(i = 0 ; i < PRO_SIZE; i += sizeof_word_type){
		buf[i] = loader(file);
//		cout << "Read " << setw(8) << buf[i] << endl;
	}
	
//	file.read(buf, sizeof(buf));
//	mem_map.write_char(adr, buf[i]);

	for(i = 0; i < PRO_SIZE; i += sizeof_word_type){
		mem_map.write(adr + i, buf[i]);
	}

	word_type dat;
#ifdef MEM_DUMP
	mem_map.dump(result);
#endif //MEMDUMP
	/*
	for(i = 0; i < PRO_SIZE; i += sizeof_word_type){
		dat = mem_map.read(adr + i);
		//cout << "Test " << setw(8) << adr + i << " "  << setw(8) << dat << endl;
	}
*/
	cout << hex << setfill('0');
	for (word_type offset = 0; offset < PRO_SIZE; offset += sizeof_word_type) {
		word_type adr = base + offset, dat;
		dat = mem_map.read(adr);
		//dat = loader(file);
		pico_instruction inst;
		inst.set(adr, dat);
		cout << setw(8) << adr << ": " << setw(8) << dat << ": ";
		if (inst.is_r_type()) {
			cout << "r - ";
		} else if (inst.is_i_type()) {
			cout << "i - ";
		} else if (inst.is_j_type()) {
			cout << "j - ";
		} else if (inst.is_s_type()) {
			cout << "s - ";
		} else {
			cout << "o - ";
		}
		cout << inst << endl;
	}
	return 0;
}


unsigned int string_hex_to_unsigned_int(const string& a)
{
	unsigned int value = 0;
	for (size_t i = 0; i < a.size(); i++) {
		const char c = a[i];
		int t;
		switch (c) {
		case '0': t =  0; break;
		case '1': t =  1; break;
		case '2': t =  2; break;
		case '3': t =  3; break;
		case '4': t =  4; break;
		case '5': t =  5; break;
		case '6': t =  6; break;
		case '7': t =  7; break;
		case '8': t =  8; break;
		case '9': t =  9; break;
		case 'a': t = 10; break;
		case 'A': t = 10; break;
		case 'b': t = 11; break;
		case 'B': t = 11; break;
		case 'c': t = 12; break;
		case 'C': t = 12; break;
		case 'd': t = 13; break;
		case 'D': t = 13; break;
		case 'e': t = 14; break;
		case 'E': t = 14; break;
		case 'f': t = 15; break;
		case 'F': t = 15; break;
		default:  t =  0; break;
		}
		value = (value << 4) + t;
	}
	return value;
}

int loader(istream& file)
{
	while (1) {
		char c;

		if (!file){
			break;
		}

		if (!(file >> c)){
			break;
		}

		if (c == '@') {
			unsigned int adr, c0, c1;
			string adr_str, c0_str, c1_str, tmp;
			file >> adr_str >> c0_str >> c1_str;
			adr = string_hex_to_unsigned_int(adr_str);
			c0 = string_hex_to_unsigned_int(c0_str);
//			c1 = string_hex_to_unsigned_int(c1_str);

			// check
#ifdef DEBUG
			cout << "adr:" << adr
			 << " (" << c0 << ',' << c1 << ')' << endl;
#endif //DEBUG

//			return (c0 << 8 + c1);
			//return (c0 << 8) + c1;
			return c0;
		}
		while (1) {
			if (!file || !file.get(c)) break;
			if (c == '\n') break;
		}
	}

	return 0;
}

