/* -*- C++ -*-
 *
 * <<< input_unit.h >>>
 *
 * --- input unit class 'input unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */


#ifndef VISION_INPUT_UNIT_H
#define VISION_INPUT_UNIT_H 1

#include <iostream>
#include "pico_typedef.h"
#include "vision_port.h"
#include "vision_packet.h"


class vision_input_unit
{
private:
	typedef vision_input_unit thisclass;
	typedef pico_word data_type;
	typedef pico_word address_type;
	typedef data_type D;

	int count_, output_count_;
	bool receive_status_, input_decode0_, input_decode1_;
	bool load_, update_enable_, input_status_;
	data_type data_buffer_;
	static const int BUFFER_SIZE = 36;
	data_type input_data_[BUFFER_SIZE];
	data_type output_data_[BUFFER_SIZE];

	enum state_type{
		WAIT,
		LOAD,
		SHIFT,
		PRE_SHIFT
	};

	state_type state;

	/* port */
	vision_port Data_Input;

	/* packet */
	packet* Data_pkt;


public:
	vision_input_unit();
	vision_input_unit(thisclass&);
	~vision_input_unit();

	data_type& data_buffer(void) { return data_buffer_; }
	bool& receive_status(void) { return receive_status_; }
	int input_status(void) { return (input_status_ == true)? 1 : 0; }
	bool& decode0(void) { return input_decode0_; }
	bool& decode1(void) { return input_decode1_; }

	/* Port Connection */
	vision_port& Data_Input_Port(){ return Data_Input; }
        void put(D data) { input_data_[count_++] = data; }

	void reset(void);
	void clock_in(void);
	void clock_out(void);

};

#endif // VISION_INPUT_UNIT_H
