/* -*- C++ -*-
 *
 * <<< input_unit.cc >>>
 *
 * --- input unit class 'input unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "input_unit.h"

//#define DEBUG 1

void vision_input_unit::clock_in(void)
{

	switch(state){
	
	case WAIT:
		#ifdef DEBUG
			cout << "INPUT WAIT" << endl;
		#endif

		if(count_ == (BUFFER_SIZE - 1)){ 
			update_enable_ = false;
			state = LOAD;
		}
		
		break;

	case LOAD:
		#ifdef DEBUG
			cout << "INPUT LOAD" << endl;
		#endif

		output_count_ = 0;

		while(count_ >= 0){
			output_data_[count_] = input_data_[count_];
			count_--;
		}
		count_ = 0;
		
		input_status_ = true;
		load_ = false;
		update_enable_ = true;

		state = PRE_SHIFT;

		break;

	case SHIFT:
		#ifdef DEBUG
			cout << "INPUT SHIFT" << endl;
		#endif
		update_enable_ = true;

		state = PRE_SHIFT;
			
		break;

	case PRE_SHIFT:
		#ifdef DEBUG
			cout << "INPUT PRE_SHIFT" << endl;
		#endif

		if(input_decode0_ == false){
			input_decode0_ = true;
			//data_buffer_ = output_data_[output_count_];
			output_count_++;

			state = SHIFT;
		}

		if(input_decode1_ == false){
			input_decode1_ = true;

			input_status_ = false;
			load_ = false;

			state = WAIT;
		}

		break;

	default:
		break;
	}

	if(output_count_ < BUFFER_SIZE){
		data_buffer_ = output_data_[output_count_];
	}

}

void vision_input_unit::clock_out(void)
{

	if(Data_Input.have_packet()){
		Data_pkt = Data_Input.get();
		input_data_[count_] = ((vision_packet<D>*)(Data_pkt)) -> data();
		#ifdef DEBUG
		cout << "INPUT Receive Packet num : " << dec << count_ << 
			" Data : " << input_data_[count_] << endl;
		#endif
		count_++;
		delete Data_pkt;
	}

}

void vision_input_unit::reset(void)
{
	state = WAIT;
	count_ = 0;
	output_count_ = BUFFER_SIZE;
}

vision_input_unit::vision_input_unit(void)
	:count_(0),
	 output_count_(BUFFER_SIZE),
	 input_status_(false),
	 load_(true),
	 update_enable_(true),
	 input_decode0_(true),
	 input_decode1_(true),
	 state(WAIT)
{

}

vision_input_unit::vision_input_unit(thisclass& a)
	:count_(0),
	 output_count_(BUFFER_SIZE),
	 input_status_(false),
	 load_(true),
	 update_enable_(true),
	 input_decode0_(true),
	 input_decode1_(true),
	 state(WAIT)
{


}

vision_input_unit::~vision_input_unit()
{

}

