/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module updt_core(CLK, RST,
                 UWE, UDADR,UDDIN,
                 REQ,
                 HOLD,
                 DIN,
                 DOUT);

   input  CLK, RST;

   input [1:0]  UWE;
   input [10:0] UDADR;
   input [31:0] UDDIN;
   
   input        REQ;
   input  [31:0] DIN;
   output [31:0] DOUT;
   output       HOLD;
   reg          HOLD;
   
   wire        idx_wea;
   wire [9:0]  idx_addra, idx_addrb;
   wire [17:0] idx_dina;
   wire [17:0] idx_doutb;

   wire        dat_wea;
   wire [10:0] dat_addra, dat_addrb;
   wire [31:0] dat_dina;
   wire [31:0] dat_doutb;

   reg [6:0]   RNUM;
   reg [1:0]   STATE;
   reg [10:0]  DADDR;
   
   reg           RE_OUT;
   reg           NM_OUT;
   reg           SFLAG;

   assign        idx_wea   = (UWE == 2'b01) ? `WRITE : `READ;
   assign        idx_addra = UDADR[9:0];
   assign        idx_dina  = UDDIN[17:0];

   assign        idx_addrb = DIN[9:0];

   assign        dat_wea   = (UWE == 2'b10) ? `WRITE : `READ;
   assign        dat_addra = UDADR;
   assign        dat_dina  = UDDIN;

   assign        dat_addrb = (STATE == 2'b01) ? idx_doutb[10:0] : 
                                                DADDR;

   assign        DOUT = (STATE == 2'b01) ? {25'b0, idx_doutb[17:11]} : dat_doutb;

   always@(posedge CLK) begin
      if(RST) begin
         HOLD <= `DISABLE;
         STATE  <= 2'b00;
      end
      else begin
         casex(STATE)
           2'b00 : begin
              if(REQ) begin
                 HOLD  <= `ENABLE;
                 STATE <= 2'b01;
              end
           end
           2'b01 : begin
              RNUM  <= idx_doutb[17:11] - 1;
              DADDR <= idx_doutb[10:0] + 1;
              STATE <= 2'b10;
           end
           2'b10 : begin
              if(|RNUM) begin
                 DADDR <= DADDR + 1;
                 RNUM  <= RNUM - 1;
              end
              else begin
                 HOLD <= `DISABLE;
                 STATE <= 2'b00;
              end
           end
         endcase
      end
   end

   sdpram18x10 idx(.clka(CLK), .clkb(CLK),
                   .wea(idx_wea),
                   .addra(idx_addra),
                   .addrb(idx_addrb),
                   .dina(idx_dina),
                   .doutb(idx_doutb));

   sdpram32x11 dat(.clka(CLK), .clkb(CLK),
                   .wea(dat_wea),
                   .addra(dat_addra),
                   .addrb(dat_addrb),
                   .dina(dat_dina),
                   .doutb(dat_doutb));

endmodule // dgtb
