/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module cni_updt(CLK, RST,
                IREQ, IRDY, DIN,
                AWE, ADDR,
                REQ, ACK, DOUT
                );

   input CLK, RST;

   input  [1:0] IREQ;
   output       IRDY;
   input [31:0] DIN;

   output       AWE;
   output [19:0] ADDR;

   output REQ;
   input  ACK;
   output [31:0] DOUT;

   reg           STATE;

   reg [31:0]    DATA;
   
   reg    PFLAG; // Pre calculation

   assign IRDY = ~PFLAG | ACK;
//   assign AWE  = ((IREQ == 2'b01 & IRDY) | STATE) ? `WRITE : `READ;
   assign AWE  = (IREQ == 2'b01 & IRDY) ? `WRITE : `READ;
   assign ADDR = DIN[19:0];

   assign REQ  = (AWE | STATE | PFLAG) & ~ACK;
   assign DOUT = (ACK & STATE) ? DIN : DATA;

   always@(posedge CLK) begin
      if(RST) begin
         STATE <= 1'b0;
         PFLAG <= `DISABLE;
         DATA  <= 32'b0;
      end
      else begin
         if(~STATE) begin
            if((IREQ == 2'b01) & (~PFLAG | (PFLAG & ACK))) STATE <= 1'b1;
            if(PFLAG & ACK) PFLAG <= `DISABLE;
         end
         else begin
            STATE <= 1'b0;
            if(~ACK) PFLAG <= `ENABLE;
         end
         if(STATE) DATA <= DIN;
      end
   end

endmodule // cni
