/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
`include "nrm.vh"

module nrm8(CLK, RST,
           SET, SADDR, SDIN, 
           MRE, MDOUT,
           NID, DU,
           START);
   
   input          CLK, RST;

   input [5:0]    SET;
   input [7:0]    NID;
   input          START;

   input [10:0]   SADDR;
   input [31:0]   SDIN;
   input [1:0]    DU;

   input          MRE;
   output [31:0]  MDOUT;

   // DUNIT001
   wire [5:0]     SET001;
   wire           MRE001, START001;
   wire [31:0]    MDOUT001, DIN001, DOUT001;
   wire [1:0]     IREQ001, OREQ001;
   wire           IRDY001, ORDY001;
   // DUNIT002
   wire [5:0]     SET002;
   wire           MRE002, START002;
   wire [31:0]    MDOUT002, DIN002, DOUT002;
   wire [1:0]     IREQ002, OREQ002;
   wire           IRDY002, ORDY002;
   // DUNIT003
   wire [5:0]     SET003;
   wire           MRE003, START003;
   wire [31:0]    MDOUT003, DIN003, DOUT003;
   wire [1:0]     IREQ003, OREQ003;
   wire           IRDY003, ORDY003;
   // DUNIT004
   wire [5:0]     SET004;
   wire           MRE004, START004;
   wire [31:0]    MDOUT004, DIN004, DOUT004;
   wire [1:0]     IREQ004, OREQ004;
   wire           IRDY004, ORDY004;
   // DUNIT005
   wire [5:0]     SET005;
   wire           MRE005, START005;
   wire [31:0]    MDOUT005, DIN005, DOUT005;
   wire [1:0]     IREQ005, OREQ005;
   wire           IRDY005, ORDY005;
   // DUNIT006
   wire [5:0]     SET006;
   wire           MRE006, START006;
   wire [31:0]    MDOUT006, DIN006, DOUT006;
   wire [1:0]     IREQ006, OREQ006;
   wire           IRDY006, ORDY006;
   // DUNIT007
   wire [5:0]     SET007;
   wire           MRE007, START007;
   wire [31:0]    MDOUT007, DIN007, DOUT007;
   wire [1:0]     IREQ007, OREQ007;
   wire           IRDY007, ORDY007;
   // DUNIT008
   wire [5:0]     SET008;
   wire           MRE008, START008;
   wire [31:0]    MDOUT008, DIN008, DOUT008;
   wire [1:0]     IREQ008, OREQ008;
   wire           IRDY008, ORDY008;

   // UPDT800
   wire [5:0]  SET800;
   wire [1:0]  IREQ800;
   wire        IRDY800;
   wire [31:0] DIN800;

   wire [1:0]  OREQ800;
   wire        ORDY800;
   wire [31:0] DOUT800;

   // DGTB700
   wire [5:0]  SET700;
   wire [1:0]  IREQ700;
   wire        IRDY700;
   wire [31:0] DIN700;

   wire [1:0]  OREQ700;
   wire        ORDY700;
   wire [31:0] DOUT700;

   // PCAL500
   wire [5:0]  SET500;
   wire [1:0]  IREQ500;
   wire        IRDY500;
   wire [31:0] DIN500;

   wire [1:0]  OREQ500;
   wire        ORDY500;
   wire [31:0] DOUT500;

   // TCAL400
   wire [5:0]  SET400;
   wire [1:0]  IREQ400;
   wire        IRDY400;
   wire [31:0] DIN400;

   wire [1:0]  OREQ400;
   wire        ORDY400;
   wire [31:0] DOUT400;

   // TMOD300
   wire [1:0]  IREQ300;
   wire        IRDY300;
   wire [31:0] DIN300;

   wire [1:0]  OREQ300;
   wire        ORDY300;
   wire [31:0] DOUT300;

   // DEMUX001
   wire [31:0] DMO001, DMO002, DMO003, DMO004;
   wire [31:0] DMO005, DMO006, DMO007, DMO008;

   wire [31:0] DMO800, DMO700, DMO500, DMO400, DMO300;
   
   // UPDT800
   assign      SET800 = (NID == 8'd80) ? SET : 6'b0;

   cunit_updt updt800(.CLK(CLK),
                      .UWE(SET800[1:0]), .UDADR(SADDR), .UDDIN(SDIN),
                      .IREQ0(IREQ800), .IRDY0(IRDY800), .DIN0(DIN800),
                      .OREQ0(OREQ800), .ORDY0(ORDY800), .DOUT0(DOUT800),
                      .RST(RST));


   // DGTB700
   assign      SET700 = (NID == 8'd70) ? SET : 6'b0;

   cunit_dgtb dgtb700(.CLK(CLK),
                      .DGWE(SET700[0]), .DGDIN(SDIN),
                      .IREQ0(IREQ700), .IRDY0(IRDY700), .DIN0(DIN700),
                      .OREQ0(OREQ700), .ORDY0(ORDY700), .DOUT0(DOUT700),
                      .RST(RST));

   // PCAL500
   assign      SET500 = (NID == 8'd50) ? SET : 6'b0;

   cunit_pcal pcal500(.CLK(CLK),
                      .RCWE(SET500[0]), .RCADR(SADDR[9:0]), .RCDIN(SDIN),
                      .IREQ0(IREQ500), .IRDY0(IRDY500), .DIN0(DIN500),
                      .OREQ0(OREQ500), .ORDY0(ORDY500), .DOUT0(DOUT500),
                      .RST(RST));

   // TCAL400
   assign      SET400 = (NID == 8'd40) ? SET : 6'b0;

   cunit_tcal tcal400(.CLK(CLK),
                     .SET(SET400[0]), .RNDIN(SDIN),
                      .IREQ0(IREQ400), .IRDY0(IRDY400), .DIN0(DIN400),
                      .OREQ0(OREQ400), .ORDY0(ORDY400), .DOUT0(DOUT400),
                      .RST(RST));
   // TMOD300

   cunit_tmod tmod300(.CLK(CLK), 
                      .IREQ0(IREQ300), .IRDY0(IRDY300), .DIN0(DIN300),
                      .OREQ0(OREQ300), .ORDY0(ORDY300), .DOUT0(DOUT300),
                      .RST(RST));

   // ============================================================================
   wire [1:0]  OREQ801, OREQ802, OREQ803, OREQ804, OREQ805, OREQ806, OREQ807, OREQ808;
   wire [1:0]  OREQ701, OREQ702, OREQ703, OREQ704, OREQ705, OREQ706, OREQ707, OREQ708;
   wire [1:0]  OREQ501, OREQ502, OREQ503, OREQ504, OREQ505, OREQ506, OREQ507, OREQ508;
   wire [1:0]  OREQ401, OREQ402, OREQ403, OREQ404, OREQ405, OREQ406, OREQ407, OREQ408;
   wire [1:0]  OREQ301, OREQ302, OREQ303, OREQ304, OREQ305, OREQ306, OREQ307, OREQ308;

   wire  ORDY801, ORDY802, ORDY803, ORDY804, ORDY805, ORDY806, ORDY807, ORDY808;
   wire  ORDY701, ORDY702, ORDY703, ORDY704, ORDY705, ORDY706, ORDY707, ORDY708;
   wire  ORDY501, ORDY502, ORDY503, ORDY504, ORDY505, ORDY506, ORDY507, ORDY508;
   wire  ORDY401, ORDY402, ORDY403, ORDY404, ORDY405, ORDY406, ORDY407, ORDY408;
   wire  ORDY301, ORDY302, ORDY303, ORDY304, ORDY305, ORDY306, ORDY307, ORDY308;

   wire [31:0]  DOUT801, DOUT802, DOUT803, DOUT804, DOUT805, DOUT806, DOUT807, DOUT808;
   wire [31:0]  DOUT701, DOUT702, DOUT703, DOUT704, DOUT705, DOUT706, DOUT707, DOUT708;
   wire [31:0]  DOUT501, DOUT502, DOUT503, DOUT504, DOUT505, DOUT506, DOUT507, DOUT508;
   wire [31:0]  DOUT401, DOUT402, DOUT403, DOUT404, DOUT405, DOUT406, DOUT407, DOUT408;
   wire [31:0]  DOUT301, DOUT302, DOUT303, DOUT304, DOUT305, DOUT306, DOUT307, DOUT308;

   wire [1:0]  IREQ801, IREQ802, IREQ803, IREQ804, IREQ805, IREQ806, IREQ807, IREQ808;
   wire [1:0]  IREQ701, IREQ702, IREQ703, IREQ704, IREQ705, IREQ706, IREQ707, IREQ708;
   wire [1:0]  IREQ501, IREQ502, IREQ503, IREQ504, IREQ505, IREQ506, IREQ507, IREQ508;
   wire [1:0]  IREQ401, IREQ402, IREQ403, IREQ404, IREQ405, IREQ406, IREQ407, IREQ408;
   wire [1:0]  IREQ301, IREQ302, IREQ303, IREQ304, IREQ305, IREQ306, IREQ307, IREQ308;
   wire [1:0]  IREQ201, IREQ202, IREQ203, IREQ204, IREQ205, IREQ206, IREQ207, IREQ208;

   wire  IRDY801, IRDY802, IRDY803, IRDY804, IRDY805, IRDY806, IRDY807, IRDY808;
   wire  IRDY701, IRDY702, IRDY703, IRDY704, IRDY705, IRDY706, IRDY707, IRDY708;
   wire  IRDY501, IRDY502, IRDY503, IRDY504, IRDY505, IRDY506, IRDY507, IRDY508;
   wire  IRDY401, IRDY402, IRDY403, IRDY404, IRDY405, IRDY406, IRDY407, IRDY408;
   wire  IRDY301, IRDY302, IRDY303, IRDY304, IRDY305, IRDY306, IRDY307, IRDY308;
   wire  IRDY201, IRDY202, IRDY203, IRDY204, IRDY205, IRDY206, IRDY207, IRDY208;

   bus8   bus801(.CLK(CLK),
                 .IREQ0(IREQ801), .IRDY0(IRDY801), .DIN0(DMO001),
                 .IREQ1(IREQ802), .IRDY1(IRDY802), .DIN1(DMO002),
                 .IREQ2(IREQ803), .IRDY2(IRDY803), .DIN2(DMO003),
                 .IREQ3(IREQ804), .IRDY3(IRDY804), .DIN3(DMO004),
                 .IREQ4(IREQ805), .IRDY4(IRDY805), .DIN4(DMO005),
                 .IREQ5(IREQ806), .IRDY5(IRDY806), .DIN5(DMO006),
                 .IREQ6(IREQ807), .IRDY6(IRDY807), .DIN6(DMO007),
                 .IREQ7(IREQ808), .IRDY7(IRDY808), .DIN7(DMO008),
                 .OREQ(IREQ800),  .ORDY(IRDY800),  .DOUT(DIN800),
                 .RST(RST));

   bus8   bus701(.CLK(CLK),
                 .IREQ0(IREQ701), .IRDY0(IRDY701), .DIN0(DMO001),
                 .IREQ1(IREQ702), .IRDY1(IRDY702), .DIN1(DMO002),
                 .IREQ2(IREQ703), .IRDY2(IRDY703), .DIN2(DMO003),
                 .IREQ3(IREQ704), .IRDY3(IRDY704), .DIN3(DMO004),
                 .IREQ4(IREQ705), .IRDY4(IRDY705), .DIN4(DMO005),
                 .IREQ5(IREQ706), .IRDY5(IRDY706), .DIN5(DMO006),
                 .IREQ6(IREQ707), .IRDY6(IRDY707), .DIN6(DMO007),
                 .IREQ7(IREQ708), .IRDY7(IRDY708), .DIN7(DMO008),
                 .OREQ(IREQ700),  .ORDY(IRDY700),  .DOUT(DIN700),
                 .RST(RST));

   bus8   bus501(.CLK(CLK),
                 .IREQ0(IREQ501), .IRDY0(IRDY501), .DIN0(DMO001),
                 .IREQ1(IREQ502), .IRDY1(IRDY502), .DIN1(DMO002),
                 .IREQ2(IREQ503), .IRDY2(IRDY503), .DIN2(DMO003),
                 .IREQ3(IREQ504), .IRDY3(IRDY504), .DIN3(DMO004),
                 .IREQ4(IREQ505), .IRDY4(IRDY505), .DIN4(DMO005),
                 .IREQ5(IREQ506), .IRDY5(IRDY506), .DIN5(DMO006),
                 .IREQ6(IREQ507), .IRDY6(IRDY507), .DIN6(DMO007),
                 .IREQ7(IREQ508), .IRDY7(IRDY508), .DIN7(DMO008),
                 .OREQ(IREQ500),  .ORDY(IRDY500),  .DOUT(DIN500),
                 .RST(RST));

   bus8   bus401(.CLK(CLK),
                 .IREQ0(IREQ401), .IRDY0(IRDY401), .DIN0(DMO001),
                 .IREQ1(IREQ402), .IRDY1(IRDY402), .DIN1(DMO002),
                 .IREQ2(IREQ403), .IRDY2(IRDY403), .DIN2(DMO003),
                 .IREQ3(IREQ404), .IRDY3(IRDY404), .DIN3(DMO004),
                 .IREQ4(IREQ405), .IRDY4(IRDY405), .DIN4(DMO005),
                 .IREQ5(IREQ406), .IRDY5(IRDY406), .DIN5(DMO006),
                 .IREQ6(IREQ407), .IRDY6(IRDY407), .DIN6(DMO007),
                 .IREQ7(IREQ408), .IRDY7(IRDY408), .DIN7(DMO008),
                 .OREQ(IREQ400),  .ORDY(IRDY400),  .DOUT(DIN400),
                 .RST(RST));

   bus8   bus301(.CLK(CLK),
                 .IREQ0(IREQ301), .IRDY0(IRDY301), .DIN0(DMO001),
                 .IREQ1(IREQ302), .IRDY1(IRDY302), .DIN1(DMO002),
                 .IREQ2(IREQ303), .IRDY2(IRDY303), .DIN2(DMO003),
                 .IREQ3(IREQ304), .IRDY3(IRDY304), .DIN3(DMO004),
                 .IREQ4(IREQ305), .IRDY4(IRDY305), .DIN4(DMO005),
                 .IREQ5(IREQ306), .IRDY5(IRDY306), .DIN5(DMO006),
                 .IREQ6(IREQ307), .IRDY6(IRDY307), .DIN6(DMO007),
                 .IREQ7(IREQ308), .IRDY7(IRDY308), .DIN7(DMO008),
                 .OREQ(IREQ300),  .ORDY(IRDY300),  .DOUT(DIN300),
                 .RST(RST));


   
   demux8 demux801(.CLK(CLK),
                   .IREQ(OREQ800), .IRDY(ORDY800), .DIN(DOUT800), .DOUT(DMO800),
                   .OREQ0(OREQ801), .ORDY0(ORDY801),
                   .OREQ1(OREQ802), .ORDY1(ORDY802),
                   .OREQ2(OREQ803), .ORDY2(ORDY803),
                   .OREQ3(OREQ804), .ORDY3(ORDY804),
                   .OREQ4(OREQ805), .ORDY4(ORDY805),
                   .OREQ5(OREQ806), .ORDY5(ORDY806),
                   .OREQ6(OREQ807), .ORDY6(ORDY807),
                   .OREQ7(OREQ808), .ORDY7(ORDY808),
                   .RST(RST));

   demux8 demux701(.CLK(CLK),
                   .IREQ(OREQ700), .IRDY(ORDY700), .DIN(DOUT700), .DOUT(DMO700),
                   .OREQ0(OREQ701), .ORDY0(ORDY701),
                   .OREQ1(OREQ702), .ORDY1(ORDY702),
                   .OREQ2(OREQ703), .ORDY2(ORDY703),
                   .OREQ3(OREQ704), .ORDY3(ORDY704),
                   .OREQ4(OREQ705), .ORDY4(ORDY705),
                   .OREQ5(OREQ706), .ORDY5(ORDY706),
                   .OREQ6(OREQ707), .ORDY6(ORDY707),
                   .OREQ7(OREQ708), .ORDY7(ORDY708),
                   .RST(RST));

   demux8 demux501(.CLK(CLK),
                   .IREQ(OREQ500), .IRDY(ORDY500), .DIN(DOUT500), .DOUT(DMO500),
                   .OREQ0(OREQ501), .ORDY0(ORDY501),
                   .OREQ1(OREQ502), .ORDY1(ORDY502),
                   .OREQ2(OREQ503), .ORDY2(ORDY503),
                   .OREQ3(OREQ504), .ORDY3(ORDY504),
                   .OREQ4(OREQ505), .ORDY4(ORDY505),
                   .OREQ5(OREQ506), .ORDY5(ORDY506),
                   .OREQ6(OREQ507), .ORDY6(ORDY507),
                   .OREQ7(OREQ508), .ORDY7(ORDY508),
                   .RST(RST));

   demux8 demux401(.CLK(CLK),
                   .IREQ(OREQ400), .IRDY(ORDY400), .DIN(DOUT400), .DOUT(DMO400),
                   .OREQ0(OREQ401), .ORDY0(ORDY401),
                   .OREQ1(OREQ402), .ORDY1(ORDY402),
                   .OREQ2(OREQ403), .ORDY2(ORDY403),
                   .OREQ3(OREQ404), .ORDY3(ORDY404),
                   .OREQ4(OREQ405), .ORDY4(ORDY405),
                   .OREQ5(OREQ406), .ORDY5(ORDY406),
                   .OREQ6(OREQ407), .ORDY6(ORDY407),
                   .OREQ7(OREQ408), .ORDY7(ORDY408),
                   .RST(RST));

   demux8 demux301(.CLK(CLK),
                   .IREQ(OREQ300), .IRDY(ORDY300), .DIN(DOUT300), .DOUT(DMO300),
                   .OREQ0(OREQ301), .ORDY0(ORDY301),
                   .OREQ1(OREQ302), .ORDY1(ORDY302),
                   .OREQ2(OREQ303), .ORDY2(ORDY303),
                   .OREQ3(OREQ304), .ORDY3(ORDY304),
                   .OREQ4(OREQ305), .ORDY4(ORDY305),
                   .OREQ5(OREQ306), .ORDY5(ORDY306),
                   .OREQ6(OREQ307), .ORDY6(ORDY307),
                   .OREQ7(OREQ308), .ORDY7(ORDY308),
                   .RST(RST));
   
   // ============================================================================

   demux6 demux001(.CLK(CLK),
                   .IREQ(OREQ001), .IRDY(ORDY001), .DIN(DOUT001), .DOUT(DMO001),
                   .OREQ0(IREQ801), .ORDY0(IRDY801),
                   .OREQ1(IREQ701), .ORDY1(IRDY701),
                   .OREQ2(IREQ501), .ORDY2(IRDY501),
                   .OREQ3(IREQ401), .ORDY3(IRDY401),
                   .OREQ4(IREQ301), .ORDY4(IRDY301),
                   .OREQ5(IREQ201), .ORDY5(IRDY201),
                   .RST(RST));

   bus6   bus001(.CLK(CLK),
                 .IREQ0(OREQ801), .IRDY0(ORDY801), .DIN0(DMO800),
                 .IREQ1(OREQ701), .IRDY1(ORDY701), .DIN1(DMO700),
                 .IREQ2(OREQ501), .IRDY2(ORDY501), .DIN2(DMO500),
                 .IREQ3(OREQ401), .IRDY3(ORDY401), .DIN3(DMO400),
                 .IREQ4(OREQ301), .IRDY4(ORDY301), .DIN4(DMO300),
                 .IREQ5(IREQ201), .IRDY5(IRDY201), .DIN5(DMO001),
                 .OREQ(IREQ001),  .ORDY(IRDY001),  .DOUT(DIN001),
                 .RST(RST));

   // ============================================================================

   demux6 demux002(.CLK(CLK),
                   .IREQ(OREQ002), .IRDY(ORDY002), .DIN(DOUT002), .DOUT(DMO002),
                   .OREQ0(IREQ802), .ORDY0(IRDY802),
                   .OREQ1(IREQ702), .ORDY1(IRDY702),
                   .OREQ2(IREQ502), .ORDY2(IRDY502),
                   .OREQ3(IREQ402), .ORDY3(IRDY402),
                   .OREQ4(IREQ302), .ORDY4(IRDY302),
                   .OREQ5(IREQ202), .ORDY5(IRDY202),
                   .RST(RST));

   bus6   bus002(.CLK(CLK),
                 .IREQ0(OREQ802), .IRDY0(ORDY802), .DIN0(DMO800),
                 .IREQ1(OREQ702), .IRDY1(ORDY702), .DIN1(DMO700),
                 .IREQ2(OREQ502), .IRDY2(ORDY502), .DIN2(DMO500),
                 .IREQ3(OREQ402), .IRDY3(ORDY402), .DIN3(DMO400),
                 .IREQ4(OREQ302), .IRDY4(ORDY302), .DIN4(DMO300),
                 .IREQ5(IREQ202), .IRDY5(IRDY202), .DIN5(DMO002),
                 .OREQ(IREQ002),  .ORDY(IRDY002),  .DOUT(DIN002),
                 .RST(RST));

   // ============================================================================

   demux6 demux003(.CLK(CLK),
                   .IREQ(OREQ003), .IRDY(ORDY003), .DIN(DOUT003), .DOUT(DMO003),
                   .OREQ0(IREQ803), .ORDY0(IRDY803),
                   .OREQ1(IREQ703), .ORDY1(IRDY703),
                   .OREQ2(IREQ503), .ORDY2(IRDY503),
                   .OREQ3(IREQ403), .ORDY3(IRDY403),
                   .OREQ4(IREQ303), .ORDY4(IRDY303),
                   .OREQ5(IREQ203), .ORDY5(IRDY203),
                   .RST(RST));

   bus6   bus003(.CLK(CLK),
                 .IREQ0(OREQ803), .IRDY0(ORDY803), .DIN0(DMO800),
                 .IREQ1(OREQ703), .IRDY1(ORDY703), .DIN1(DMO700),
                 .IREQ2(OREQ503), .IRDY2(ORDY503), .DIN2(DMO500),
                 .IREQ3(OREQ403), .IRDY3(ORDY403), .DIN3(DMO400),
                 .IREQ4(OREQ303), .IRDY4(ORDY303), .DIN4(DMO300),
                 .IREQ5(IREQ203), .IRDY5(IRDY203), .DIN5(DMO003),
                 .OREQ(IREQ003),  .ORDY(IRDY003),  .DOUT(DIN003),
                 .RST(RST));

   // ============================================================================

   demux6 demux004(.CLK(CLK),
                   .IREQ(OREQ004), .IRDY(ORDY004), .DIN(DOUT004), .DOUT(DMO004),
                   .OREQ0(IREQ804), .ORDY0(IRDY804),
                   .OREQ1(IREQ704), .ORDY1(IRDY704),
                   .OREQ2(IREQ504), .ORDY2(IRDY504),
                   .OREQ3(IREQ404), .ORDY3(IRDY404),
                   .OREQ4(IREQ304), .ORDY4(IRDY304),
                   .OREQ5(IREQ204), .ORDY5(IRDY204),
                   .RST(RST));

   bus6   bus004(.CLK(CLK),
                 .IREQ0(OREQ804), .IRDY0(ORDY804), .DIN0(DMO800),
                 .IREQ1(OREQ704), .IRDY1(ORDY704), .DIN1(DMO700),
                 .IREQ2(OREQ504), .IRDY2(ORDY504), .DIN2(DMO500),
                 .IREQ3(OREQ404), .IRDY3(ORDY404), .DIN3(DMO400),
                 .IREQ4(OREQ304), .IRDY4(ORDY304), .DIN4(DMO300),
                 .IREQ5(IREQ204), .IRDY5(IRDY204), .DIN5(DMO004),
                 .OREQ(IREQ004),  .ORDY(IRDY004),  .DOUT(DIN004),
                 .RST(RST));

   // ============================================================================

   demux6 demux005(.CLK(CLK),
                   .IREQ(OREQ005), .IRDY(ORDY005), .DIN(DOUT005), .DOUT(DMO005),
                   .OREQ0(IREQ805), .ORDY0(IRDY805),
                   .OREQ1(IREQ705), .ORDY1(IRDY705),
                   .OREQ2(IREQ505), .ORDY2(IRDY505),
                   .OREQ3(IREQ405), .ORDY3(IRDY405),
                   .OREQ4(IREQ305), .ORDY4(IRDY305),
                   .OREQ5(IREQ205), .ORDY5(IRDY205),
                   .RST(RST));

   bus6   bus005(.CLK(CLK),
                 .IREQ0(OREQ805), .IRDY0(ORDY805), .DIN0(DMO800),
                 .IREQ1(OREQ705), .IRDY1(ORDY705), .DIN1(DMO700),
                 .IREQ2(OREQ505), .IRDY2(ORDY505), .DIN2(DMO500),
                 .IREQ3(OREQ405), .IRDY3(ORDY405), .DIN3(DMO400),
                 .IREQ4(OREQ305), .IRDY4(ORDY305), .DIN4(DMO300),
                 .IREQ5(IREQ205), .IRDY5(IRDY205), .DIN5(DMO005),
                 .OREQ(IREQ005),  .ORDY(IRDY005),  .DOUT(DIN005),
                 .RST(RST));

   // ============================================================================

   demux6 demux006(.CLK(CLK),
                   .IREQ(OREQ006), .IRDY(ORDY006), .DIN(DOUT006), .DOUT(DMO006),
                   .OREQ0(IREQ806), .ORDY0(IRDY806),
                   .OREQ1(IREQ706), .ORDY1(IRDY706),
                   .OREQ2(IREQ506), .ORDY2(IRDY506),
                   .OREQ3(IREQ406), .ORDY3(IRDY406),
                   .OREQ4(IREQ306), .ORDY4(IRDY306),
                   .OREQ5(IREQ206), .ORDY5(IRDY206),
                   .RST(RST));

   bus6   bus006(.CLK(CLK),
                 .IREQ0(OREQ806), .IRDY0(ORDY806), .DIN0(DMO800),
                 .IREQ1(OREQ706), .IRDY1(ORDY706), .DIN1(DMO700),
                 .IREQ2(OREQ506), .IRDY2(ORDY506), .DIN2(DMO500),
                 .IREQ3(OREQ406), .IRDY3(ORDY406), .DIN3(DMO400),
                 .IREQ4(OREQ306), .IRDY4(ORDY306), .DIN4(DMO300),
                 .IREQ5(IREQ206), .IRDY5(IRDY206), .DIN5(DMO006),
                 .OREQ(IREQ006),  .ORDY(IRDY006),  .DOUT(DIN006),
                 .RST(RST));


   // ============================================================================

   demux6 demux007(.CLK(CLK),
                   .IREQ(OREQ007), .IRDY(ORDY007), .DIN(DOUT007), .DOUT(DMO007),
                   .OREQ0(IREQ807), .ORDY0(IRDY807),
                   .OREQ1(IREQ707), .ORDY1(IRDY707),
                   .OREQ2(IREQ507), .ORDY2(IRDY507),
                   .OREQ3(IREQ407), .ORDY3(IRDY407),
                   .OREQ4(IREQ307), .ORDY4(IRDY307),
                   .OREQ5(IREQ207), .ORDY5(IRDY207),
                   .RST(RST));

   bus6   bus007(.CLK(CLK),
                 .IREQ0(OREQ807), .IRDY0(ORDY807), .DIN0(DMO800),
                 .IREQ1(OREQ707), .IRDY1(ORDY707), .DIN1(DMO700),
                 .IREQ2(OREQ507), .IRDY2(ORDY507), .DIN2(DMO500),
                 .IREQ3(OREQ407), .IRDY3(ORDY407), .DIN3(DMO400),
                 .IREQ4(OREQ307), .IRDY4(ORDY307), .DIN4(DMO300),
                 .IREQ5(IREQ207), .IRDY5(IRDY207), .DIN5(DMO007),
                 .OREQ(IREQ007),  .ORDY(IRDY007),  .DOUT(DIN007),
                 .RST(RST));


   // ============================================================================

   demux6 demux008(.CLK(CLK),
                   .IREQ(OREQ008), .IRDY(ORDY008), .DIN(DOUT008), .DOUT(DMO008),
                   .OREQ0(IREQ808), .ORDY0(IRDY808),
                   .OREQ1(IREQ708), .ORDY1(IRDY708),
                   .OREQ2(IREQ508), .ORDY2(IRDY508),
                   .OREQ3(IREQ408), .ORDY3(IRDY408),
                   .OREQ4(IREQ308), .ORDY4(IRDY308),
                   .OREQ5(IREQ208), .ORDY5(IRDY208),
                   .RST(RST));

   bus6   bus008(.CLK(CLK),
                 .IREQ0(OREQ808), .IRDY0(ORDY808), .DIN0(DMO800),
                 .IREQ1(OREQ708), .IRDY1(ORDY708), .DIN1(DMO700),
                 .IREQ2(OREQ508), .IRDY2(ORDY508), .DIN2(DMO500),
                 .IREQ3(OREQ408), .IRDY3(ORDY408), .DIN3(DMO400),
                 .IREQ4(OREQ308), .IRDY4(ORDY308), .DIN4(DMO300),
                 .IREQ5(IREQ208), .IRDY5(IRDY208), .DIN5(DMO008),
                 .OREQ(IREQ008),  .ORDY(IRDY008),  .DOUT(DIN008),
                 .RST(RST));
   
   // ============================================================================
   
   assign         SET001   = (NID == 8'd1) ? SET : 6'b0;
   assign         MRE001   = (NID == 8'd1) ? MRE : 6'b0;
   assign         START001 = (NID == 8'd1) ? START : `DISABLE;

   dunit dunit1(.CLK(CLK),
                .SET(SET001), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT001),
                .ID(8'd1), .START(START001),
                .IREQ(IREQ001), .IRDY(IRDY001), .DIN(DIN001),
                .OREQ(OREQ001), .ORDY(ORDY001), .DOUT(DOUT001),
                .RST(RST));
   
// ============================================================================
   
   assign         SET002   = (NID == 8'd2) ? SET : 6'b0;
   assign         MRE002   = (NID == 8'd2) ? MRE : 6'b0;
   assign         START002 = (NID == 8'd2) ? START : `DISABLE;

   dunit dunit2(.CLK(CLK),
                .SET(SET002), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT002),
                .ID(8'd2), .START(START002),
                .IREQ(IREQ002), .IRDY(IRDY002), .DIN(DIN002),
                .OREQ(OREQ002), .ORDY(ORDY002), .DOUT(DOUT002),
                .RST(RST));

// ============================================================================
   
   assign         SET003   = (NID == 8'd3) ? SET : 6'b0;
   assign         MRE003   = (NID == 8'd3) ? MRE : 6'b0;
   assign         START003 = (NID == 8'd3) ? START : `DISABLE;

   dunit dunit3(.CLK(CLK),
                .SET(SET003), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT003),
                .ID(8'd3), .START(START003),
                .IREQ(IREQ003), .IRDY(IRDY003), .DIN(DIN003),
                .OREQ(OREQ003), .ORDY(ORDY003), .DOUT(DOUT003),
                .RST(RST));
   
   // ============================================================================
   
   assign         SET004   = (NID == 8'd4) ? SET : 6'b0;
   assign         MRE004   = (NID == 8'd4) ? MRE : 6'b0;
   assign         START004 = (NID == 8'd4) ? START : `DISABLE;

   dunit dunit4(.CLK(CLK),
                .SET(SET004), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT004),
                .ID(8'd4), .START(START004),
                .IREQ(IREQ004), .IRDY(IRDY004), .DIN(DIN004),
                .OREQ(OREQ004), .ORDY(ORDY004), .DOUT(DOUT004),
                .RST(RST));

   // ============================================================================
   assign         SET005   = (NID == 8'd5) ? SET : 6'b0;
   assign         MRE005   = (NID == 8'd5) ? MRE : 6'b0;
   assign         START005 = (NID == 8'd5) ? START : `DISABLE;

   dunit dunit5(.CLK(CLK),
                .SET(SET005), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT005),
                .ID(8'd5), .START(START005),
                .IREQ(IREQ005), .IRDY(IRDY005), .DIN(DIN005),
                .OREQ(OREQ005), .ORDY(ORDY005), .DOUT(DOUT005),
                .RST(RST));

   // ============================================================================
   assign         SET006   = (NID == 8'd6) ? SET : 6'b0;
   assign         MRE006   = (NID == 8'd6) ? MRE : 6'b0;
   assign         START006 = (NID == 8'd6) ? START : `DISABLE;

   dunit dunit6(.CLK(CLK),
                .SET(SET006), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT006),
                .ID(8'd6), .START(START006),
                .IREQ(IREQ006), .IRDY(IRDY006), .DIN(DIN006),
                .OREQ(OREQ006), .ORDY(ORDY006), .DOUT(DOUT006),
                .RST(RST));
   // ============================================================================
   assign         SET007   = (NID == 8'd7) ? SET : 6'b0;
   assign         MRE007   = (NID == 8'd7) ? MRE : 6'b0;
   assign         START007 = (NID == 8'd7) ? START : `DISABLE;

   dunit dunit7(.CLK(CLK),
                .SET(SET007), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT007),
                .ID(8'd7), .START(START007),
                .IREQ(IREQ007), .IRDY(IRDY007), .DIN(DIN007),
                .OREQ(OREQ007), .ORDY(ORDY007), .DOUT(DOUT007),
                .RST(RST));

   // ============================================================================
   assign         SET008   = (NID == 8'd8) ? SET : 6'b0;
   assign         MRE008   = (NID == 8'd8) ? MRE : 6'b0;
   assign         START008 = (NID == 8'd8) ? START : `DISABLE;

   dunit dunit8(.CLK(CLK),
                .SET(SET008), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT008),
                .ID(8'd8), .START(START008),
                .IREQ(IREQ008), .IRDY(IRDY008), .DIN(DIN008),
                .OREQ(OREQ008), .ORDY(ORDY008), .DOUT(DOUT008),
                .RST(RST));


   reg [31:0]  MDOUT;

   always@(posedge CLK) begin
      if(NID == 8'd1) begin
         MDOUT <= MDOUT001;
      end
      else if(NID == 8'd2) begin
         MDOUT <= MDOUT002;
      end
      else if(NID == 8'd3) begin
         MDOUT <= MDOUT003;
      end
      else if(NID == 8'd4) begin
         MDOUT <= MDOUT004;
      end
      else if(NID == 8'd5) begin
         MDOUT <= MDOUT005;
      end
      else if(NID == 8'd6) begin
         MDOUT <= MDOUT006;
      end
      else if(NID == 8'd7) begin
         MDOUT <= MDOUT007;
      end
      else if(NID == 8'd8) begin
         MDOUT <= MDOUT008;
      end
   end

endmodule // nrm
